/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.corext.util.OpenTypeHistory;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoFactory;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.monitor.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeHistoryManager
implements IInteractionContextListener {
    private TypeInfoFactory factory = new TypeInfoFactory();

    public void contextActivated(IInteractionContext context) {
        this.clearTypeHistory();
        for (IInteractionElement node : context.getInteresting()) {
            this.updateTypeHistory(node, true);
        }
    }

    private void updateTypeHistory(IInteractionElement node, boolean add) {
        IJavaElement element = JavaCore.create((String)node.getHandleIdentifier());
        if (element instanceof IType) {
            IType type = (IType)element;
            try {
                if (type.exists() && !type.isAnonymous() && !this.isAspectjType(type)) {
                    TypeInfo info = this.factory.create(type.getPackageFragment().getElementName().toCharArray(), type.getElementName().toCharArray(), this.enclosingTypeNames(type), type.getFlags(), this.getPath(type));
                    if (add && !OpenTypeHistory.getInstance().contains(info)) {
                        OpenTypeHistory.getInstance().accessed(info);
                    } else {
                        OpenTypeHistory.getInstance().remove(info);
                    }
                }
            }
            catch (JavaModelException e) {
                StatusHandler.log((Throwable)e, (String)"failed to update history for a type");
            }
        }
    }

    private boolean isAspectjType(IType type) {
        return type.getHandleIdentifier().indexOf(125) != -1;
    }

    public void contextDeactivated(IInteractionContext context) {
        this.clearTypeHistory();
    }

    public void contextCleared(IInteractionContext context) {
        this.contextDeactivated(context);
    }

    public void clearTypeHistory() {
        TypeInfo[] typeInfos = OpenTypeHistory.getInstance().getTypeInfos();
        int i = 0;
        while (i < typeInfos.length) {
            OpenTypeHistory.getInstance().remove(typeInfos[i]);
            ++i;
        }
    }

    public void interestChanged(List<IInteractionElement> nodes) {
        for (IInteractionElement node : nodes) {
            this.updateTypeHistory(node, true);
        }
    }

    public void elementDeleted(IInteractionElement node) {
        this.updateTypeHistory(node, false);
    }

    public void landmarkAdded(IInteractionElement node) {
    }

    public void landmarkRemoved(IInteractionElement node) {
    }

    public void relationsChanged(IInteractionElement node) {
    }

    private String getPath(IType type) {
        String focusPath = null;
        IPackageFragmentRoot root = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        if (root.isArchive()) {
            String zipFileName;
            IPath jarPath = root.getPath();
            Object target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IPath)jarPath, (boolean)true);
            if (target instanceof IFile) {
                zipFileName = jarPath.toString();
            } else if (target instanceof File) {
                zipFileName = ((File)target).getPath();
            } else {
                return null;
            }
            focusPath = String.valueOf(zipFileName) + "|" + type.getFullyQualifiedName().replace('.', '/') + ".class";
        } else {
            focusPath = type.getPath().toString();
        }
        return focusPath;
    }

    private char[][] enclosingTypeNames(IType type) {
        IJavaElement parent = type.getParent();
        switch (parent.getElementType()) {
            case 6: {
                IType declaringType = type.getDeclaringType();
                if (declaringType == null) {
                    return CharOperation.NO_CHAR_CHAR;
                }
                return CharOperation.arrayConcat((char[][])this.enclosingTypeNames(declaringType), (char[])declaringType.getElementName().toCharArray());
            }
            case 5: {
                return CharOperation.NO_CHAR_CHAR;
            }
            case 8: 
            case 9: 
            case 10: {
                IType declaringClass = ((IMember)parent).getDeclaringType();
                return CharOperation.arrayConcat((char[][])this.enclosingTypeNames(declaringClass), (char[][])new char[][]{declaringClass.getElementName().toCharArray(), IIndexConstants.ONE_STAR});
            }
            case 7: {
                return CharOperation.arrayConcat((char[][])this.enclosingTypeNames((IType)parent), (char[])parent.getElementName().toCharArray());
            }
        }
        return null;
    }
}

