/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.java.ui.ActiveFoldingEditorTracker;
import org.eclipse.mylyn.internal.java.ui.InterestInducingProblemListener;
import org.eclipse.mylyn.internal.java.ui.InterestUpdateDeltaListener;
import org.eclipse.mylyn.internal.java.ui.JavaEditingMonitor;
import org.eclipse.mylyn.internal.java.ui.JavaUiUtil;
import org.eclipse.mylyn.internal.java.ui.LandmarkMarkerManager;
import org.eclipse.mylyn.internal.java.ui.TypeHistoryManager;
import org.eclipse.mylyn.internal.java.ui.editor.ActiveFoldingListener;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.monitor.ui.MonitorUiPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JavaUiBridgePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.mylyn.java.ui";
    private static JavaUiBridgePlugin INSTANCE;
    private ResourceBundle resourceBundle;
    private ActiveFoldingEditorTracker editorTracker;
    private TypeHistoryManager typeHistoryManager = null;
    private LandmarkMarkerManager landmarkMarkerManager = new LandmarkMarkerManager();
    private InterestInducingProblemListener problemListener = new InterestInducingProblemListener();
    private JavaEditingMonitor javaEditingMonitor;
    private InterestUpdateDeltaListener javaElementChangeListener = new InterestUpdateDeltaListener();
    final IInteractionContextListener PREFERENCES_WIZARD_LISTENER = new IInteractionContextListener(){

        public void contextActivated(IInteractionContext context) {
        }

        public void contextCleared(IInteractionContext context) {
        }

        public void contextDeactivated(IInteractionContext context) {
        }

        public void elementDeleted(IInteractionElement element) {
        }

        public void interestChanged(List<IInteractionElement> elements) {
        }

        public void landmarkAdded(IInteractionElement element) {
        }

        public void landmarkRemoved(IInteractionElement element) {
        }

        public void relationsChanged(IInteractionElement element) {
        }
    };

    public JavaUiBridgePlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initDefaultPrefs();
        if (this.getPreferenceStore().getBoolean("org.eclipse.mylyn.ui.first.run.0_4_9")) {
            this.getPreferenceStore().setValue("org.eclipse.mylyn.ui.first.run.0_4_9", false);
            JavaUiUtil.installContentAssist(JavaPlugin.getDefault().getPreferenceStore(), true);
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    ContextCorePlugin.getContextManager().addListener((IInteractionContextListener)JavaUiBridgePlugin.this.landmarkMarkerManager);
                    try {
                        JavaUiBridgePlugin.this.typeHistoryManager = new TypeHistoryManager();
                        ContextCorePlugin.getContextManager().addListener((IInteractionContextListener)JavaUiBridgePlugin.this.typeHistoryManager);
                    }
                    catch (Throwable t) {
                        StatusHandler.log((Throwable)t, (String)"Could not install type history manager, incompatible Eclipse version.");
                    }
                    if (JavaUiBridgePlugin.this.getPreferenceStore().getBoolean("org.eclipse.mylyn.java.ui.interest.prediction.errors")) {
                        JavaUiBridgePlugin.this.problemListener.enable();
                    }
                    JavaUiBridgePlugin.this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)JavaUiBridgePlugin.this.problemListener);
                    JavaUiBridgePlugin.this.javaEditingMonitor = new JavaEditingMonitor();
                    MonitorUiPlugin.getDefault().getSelectionMonitors().add(JavaUiBridgePlugin.this.javaEditingMonitor);
                    JavaUiBridgePlugin.this.installEditorTracker(workbench);
                    JavaCore.addElementChangedListener((IElementChangedListener)JavaUiBridgePlugin.this.javaElementChangeListener);
                }
                catch (Throwable t) {
                    StatusHandler.fail((Throwable)t, (String)"Mylar Java plug-in initialization failed", (boolean)true);
                }
            }
        });
    }

    private void initDefaultPrefs() {
        this.getPreferenceStore().setDefault("org.eclipse.mylyn.java.ui.interest.prediction.errors", false);
        this.getPreferenceStore().setDefault("org.eclipse.mylyn.ui.first.run.0_4_9", true);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            super.stop(context);
            INSTANCE = null;
            this.resourceBundle = null;
            ContextCorePlugin.getContextManager().removeListener((IInteractionContextListener)this.typeHistoryManager);
            ContextCorePlugin.getContextManager().removeListener((IInteractionContextListener)this.landmarkMarkerManager);
            MonitorUiPlugin.getDefault().getSelectionMonitors().remove((Object)this.javaEditingMonitor);
            JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)"Mylar Java stop terminated abnormally", (boolean)false);
        }
    }

    private void installEditorTracker(IWorkbench workbench) {
        this.editorTracker = new ActiveFoldingEditorTracker();
        this.editorTracker.install(workbench);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = 0;
        int n2 = iWorkbenchWindowArray.length;
        while (n < n2) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n];
            IWorkbenchPage page = w.getActivePage();
            if (page != null) {
                IEditorReference[] references = page.getEditorReferences();
                int i = 0;
                while (i < references.length) {
                    IEditorPart part = references[i].getEditor(false);
                    if (part != null && part instanceof JavaEditor) {
                        JavaEditor editor = (JavaEditor)part;
                        this.editorTracker.registerEditor(editor);
                        ActiveFoldingListener.resetProjection(editor);
                    }
                    ++i;
                }
            }
            ++n;
        }
    }

    public static JavaUiBridgePlugin getDefault() {
        return INSTANCE;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = JavaUiBridgePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.mylyn.java.JavaPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public ActiveFoldingEditorTracker getEditorTracker() {
        return this.editorTracker;
    }
}

