/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaOutlinePage;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaUiBridge
extends AbstractContextUiBridge {
    private Field javaOutlineField = null;

    public JavaUiBridge() {
        try {
            this.javaOutlineField = JavaOutlinePage.class.getDeclaredField("fOutlineViewer");
            this.javaOutlineField.setAccessible(true);
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)"could not get install Mylar on Outline viewer", (boolean)true);
        }
    }

    public void open(IInteractionElement node) {
        IJavaElement javaElement = JavaCore.create((String)node.getHandleIdentifier());
        if (javaElement == null || !javaElement.exists()) {
            return;
        }
        try {
            IEditorPart part = JavaUI.openInEditor((IJavaElement)javaElement);
            JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)javaElement);
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)("Could not open editor for: " + node), (boolean)true);
        }
    }

    public void close(IInteractionElement node) {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null) {
                IEditorReference[] references = page.getEditorReferences();
                int i = 0;
                while (i < references.length) {
                    JavaEditor editor;
                    Object adapter;
                    IEditorPart part = references[i].getEditor(false);
                    if (part != null && part instanceof JavaEditor && (adapter = (editor = (JavaEditor)part).getEditorInput().getAdapter(IJavaElement.class)) instanceof IJavaElement && node.getHandleIdentifier().equals(((IJavaElement)adapter).getHandleIdentifier())) {
                        editor.close(true);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)"Could not auto close editor.", (boolean)false);
        }
    }

    public boolean acceptsEditor(IEditorPart editorPart) {
        return editorPart instanceof JavaEditor;
    }

    public IInteractionElement getElement(IEditorInput input) {
        Object adapter = input.getAdapter(IJavaElement.class);
        if (adapter instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)adapter;
            String handle = ContextCorePlugin.getDefault().getStructureBridge((Object)javaElement).getHandleIdentifier((Object)javaElement);
            return ContextCorePlugin.getContextManager().getElement(handle);
        }
        return null;
    }

    public List<TreeViewer> getContentOutlineViewers(IEditorPart editorPart) {
        JavaOutlinePage page;
        if (editorPart == null || this.javaOutlineField == null) {
            return null;
        }
        ArrayList<TreeViewer> viewers = new ArrayList<TreeViewer>();
        Object out = editorPart.getAdapter(IContentOutlinePage.class);
        if (out instanceof JavaOutlinePage && (page = (JavaOutlinePage)out).getControl() != null) {
            try {
                viewers.add((TreeViewer)this.javaOutlineField.get(page));
            }
            catch (Exception e) {
                StatusHandler.log((Throwable)e, (String)"could not get outline viewer");
            }
        }
        return viewers;
    }

    public Object getObjectForTextSelection(TextSelection selection, IEditorPart editor) {
        if (editor instanceof JavaEditor) {
            TextSelection textSelection = selection;
            try {
                if (selection != null) {
                    return SelectionConverter.resolveEnclosingElement((JavaEditor)((JavaEditor)editor), (ITextSelection)textSelection);
                }
                Object element = ((JavaEditor)editor).getEditorInput().getAdapter(IJavaElement.class);
                if (element instanceof IJavaElement) {
                    return element;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public String getContentType() {
        return "java";
    }
}

