/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.views;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.ui.internal.misc.StringMatcher;

public class QuickOutlinePatternAndInterestFilter
extends ViewerFilter {
    private InterestFilter interestFilter = new InterestFilter();
    private StringMatcher stringMatcher = null;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean isInteresting = this.interestFilter.select(viewer, parentElement, element);
        if (!isInteresting) {
            return false;
        }
        if (this.stringMatcher == null || !(viewer instanceof TreeViewer)) {
            return true;
        }
        TreeViewer treeViewer = (TreeViewer)viewer;
        String matchName = ((ILabelProvider)treeViewer.getLabelProvider()).getText(element);
        if (matchName != null && this.stringMatcher.match(matchName)) {
            return true;
        }
        return this.hasUnfilteredChild(treeViewer, element);
    }

    private boolean hasUnfilteredChild(TreeViewer viewer, Object element) {
        Object[] children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(element);
        int i = 0;
        while (i < children.length) {
            if (this.select((Viewer)viewer, element, children[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setStringMatcher(StringMatcher stringMatcher) {
        this.stringMatcher = stringMatcher;
    }
}

