/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.ui.actions.TaskContextAction;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskSelectionDialog;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class ContextCopyAction
extends TaskContextAction {
    private static final String ID_ACTION = "org.eclipse.mylyn.context.ui.task.copy.context.to";

    public ContextCopyAction() {
        this.setText("Copy to...");
        this.setToolTipText("Copy Task Context to...");
        this.setId(ID_ACTION);
        this.setImageDescriptor(TasksUiImages.CONTEXT_TRANSFER);
    }

    public void init(IViewPart view) {
    }

    public void run() {
        this.run(this.getSelectedTask(this.selection));
    }

    public void run(IAction action) {
        this.run(this.getSelectedTask(this.selection));
    }

    public void run(AbstractTask sourceTask) {
        if (sourceTask == null) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylyn Information", (String)"No source task selected.");
            return;
        }
        TaskSelectionDialog dialog = new TaskSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setTitle("Select Target Task");
        dialog.setMessage("&Select the target task (? = any character, * = any String):");
        if (dialog.open() != 0) {
            return;
        }
        Object result = dialog.getFirstResult();
        AbstractTask targetTask = null;
        if (result instanceof AbstractTask) {
            targetTask = (AbstractTask)result;
        }
        if (targetTask != null) {
            TasksUiPlugin.getTaskListManager().deactivateAllTasks();
            InteractionContext source = ContextCorePlugin.getContextManager().loadContext(sourceTask.getHandleIdentifier());
            if (targetTask.equals((Object)sourceTask)) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylyn Information", (String)"Target task can not be the same as source task.");
            } else if (source == null) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylyn Information", (String)"Source task does not have a context.");
            } else {
                ContextCorePlugin.getContextManager().cloneContext(sourceTask.getHandleIdentifier(), targetTask.getHandleIdentifier());
                TasksUiPlugin.getTaskListManager().activateTask(targetTask);
                TaskListView view = TaskListView.getFromActivePerspective();
                if (view != null) {
                    view.refresh();
                }
            }
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylyn Information", (String)"No target task selected.");
        }
    }
}

