/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.wizards.ContextAttachWizard;
import org.eclipse.mylyn.tasks.core.AbstractAttachmentHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class ContextAttachAction
extends Action
implements IViewActionDelegate {
    private AbstractTask task;
    private TaskRepository repository;
    private AbstractRepositoryConnector connector;
    private static final String ID_ACTION = "org.eclipse.mylyn.context.ui.repository.task.attach";

    public ContextAttachAction() {
        this.setText("Attach...");
        this.setToolTipText("Attach Task Context");
        this.setId(ID_ACTION);
        this.setImageDescriptor(TasksUiImages.CONTEXT_ATTACH);
    }

    public void init(IViewPart view) {
    }

    public void run() {
        this.run((IAction)this);
    }

    public void run(IAction action) {
        if (this.task == null) {
            return;
        }
        this.run(this.task);
    }

    public void run(AbstractTask task) {
        if (task.getSynchronizationState() != AbstractTask.RepositoryTaskSyncState.SYNCHRONIZED) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylyn Information", (String)"Task must be synchronized before attaching context");
            return;
        }
        ContextAttachWizard wizard = new ContextAttachWizard(task);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (shell != null && !shell.isDisposed()) {
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.setTitle("Attach context");
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 1) {
                dialog.close();
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        AbstractTask selectedTask = TaskListView.getSelectedTask((ISelection)selection);
        if (selectedTask != null) {
            this.task = selectedTask;
            this.repository = TasksUiPlugin.getRepositoryManager().getRepository(this.task.getConnectorKind(), this.task.getRepositoryUrl());
            this.connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.task.getConnectorKind());
            AbstractAttachmentHandler handler = this.connector.getAttachmentHandler();
            action.setEnabled(handler != null && handler.canUploadAttachment(this.repository, this.task) && (this.task.isActive() || ContextCorePlugin.getContextManager().hasContext(this.task.getHandleIdentifier())));
        } else {
            this.task = null;
            action.setEnabled(false);
        }
    }
}

