/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.ColorMap;
import org.eclipse.mylyn.internal.context.ui.Highlighter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;

public class UiUtil {
    public static void initializeViewerSelection(IViewPart viewPart) {
        ISelectionProvider selectionProvider = viewPart.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            ISelection selection = selectionProvider.getSelection();
            try {
                if (selection != null) {
                    selectionProvider.setSelection(selection);
                } else {
                    selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public static void displayInterestManipulationFailure() {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Mylyn Interest Manipulation", (String)"Not a valid landmark, select an element within this resource instead.");
    }

    @Deprecated
    public static Color getBackgroundForElement(IInteractionElement node) {
        return UiUtil.getBackgroundForElement(node, false);
    }

    @Deprecated
    public static Color getBackgroundForElement(IInteractionElement node, boolean resolveContextColor) {
        if (node == null) {
            return null;
        }
        if (!resolveContextColor && (node.getInterest().isPropagated() || node.getInterest().isPredicted())) {
            return null;
        }
        if (!node.getInterest().isInteresting()) {
            return null;
        }
        boolean isMultiple = false;
        String contextId = ContextCorePlugin.getContextManager().getDominantContextHandleForElement(node);
        if (contextId != null) {
            Highlighter highlighter = ContextUiPlugin.getDefault().getHighlighterForContextId(contextId);
            if (highlighter == null) {
                return null;
            }
            if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ui.interest.intersection")) {
                if (isMultiple) {
                    return null;
                }
                return null;
            }
            return highlighter.getHighlight(node, false);
        }
        return ColorMap.BACKGROUND_COLOR;
    }
}

