/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class TaskListInterestFilter
extends AbstractTaskListFilter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Object parent, Object child) {
        try {
            AbstractTask task;
            if (child instanceof ScheduledTaskContainer) {
                ScheduledTaskContainer dateRangeTaskContainer = (ScheduledTaskContainer)child;
                return this.isDateRangeInteresting(dateRangeTaskContainer);
            }
            if (child instanceof AbstractTask) {
                AbstractTask task2 = null;
                if (child instanceof AbstractTask) {
                    task2 = (AbstractTask)child;
                }
                if (task2 == null) return false;
                if (!this.isInteresting(parent, task2)) return false;
                return true;
            }
            if (!(child instanceof AbstractTaskContainer)) return false;
            Set children = ((AbstractTaskContainer)child).getChildren();
            if (children.size() == 0) {
                return false;
            }
            Iterator iterator = children.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.shouldAlwaysShow(child, task = (AbstractTask)iterator.next(), 10));
            return true;
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Interest filter failed", t));
        }
        return false;
    }

    private boolean isDateRangeInteresting(ScheduledTaskContainer scheduleContainer) {
        if (TasksUiPlugin.getTaskActivityManager().isWeekDay(scheduleContainer) && (scheduleContainer.isPresent() || scheduleContainer.isFuture())) {
            return true;
        }
        return scheduleContainer.isPresent() && scheduleContainer.isCaptureFloating();
    }

    protected boolean isInteresting(Object parent, AbstractTask task) {
        return this.shouldAlwaysShow(parent, task, 10);
    }

    public boolean shouldAlwaysShow(Object parent, AbstractTask task, int depth) {
        return task.isActive() || TaskActivityManager.getInstance().isCompletedToday(task) || TaskListInterestFilter.hasChanges(parent, task) || !task.isCompleted() && ("New Task".equals(task.getSummary()) || TaskListInterestFilter.shouldShowInFocusedWorkweekDateContainer(parent, task) || TaskActivityManager.getInstance().isOverdue(task) || TaskListInterestFilter.isInterestingForThisWeek(parent, task) || this.hasInterestingSubTasks(parent, task, depth));
    }

    private boolean hasInterestingSubTasks(Object parent, AbstractTask task, int depth) {
        if (depth > 0) {
            if (!TasksUiPlugin.getDefault().groupSubtasks((AbstractTaskContainer)task)) {
                return false;
            }
            if (task.getChildren() != null && task.getChildren().size() > 0) {
                for (AbstractTask subTask : task.getChildren()) {
                    if (!this.shouldAlwaysShow(parent, subTask, depth - 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean shouldShowInFocusedWorkweekDateContainer(Object parent, AbstractTask task) {
        if (parent instanceof ScheduledTaskContainer) {
            if (((ScheduledTaskContainer)parent).isCaptureFloating()) {
                return true;
            }
            if (!TasksUiPlugin.getTaskActivityManager().isWeekDay((ScheduledTaskContainer)parent)) {
                return false;
            }
            if (TaskActivityManager.getInstance().isOverdue(task) || task.isPastReminder()) {
                return true;
            }
            ScheduledTaskContainer container = (ScheduledTaskContainer)parent;
            Calendar previousCal = TasksUiPlugin.getTaskActivityManager().getActivityPrevious().getEnd();
            Calendar nextCal = TasksUiPlugin.getTaskActivityManager().getActivityNextWeek().getStart();
            if (container.getEnd().compareTo(previousCal) > 0 && container.getStart().compareTo(nextCal) < 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInterestingForThisWeek(Object parent, AbstractTask task) {
        if (parent instanceof ScheduledTaskContainer) {
            return TaskListInterestFilter.shouldShowInFocusedWorkweekDateContainer(parent, task);
        }
        return task.isPastReminder() || TasksUiPlugin.getTaskActivityManager().isScheduledForThisWeek(task) || TasksUiPlugin.getTaskActivityManager().isDueThisWeek(task) || TasksUiPlugin.getTaskActivityManager().isScheduledForToday(task);
    }

    public static boolean hasChanges(Object parent, AbstractTask task) {
        if (parent instanceof ScheduledTaskContainer && !TaskListInterestFilter.shouldShowInFocusedWorkweekDateContainer(parent, task)) {
            return false;
        }
        boolean result = false;
        if (task != null) {
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.OUTGOING) {
                return true;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING && !(parent instanceof ScheduledTaskContainer)) {
                return true;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.CONFLICT) {
                return true;
            }
            return TaskListInterestFilter.hasChangesHelper(parent, (AbstractTaskContainer)task);
        }
        return result;
    }

    private static boolean hasChangesHelper(Object parent, AbstractTaskContainer container) {
        boolean result = false;
        for (AbstractTask task : container.getChildren()) {
            if (task == null) continue;
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.OUTGOING) {
                result = true;
                continue;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING && !(parent instanceof ScheduledTaskContainer)) {
                result = true;
                continue;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.CONFLICT) {
                result = true;
                continue;
            }
            if (task.getChildren() == null || task.getChildren().size() <= 0) continue;
            result = TaskListInterestFilter.hasChangesHelper(parent, (AbstractTaskContainer)task);
        }
        return result;
    }
}

