/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.mylyn.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener4;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextPerspectiveManager
implements ITaskActivityListener,
IPerspectiveListener4 {
    private Set<String> managedPerspectiveIds = new HashSet<String>();
    private Set<String> actionSetsToSuppress = new HashSet<String>();

    public ContextPerspectiveManager() {
        this.actionSetsToSuppress.add("org.eclipse.ui.edit.text.actionSet.annotationNavigation");
        this.actionSetsToSuppress.add("org.eclipse.ui.edit.text.actionSet.convertLineDelimitersTo");
        this.actionSetsToSuppress.add("org.eclipse.ui.externaltools.ExternalToolsSet");
    }

    public void addManagedPerspective(String id) {
        this.managedPerspectiveIds.add(id);
    }

    public void removeManagedPerspective(String id) {
        this.managedPerspectiveIds.remove(id);
    }

    public void taskActivated(AbstractTask task) {
        try {
            IWorkbenchWindow launchingWindow = MonitorUiPlugin.getDefault().getLaunchingWorkbenchWindow();
            if (launchingWindow != null) {
                IPerspectiveDescriptor descriptor = launchingWindow.getActivePage().getPerspective();
                ContextUiPlugin.getDefault().setPerspectiveIdFor(null, descriptor.getId());
                String perspectiveId = ContextUiPlugin.getDefault().getPerspectiveIdFor(task);
                this.showPerspective(perspectiveId);
            }
        }
        catch (Exception exception) {}
    }

    public void taskDeactivated(AbstractTask task) {
        try {
            IWorkbenchWindow launchingWindow;
            if (PlatformUI.isWorkbenchRunning() && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.perspectives.auto.manage") && (launchingWindow = MonitorUiPlugin.getDefault().getLaunchingWorkbenchWindow()) != null) {
                IPerspectiveDescriptor descriptor = launchingWindow.getActivePage().getPerspective();
                ContextUiPlugin.getDefault().setPerspectiveIdFor(task, descriptor.getId());
                String previousPerspectiveId = ContextUiPlugin.getDefault().getPerspectiveIdFor(null);
                this.showPerspective(previousPerspectiveId);
            }
        }
        catch (Exception exception) {}
    }

    private void showPerspective(String perspectiveId) {
        if (perspectiveId != null && !"".equals(perspectiveId) && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.perspectives.auto.manage")) {
            IWorkbenchWindow launchingWindow = MonitorUiPlugin.getDefault().getLaunchingWorkbenchWindow();
            try {
                try {
                    if (launchingWindow != null) {
                        launchingWindow.getShell().setRedraw(false);
                        PlatformUI.getWorkbench().showPerspective(perspectiveId, launchingWindow);
                    }
                }
                catch (Exception exception) {
                    if (launchingWindow != null) {
                        launchingWindow.getShell().setRedraw(true);
                    }
                }
            }
            finally {
                if (launchingWindow != null) {
                    launchingWindow.getShell().setRedraw(true);
                }
            }
        }
    }

    public void activityChanged(ScheduledTaskContainer week) {
    }

    public void taskListRead() {
    }

    public void tasksActivated(List<AbstractTask> tasks) {
    }

    public void calendarChanged() {
    }

    public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.cleanActionSets(page, perspective);
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspectiveDescriptor) {
        this.cleanActionSets(page, perspectiveDescriptor);
    }

    private void cleanActionSets(IWorkbenchPage page, IPerspectiveDescriptor perspectiveDescriptor) {
        if (this.managedPerspectiveIds.contains(perspectiveDescriptor.getId()) && page instanceof WorkbenchPage) {
            IActionSetDescriptor[] actionSetDescriptors;
            Perspective perspective = ((WorkbenchPage)page).getActivePerspective();
            HashSet<IActionSetDescriptor> toRemove = new HashSet<IActionSetDescriptor>();
            IActionSetDescriptor[] iActionSetDescriptorArray = actionSetDescriptors = ((WorkbenchPage)page).getActionSets();
            int n = actionSetDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                IActionSetDescriptor actionSetDescriptor = iActionSetDescriptorArray[n2];
                if (this.actionSetsToSuppress.contains(actionSetDescriptor.getId())) {
                    toRemove.add(actionSetDescriptor);
                }
                ++n2;
            }
            perspective.turnOffActionSets(toRemove.toArray(new IActionSetDescriptor[toRemove.size()]));
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }
}

