/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.preview.adapter.internal.core;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IJavaRuntime;
import org.eclipse.jst.server.preview.adapter.internal.Messages;
import org.eclipse.wst.server.core.model.RuntimeDelegate;
import org.osgi.framework.Bundle;

public class PreviewRuntime
extends RuntimeDelegate
implements IJavaRuntime {
    public static final String ID = "org.eclipse.jst.server.preview.runtime";
    protected static final String PROP_VM_INSTALL_TYPE_ID = "vm-install-type-id";
    protected static final String PROP_VM_INSTALL_ID = "vm-install-id";

    protected static Path getPluginPath(Bundle bundle) {
        try {
            URL installURL = bundle.getEntry("/");
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new Path(localURL.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static IPath getJarredPluginPath(Bundle bundle) {
        Path runtimeLibFullPath = null;
        String jarPluginLocation = bundle.getLocation().substring(7);
        Path jarPluginPath = new Path(jarPluginLocation);
        if (jarPluginPath.isAbsolute()) {
            runtimeLibFullPath = jarPluginPath;
        } else {
            int ind = jarPluginLocation.lastIndexOf(":");
            if (ind > 0) {
                jarPluginLocation = jarPluginLocation.substring(ind + 1);
            }
            String installPath = Platform.getInstallLocation().getURL().getPath();
            runtimeLibFullPath = new Path(String.valueOf(installPath) + "/" + jarPluginLocation);
        }
        return runtimeLibFullPath;
    }

    protected String getVMInstallTypeId() {
        return this.getAttribute(PROP_VM_INSTALL_TYPE_ID, null);
    }

    protected String getVMInstallId() {
        return this.getAttribute(PROP_VM_INSTALL_ID, null);
    }

    public void setDefaults(IProgressMonitor monitor) {
        this.getRuntimeWorkingCopy().setLocation((IPath)new Path(""));
    }

    public boolean isUsingDefaultJRE() {
        return this.getVMInstallTypeId() == null;
    }

    public IVMInstall getVMInstall() {
        if (this.getVMInstallTypeId() == null) {
            return JavaRuntime.getDefaultVMInstall();
        }
        try {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)this.getVMInstallTypeId());
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int size = vmInstalls.length;
            String id = this.getVMInstallId();
            int i = 0;
            while (i < size) {
                if (id.equals(vmInstalls[i].getId())) {
                    return vmInstalls[i];
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        if (this.getVMInstall() == null) {
            return new Status(4, "org.eclipse.jst.server.preview.adapter", 0, Messages.errorJRE, null);
        }
        return Status.OK_STATUS;
    }

    public void setVMInstall(IVMInstall vmInstall) {
        if (vmInstall == null) {
            this.setVMInstall(null, null);
        } else {
            this.setVMInstall(vmInstall.getVMInstallType().getId(), vmInstall.getId());
        }
    }

    protected void setVMInstall(String typeId, String id) {
        if (typeId == null) {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, typeId);
        }
        if (id == null) {
            this.setAttribute(PROP_VM_INSTALL_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_ID, id);
        }
    }
}

