/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.utils;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FavoriteConfigurations {
    private static Logger _log = JSFUICommonPlugin.getLogger(FavoriteConfigurations.class);
    private static final String FAV_EXTENSIONS = ".xml";
    private static final String ELEMENT_ROOT = "favorite";
    private static final String ELEMENT_CONFIG = "config";
    private static final String ELEMENT_NAME = "name";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ELEMENT_VALUE = "value";
    private Map _favorites;
    private IPath _favoriteFile;
    private String _favoriteName;

    public FavoriteConfigurations(AbstractUIPlugin plugin, String favoriteName) {
        this._favoriteFile = plugin.getStateLocation().append(String.valueOf(FavoriteConfigurations.scanFileName(favoriteName)) + FAV_EXTENSIONS);
        this.readFavorites();
    }

    public Properties getFavorite(String name) {
        return (Properties)this._favorites.get(name);
    }

    public void saveFavorites() {
        block16: {
            OutputStreamWriter fw = null;
            try {
                try {
                    XMLMemento memento = XMLMemento.createWriteRoot((String)ELEMENT_ROOT);
                    for (String favName : this._favorites.keySet()) {
                        HashMap<Object, Object> props = new HashMap<Object, Object>((Properties)this._favorites.get(favName));
                        IMemento config = memento.createChild(ELEMENT_CONFIG);
                        config.putString(ELEMENT_NAME, favName);
                        Iterator it1 = props.keySet().iterator();
                        while (it1.hasNext()) {
                            IMemento entry = config.createChild(ELEMENT_PROPERTY);
                            String name = (String)it1.next();
                            entry.putString(ELEMENT_NAME, name);
                            entry.putString(ELEMENT_VALUE, (String)props.get(name));
                        }
                    }
                    fw = new FileWriter(this._favoriteFile.toFile());
                    memento.save((Writer)fw);
                }
                catch (Exception ee) {
                    _log.info("log.FavoriteConfigurations.save.error", this._favoriteName, this._favoriteFile.toOSString(), ee);
                    if (fw != null) {
                        try {
                            fw.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addFavorite(String name, Properties config) {
        this._favorites.put(name, config);
    }

    public void removeFavorite(String name) {
        this._favorites.remove(name);
    }

    protected void readFavorites() {
        block19: {
            this._favorites = new HashMap();
            InputStreamReader fr = null;
            try {
                try {
                    try {
                        fr = new FileReader(this._favoriteFile.toFile());
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                    if (fr != null) {
                        XMLMemento memento = XMLMemento.createReadRoot((Reader)fr);
                        IMemento[] children = memento.getChildren(ELEMENT_CONFIG);
                        int ii = 0;
                        while (ii < children.length) {
                            Properties props = new Properties();
                            IMemento config = children[ii];
                            String name = config.getString(ELEMENT_NAME);
                            IMemento[] configProperties = config.getChildren(ELEMENT_PROPERTY);
                            int jj = 0;
                            while (jj < configProperties.length) {
                                IMemento entry = configProperties[jj];
                                this.setProperty(props, entry.getString(ELEMENT_NAME), entry.getString(ELEMENT_VALUE));
                                ++jj;
                            }
                            this._favorites.put(name, props);
                            ++ii;
                        }
                    }
                }
                catch (Exception ee) {
                    _log.error("log.FavoriteConfigurations.read.error", this._favoriteName, this._favoriteFile.toOSString(), ee);
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setProperty(Properties props, String name, String value) {
        if (name != null && value != null) {
            props.setProperty(name, value);
        }
    }

    public String[] getFavoritesList() {
        Object[] objs = this._favorites.keySet().toArray();
        Object[] names = new String[objs.length];
        int ii = 0;
        while (ii < objs.length) {
            names[ii] = (String)objs[ii];
            ++ii;
        }
        Arrays.sort(names);
        return names;
    }

    private static String scanFileName(String filename) {
        StringBuffer strBuf = new StringBuffer();
        char[] chars = filename.toCharArray();
        int ii = 0;
        while (ii < chars.length) {
            switch (chars[ii]) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '&': 
                case '\'': 
                case '.': 
                case '/': 
                case ':': 
                case '@': 
                case '\\': {
                    strBuf.append('_');
                    break;
                }
                default: {
                    strBuf.append(chars[ii]);
                }
            }
            ++ii;
        }
        return strBuf.toString();
    }
}

