/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.dialogs.TreeViewerSelectionDialog;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.common.ui.internal.utils.WebrootUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CommonResourceDialog
extends TreeViewerSelectionDialog {
    private static Logger _log = JSFUICommonPlugin.getLogger(CommonResourceDialog.class);
    private IProject _project = null;
    private String[] _suffixs = null;
    private CommonResourceFilter _filter = null;
    private String _resourceDescription = null;
    private IFolder _folder;

    public CommonResourceDialog(Shell parentShell, IProject project, int style) {
        super(parentShell, "", style);
        if (project == null) {
            throw new IllegalArgumentException("Argument(project) cannot be null");
        }
        this._project = project;
        this.setContentProvider(new ProjectFileDialogContentProvider());
        this.setLabelProvider(WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this._filter = new CommonResourceFilter();
        this.setFilter(this._filter);
        this._project = project;
        this.setStatusMessage(this.getStatusMessage());
    }

    public CommonResourceDialog(Shell parentShell, IProject project) {
        this(parentShell, project, 0);
    }

    public CommonResourceDialog(Shell parentShell, IFolder folder, int style) {
        this(parentShell, folder == null ? null : folder.getProject(), style);
        this._folder = folder;
    }

    protected String getStatusMessage() {
        if (this._resourceDescription == null) {
            return "";
        }
        return this._resourceDescription;
    }

    protected Object findInputElement() {
        if (this._folder != null) {
            return new Object[]{this._folder};
        }
        return new Object[]{this._project};
    }

    protected boolean isValidSelection(Object selection) {
        if (selection instanceof Object[]) {
            int i = 0;
            int n = ((Object[])selection).length;
            while (i < n) {
                if (this.isValidElement(((Object[])selection)[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return this.isValidElement(selection);
    }

    private boolean isValidElement(Object selection) {
        if (selection instanceof IFile) {
            if (this.isSuffixBlank()) {
                return true;
            }
            if (this._suffixs != null && Arrays.asList(this._suffixs).contains(((IFile)selection).getFileExtension().toLowerCase())) {
                return true;
            }
        }
        return false;
    }

    public Object[] getResult() {
        Object[] objects = super.getResult();
        if (objects == null || objects.length == 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof IFile) {
                list.add(objects[i]);
            }
            ++i;
        }
        return list.toArray();
    }

    public void setSuffixs(String[] suffixs) {
        this._suffixs = this.convertTolowercase(suffixs);
        this._filter.setSuffixs(this._suffixs);
        this.setStatusMessage(this.getStatusMessage());
    }

    private String[] convertTolowercase(String[] suffixs) {
        if (suffixs != null) {
            String[] newSuffixs = new String[suffixs.length];
            int i = 0;
            while (i < suffixs.length) {
                newSuffixs[i] = suffixs[i].toLowerCase();
                ++i;
            }
            return newSuffixs;
        }
        return null;
    }

    public void setFilter(String[] suffixs, String sourceDescription) {
        this.setSuffixs(suffixs);
        this.setResourceDescription(sourceDescription);
    }

    public String getResourceDescription() {
        return this._resourceDescription;
    }

    public void setResourceDescription(String sourceDescription) {
        this._resourceDescription = sourceDescription;
        this.setStatusMessage(this.getStatusMessage());
    }

    private boolean isSuffixBlank() {
        boolean isSuffixBlank = false;
        if (this._suffixs == null) {
            isSuffixBlank = true;
        } else {
            int count = 0;
            int i = 0;
            int size = this._suffixs.length;
            while (i < size) {
                if (this._suffixs[i] != null && !"".equals(this._suffixs[i])) {
                    ++count;
                    break;
                }
                ++i;
            }
            if (count == 0) {
                isSuffixBlank = true;
            }
        }
        return isSuffixBlank;
    }

    class CommonResourceFilter
    extends ViewerFilter {
        private String[] _suffixs = null;
        Logger _log = JSFUICommonPlugin.getLogger(CommonResourceFilter.class);

        CommonResourceFilter() {
        }

        public String[] getSuffixs() {
            return this._suffixs;
        }

        public void setSuffixs(String[] _suffixs) {
            this._suffixs = _suffixs;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                if (!WebrootUtil.isUnderWebContentFolder((IResource)file)) {
                    return false;
                }
                if (CommonResourceDialog.this.isSuffixBlank()) {
                    return true;
                }
                if (file.getFileExtension() == null) return false;
                if (!Arrays.asList(this._suffixs).contains(file.getFileExtension().toLowerCase())) return false;
                return true;
            }
            if (!(element instanceof IContainer)) return false;
            if (!((IContainer)element).isAccessible()) {
                return false;
            }
            if (element instanceof IProject) {
                return true;
            }
            if (!(element instanceof IFolder)) return false;
            IContainer container = (IContainer)element;
            try {
                IResource[] members = container.members();
                int i = 0;
                while (true) {
                    if (i >= members.length) {
                        return false;
                    }
                    if (this.select(viewer, members[i].getParent(), members[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                this._log.error("Error.ProjectFileDialogContentProvider.0", e);
                return false;
            }
        }
    }

    class ProjectFileDialogContentProvider
    implements ITreeContentProvider {
        ProjectFileDialogContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object element) {
            IContainer container;
            if (element instanceof Object[]) {
                return (Object[])element;
            }
            if (element instanceof IContainer && (container = (IContainer)element).isAccessible()) {
                try {
                    return container.members();
                }
                catch (CoreException e) {
                    _log.error("Error.ProjectFileDialogContentProvider.0", e);
                }
            }
            return new Object[0];
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

