/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogFieldResources;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldChangeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DialogFieldBase
implements DialogField {
    private Label _label = null;
    private Label _requiredLabel = null;
    protected String _labelText = "";
    private IDialogFieldChangeListener _dialogFieldChangeListener;
    private IDialogFieldApplyListener _dialogFieldApplyListener;
    private boolean _enabled = true;
    private FontMetrics _fontMetrics;
    private IHyperlinkListener _listener;
    private Hyperlink _hyperlink = null;
    private Map _attachedData;
    private boolean _isRequired;
    private String toolTip;

    public void setHyperLink(IHyperlinkListener listener) {
        if (this._label != null) {
            throw new RuntimeException("The Label instance does not support the listener");
        }
        this._listener = listener;
    }

    public void setLabelText(String labeltext) {
        String string = this._labelText = labeltext == null ? "" : labeltext;
        if (this._label != null && !this._label.isDisposed()) {
            this._label.setText(this._labelText);
        } else if (this._hyperlink != null && !this._hyperlink.isDisposed()) {
            this._hyperlink.setText(this._labelText);
        }
    }

    protected Shell getShell() {
        if (this._label != null && !this._label.isDisposed()) {
            return this._label.getShell();
        }
        if (this._hyperlink != null && !this._hyperlink.isDisposed()) {
            return this._hyperlink.getShell();
        }
        return null;
    }

    public final void setDialogFieldChangeListener(IDialogFieldChangeListener listener) {
        this._dialogFieldChangeListener = listener;
    }

    public final void setDialogFieldApplyListener(IDialogFieldApplyListener listener) {
        this._dialogFieldApplyListener = listener;
    }

    public void dialogFieldChangedAndApplied() {
        if (this._dialogFieldChangeListener != null) {
            this._dialogFieldChangeListener.dialogFieldChanged(this);
        }
        if (this._dialogFieldApplyListener != null) {
            this._dialogFieldApplyListener.dialogFieldApplied(this);
        }
    }

    public void dialogFieldChanged() {
        if (this._dialogFieldChangeListener != null) {
            this._dialogFieldChangeListener.dialogFieldChanged(this);
        }
    }

    public void dialogFieldApplied() {
        if (this._dialogFieldApplyListener != null) {
            this._dialogFieldApplyListener.dialogFieldApplied(this);
        }
    }

    public boolean setFocus() {
        return false;
    }

    public Control[] doFillIntoGrid(FormToolkit toolkit, Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Control label = this.getLabelControl(toolkit, parent);
        label.setLayoutData((Object)DialogFieldBase.gridDataForLabel(nColumns));
        return new Control[]{label};
    }

    protected FontMetrics getDialogUnits(Control control) {
        if (this._fontMetrics == null) {
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            this._fontMetrics = gc.getFontMetrics();
            gc.dispose();
        }
        return this._fontMetrics;
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected static GridData gridDataForLabel(int span) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        return gd;
    }

    public Control getLabelControl(FormToolkit _formToolkit, Composite parent) {
        Object control = null;
        if (this._label == null && this._hyperlink == null) {
            this.assertCompositeNotNull(parent);
            String label = null;
            label = this._labelText != null && !"".equals(this._labelText) ? this._labelText : ".";
            control = this._listener == null ? this.createLabel(_formToolkit, parent, label) : this.createHyperlink(_formToolkit, parent, label);
            control.setFont(parent.getFont());
            control.setEnabled(this._enabled);
        } else {
            control = this._label != null ? this._label : this._hyperlink;
        }
        return control;
    }

    public Control getRequiredLabelControl(FormToolkit _formToolkit, Composite parent) {
        if (this._requiredLabel == null) {
            if (_formToolkit == null) {
                this._requiredLabel = new Label(parent, 16448);
            } else {
                this._requiredLabel = _formToolkit.createLabel(parent, "", 16448);
                this._requiredLabel.setForeground(this.getLabelColor());
            }
            if (this._isRequired) {
                this._requiredLabel.setText(DialogFieldResources.getInstance().getString("DialogFieldBase.Label.RequiredSymbol"));
            }
        }
        return this._requiredLabel;
    }

    private Control createLabel(FormToolkit _formToolkit, Composite parent, String labelString) {
        if (_formToolkit == null) {
            this._label = new Label(parent, 16448);
            this._label.setText(labelString);
        } else {
            this._label = _formToolkit.createLabel(parent, labelString, 16448);
            this._label.setForeground(this.getLabelColor());
        }
        return this._label;
    }

    private Color getLabelColor() {
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.startsWith("mac os")) {
            return Display.getCurrent().getSystemColor(24);
        }
        return Display.getCurrent().getSystemColor(26);
    }

    private Control createHyperlink(FormToolkit _formToolkit, Composite parent, String label) {
        if (_formToolkit == null) {
            this._hyperlink = new Hyperlink(parent, 16448);
            this._hyperlink.setForeground(this.getLabelColor());
            this._hyperlink.setUnderlined(true);
            this._hyperlink.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    DialogFieldBase.this._hyperlink.setForeground(Display.getCurrent().getSystemColor(9));
                }

                public void mouseExit(MouseEvent e) {
                    DialogFieldBase.this._hyperlink.setForeground(DialogFieldBase.this.getLabelColor());
                }
            });
            this._hyperlink.setText(label);
        } else {
            this._hyperlink = _formToolkit.createHyperlink(parent, label, 16448);
        }
        this._hyperlink.addHyperlinkListener(this._listener);
        return this._hyperlink;
    }

    public Control createEmptySpace(FormToolkit toolkit, Composite parent) {
        return this.createEmptySpace(toolkit, parent, 1);
    }

    public Control createEmptySpace(FormToolkit toolkit, Composite parent, int span) {
        Label label = toolkit != null ? toolkit.createLabel(parent, "") : new Label(parent, 16384);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.horizontalIndent = 0;
        gd.widthHint = 0;
        gd.heightHint = 0;
        label.setLayoutData((Object)gd);
        return label;
    }

    protected final boolean isOkToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    public final void setEnabled(boolean enabled) {
        if (enabled != this._enabled) {
            this._enabled = enabled;
            this.updateEnableState();
        }
    }

    protected void updateEnableState() {
        if (this._label != null && !this._label.isDisposed()) {
            this._label.setEnabled(this._enabled);
        }
        if (this._hyperlink != null && !this._hyperlink.isDisposed()) {
            this._hyperlink.setEnabled(this._enabled);
        }
    }

    public final boolean isEnabled() {
        return this._enabled;
    }

    protected final void assertCompositeNotNull(Composite comp) {
        Assert.isNotNull((Object)comp, (String)"uncreated control requested with composite null");
    }

    protected final void assertEnoughColumns(int nColumns) {
        Assert.isTrue((nColumns >= this.getNumberOfControls() ? 1 : 0) != 0, (String)"given number of columns is too small");
    }

    public Object getAttachedData(Object key) {
        if (this._attachedData != null) {
            return this._attachedData.get(key);
        }
        return null;
    }

    public void putAttachedData(Object key, Object value) {
        if (this._attachedData == null) {
            this._attachedData = new HashMap();
        }
        this._attachedData.put(key, value);
    }

    public void handleGrabHorizontal() {
    }

    public boolean isRequired() {
        return this._isRequired;
    }

    public void setRequired(boolean isRequired) {
        this._isRequired = isRequired;
    }

    protected String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }
}

