/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ColorPalette;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StyleComboDialogField;
import org.eclipse.jst.jsf.common.ui.internal.utils.StyleCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ColorButtonDialogField
extends StyleComboDialogField {
    private Button _button;
    private boolean _buttonEnabled = true;
    private Color _color;
    private RGB _colorValue;
    private StyleCombo _combo;
    private Image _emptyImage;
    private Point _extent;
    private Image _image;
    private ColorPalette _colorPalette;

    public ColorButtonDialogField(int flags, ColorPalette colorPalette) {
        super(flags);
        this._colorPalette = colorPalette;
    }

    private void buttonPressed() {
        ColorDialog colorDialog = new ColorDialog(this._button.getShell());
        colorDialog.setRGB(this._colorValue);
        RGB newColor = colorDialog.open();
        if (newColor != null && !newColor.equals((Object)this._colorValue)) {
            this._colorValue = newColor;
            this.setText(ColorPalette.getStringColor(newColor));
            this.updateColorImage();
        }
    }

    private Point computeImageSize(Control window) {
        GC gc = new GC((Drawable)window);
        Font f = this._button.getFont();
        gc.setFont(f);
        int height = gc.getFontMetrics().getHeight();
        Point p = new Point(height * 3 - 6, height - 2);
        gc.dispose();
        return p;
    }

    private void disposeResources() {
        if (this._image != null) {
            this._image.dispose();
            this._image = null;
        }
        if (this._emptyImage != null) {
            this._emptyImage.dispose();
            this._emptyImage = null;
        }
        if (this._color != null) {
            this._color.dispose();
            this._color = null;
        }
    }

    public Control[] doFillIntoGrid(FormToolkit toolkit, Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Control requiredLabel = this.getRequiredLabelControl(toolkit, parent);
        requiredLabel.setLayoutData((Object)ColorButtonDialogField.gridDataForLabel(1));
        Control label = this.getLabelControl(toolkit, parent);
        label.setLayoutData((Object)ColorButtonDialogField.gridDataForLabel(1));
        StyleCombo combo = this.getComboControl(toolkit, parent);
        combo.setLayoutData(ColorButtonDialogField.gridDataForCombo(nColumns - 3));
        this._button = this.getChangeControl(toolkit, parent);
        this._button.setLayoutData((Object)this.gridDataForButton(1));
        return new Control[]{requiredLabel, label, combo, this._button};
    }

    public void enableButton(boolean enable) {
        if (this.isOkToUse((Control)this._button)) {
            this._button.setEnabled(this.isEnabled() && enable);
        }
        this._buttonEnabled = enable;
    }

    public Button getChangeControl(FormToolkit toolkit, Composite parent) {
        if (this._button == null) {
            this.assertCompositeNotNull(parent);
            this._button = toolkit != null ? toolkit.createButton(parent, "", 8) : new Button(parent, 8);
            this._button.setEnabled(this.isEnabled() && this._buttonEnabled);
            this._button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ColorButtonDialogField.this.buttonPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    ColorButtonDialogField.this.buttonPressed();
                }
            });
            this._button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ColorButtonDialogField.this.disposeResources();
                }
            });
            this._extent = this.computeImageSize((Control)parent);
            this._image = new Image((Device)parent.getDisplay(), this._extent.x, this._extent.y);
            this._emptyImage = new Image((Device)parent.getDisplay(), this._extent.x, this._extent.y);
            this.initEmptyImage((Control)this._button);
            this.updateColorImage();
        }
        return this._button;
    }

    private String[] getColorList() {
        Map map = this._colorPalette.getExtendedColorMap();
        ArrayList list = new ArrayList(map.keySet());
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    public StyleCombo getComboControl(FormToolkit toolkit, Composite parent) {
        if (this._combo == null) {
            this._combo = super.getComboControl(toolkit, parent);
            this._combo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ColorButtonDialogField.this.updateImageAfterChanged();
                }

                public void widgetSelected(SelectionEvent e) {
                    ColorButtonDialogField.this.updateImageAfterChanged();
                }
            });
            this._combo.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    ColorButtonDialogField.this.updateImageAfterChanged();
                }
            });
            this._combo.setItems(this.getColorList());
        }
        return this._combo;
    }

    public int getNumberOfControls() {
        return 4;
    }

    public StyleCombo getTextControl(FormToolkit toolkit, Composite parent) {
        return this.getComboControl(toolkit, parent);
    }

    protected GridData gridDataForButton(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.widthHint = LayoutUtil.getButtonWidthHint(this._button);
        gd.heightHint = this._combo.computeSize((int)-1, (int)-1).y;
        return gd;
    }

    private void initEmptyImage(Control parent) {
        Color transparentColor = parent.getForeground();
        ImageData imageData = this._emptyImage.getImageData();
        imageData.transparentPixel = 0;
        GC gc = new GC((Drawable)this._emptyImage);
        gc.setBackground(transparentColor);
        gc.fillRectangle(0, 0, this._emptyImage.getBounds().width, this._emptyImage.getBounds().height);
    }

    public void setColorValue(RGB rgb) {
        this._colorValue = rgb;
    }

    public void setTextWithoutUpdate(String text) {
        super.setTextWithoutUpdate(text);
        this.updateImageAfterChanged();
    }

    protected void updateColorImage() {
        if (this._button.isDisposed()) {
            return;
        }
        if (this._colorValue == null) {
            this._button.setImage(this._emptyImage);
            return;
        }
        Display display = this._button.getDisplay();
        GC gc = new GC((Drawable)this._image);
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(0, 0, this._extent.x - 1, this._extent.y - 1);
        if (this._color != null) {
            this._color.dispose();
        }
        this._color = new Color((Device)display, this._colorValue);
        gc.setBackground(this._color);
        gc.fillRectangle(1, 1, this._extent.x - 2, this._extent.y - 2);
        gc.dispose();
        this._button.setImage(this._image);
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this._button)) {
            this._button.setEnabled(this.isEnabled() && this._buttonEnabled);
        }
    }

    private void updateImageAfterChanged() {
        String newColor = this.getText().trim();
        this.setColorValue(this._colorPalette.getExtendedColorRGB(newColor));
        this.updateColorImage();
    }
}

