/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationListIterator<E1, E2>
implements ListIterator<E2> {
    private final ListIterator<? extends E1> nestedIterator;
    private final Transformer<E1, ? extends E2> transformer;

    public TransformationListIterator(ListIterator<? extends E1> nestedIterator) {
        this(nestedIterator, Transformer.Null.instance());
    }

    public TransformationListIterator(ListIterator<? extends E1> nestedIterator, Transformer<E1, ? extends E2> transformer) {
        this.nestedIterator = nestedIterator;
        this.transformer = transformer;
    }

    @Override
    public boolean hasNext() {
        return this.nestedIterator.hasNext();
    }

    @Override
    public E2 next() {
        return this.transform(this.nestedIterator.next());
    }

    @Override
    public int nextIndex() {
        return this.nestedIterator.nextIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.nestedIterator.hasPrevious();
    }

    @Override
    public E2 previous() {
        return this.transform(this.nestedIterator.previous());
    }

    @Override
    public int previousIndex() {
        return this.nestedIterator.previousIndex();
    }

    @Override
    public void add(E2 o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E2 o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        this.nestedIterator.remove();
    }

    protected E2 transform(E1 next) {
        return this.transformer.transform(next);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.nestedIterator);
    }
}

