/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jpt.core.internal.mappings.IAbstractJoinColumn;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJoinColumnDialog<E extends IAbstractJoinColumn>
extends Dialog {
    private E joinColumn;
    private Combo nameCombo;
    private Combo referencedColumnNameCombo;
    private boolean defaultNameSelected;
    private String selectedName;
    private boolean defaultReferencedColumnNameSelected;
    private String selectedReferencedColumnName;

    AbstractJoinColumnDialog(Shell parent) {
        super(parent);
    }

    AbstractJoinColumnDialog(Shell parent, E joinColumn) {
        super(parent);
        this.joinColumn = joinColumn;
    }

    protected String getAddTitle() {
        return JptUiMappingsMessages.JoinColumnDialog_addJoinColumn;
    }

    protected String getEditTitle() {
        return JptUiMappingsMessages.JoinColumnDialog_editJoinColumn;
    }

    protected Control createDialogArea(Composite parent) {
        if (this.joinColumn == null) {
            this.getShell().setText(this.getAddTitle());
        } else {
            this.getShell().setText(this.getEditTitle());
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 2;
        Label nameLabel = new Label(composite, 16384);
        nameLabel.setText(JptUiMappingsMessages.JoinColumnDialog_name);
        GridData gridData = new GridData();
        nameLabel.setLayoutData((Object)gridData);
        this.nameCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.nameCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.nameCombo, "org.eclipse.jpt.ui.mapping_joinColumnName");
        this.populateNameCombo();
        Label referencedColumnNameLabel = new Label(composite, 16384);
        referencedColumnNameLabel.setText(JptUiMappingsMessages.JoinColumnDialog_referencedColumnName);
        gridData = new GridData();
        referencedColumnNameLabel.setLayoutData((Object)gridData);
        this.referencedColumnNameCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.referencedColumnNameCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.referencedColumnNameCombo, "org.eclipse.jpt.ui.mapping_joinReferencedColumn");
        this.populateReferencedNameCombo();
        return composite;
    }

    protected void populateNameCombo() {
        Table table;
        this.nameCombo.removeAll();
        if (this.getJoinColumn() != null) {
            this.nameCombo.add(NLS.bind((String)JptUiMappingsMessages.JoinColumnDialog_defaultWithOneParam, (Object)this.getJoinColumn().getDefaultName()));
        }
        if ((table = this.getNameTable()) != null) {
            Iterator i = table.columnNames();
            while (i.hasNext()) {
                this.nameCombo.add((String)i.next());
            }
        }
        if (this.getJoinColumn() != null) {
            if (this.getJoinColumn().getSpecifiedName() != null) {
                this.nameCombo.setText(this.getJoinColumn().getSpecifiedName());
            } else {
                this.nameCombo.select(0);
            }
        }
    }

    protected Combo getNameCombo() {
        return this.nameCombo;
    }

    protected Combo getReferencedColumnNameCombo() {
        return this.referencedColumnNameCombo;
    }

    protected abstract Table getNameTable();

    protected abstract Table getReferencedNameTable();

    protected void populateReferencedNameCombo() {
        Table referencedNameTable;
        if (this.getJoinColumn() != null) {
            this.referencedColumnNameCombo.add(NLS.bind((String)JptUiMappingsMessages.JoinColumnDialog_defaultWithOneParam, (Object)this.getJoinColumn().getDefaultReferencedColumnName()));
        }
        if ((referencedNameTable = this.getReferencedNameTable()) != null) {
            Iterator i = referencedNameTable.columnNames();
            while (i.hasNext()) {
                this.referencedColumnNameCombo.add((String)i.next());
            }
        }
        if (this.getJoinColumn() != null) {
            if (this.getJoinColumn().getSpecifiedReferencedColumnName() != null) {
                this.referencedColumnNameCombo.setText(this.getJoinColumn().getSpecifiedReferencedColumnName());
            } else {
                this.referencedColumnNameCombo.select(0);
            }
        }
    }

    protected E getJoinColumn() {
        return this.joinColumn;
    }

    protected boolean isDefaultNameSelected() {
        return this.defaultNameSelected;
    }

    protected String getSelectedName() {
        return this.selectedName;
    }

    protected boolean isDefaultReferencedColumnNameSelected() {
        return this.defaultReferencedColumnNameSelected;
    }

    protected String getReferencedColumnName() {
        return this.selectedReferencedColumnName;
    }

    public boolean close() {
        this.defaultNameSelected = this.nameCombo.getSelectionIndex() == 0;
        this.selectedName = this.nameCombo.getText();
        this.defaultReferencedColumnNameSelected = this.referencedColumnNameCombo.getSelectionIndex() == 0;
        this.selectedReferencedColumnName = this.referencedColumnNameCombo.getText();
        return super.close();
    }
}

