/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IManagedConnectionListener;
import org.eclipse.jpt.db.internal.Connection;
import org.eclipse.jpt.db.internal.ConnectionListener;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;

public final class DTPConnectionWrapper
extends Connection {
    private final IManagedConnection dtpConnection;
    private LocalConnectionListener connectionListener;

    DTPConnectionWrapper(IManagedConnection dtpConnection) {
        this.dtpConnection = dtpConnection;
        this.initialize();
    }

    protected void initialize() {
        this.connectionListener = new LocalConnectionListener();
        this.dtpConnection.addConnectionListener((IManagedConnectionListener)this.connectionListener);
    }

    protected void dispose() {
        this.dtpConnection.removeConnectionListener((IManagedConnectionListener)this.connectionListener);
    }

    public String getName() {
        return this.dtpConnection.getConnection().getConnectionProfile().getName();
    }

    public boolean isConnected() {
        return this.dtpConnection.isConnected();
    }

    public String getFactoryId() {
        return this.dtpConnection.getFactoryID();
    }

    void databaseChanged(Database database, int eventType) {
        this.connectionListener.databaseChanged(database, eventType);
    }

    void schemaChanged(Schema schema, Database database, int eventType) {
        this.connectionListener.schemaChanged(schema, database, eventType);
    }

    void tableChanged(Table table, Schema schema, Database database, int eventType) {
        this.connectionListener.tableChanged(table, schema, database, eventType);
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListener.addConnectionListener(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListener.removeConnectionListener(listener);
    }

    private class LocalConnectionListener
    implements IManagedConnectionListener {
        private Collection<ConnectionListener> listeners = new ArrayList<ConnectionListener>();

        LocalConnectionListener() {
        }

        void addConnectionListener(ConnectionListener listener) {
            this.listeners.add(listener);
        }

        void removeConnectionListener(ConnectionListener listener) {
            this.listeners.remove(listener);
        }

        public void aboutToClose(ConnectEvent event) {
            for (ConnectionListener listener : this.listeners) {
                listener.aboutToClose(DTPConnectionWrapper.this);
            }
        }

        public void closed(ConnectEvent event) {
            for (ConnectionListener listener : this.listeners) {
                listener.closed(DTPConnectionWrapper.this);
            }
        }

        public void modified(ConnectEvent event) {
            for (ConnectionListener listener : this.listeners) {
                listener.modified(DTPConnectionWrapper.this);
            }
        }

        public boolean okToClose(ConnectEvent event) {
            for (ConnectionListener listener : this.listeners) {
                if (listener.okToClose(DTPConnectionWrapper.this)) continue;
                return false;
            }
            return true;
        }

        public void opened(ConnectEvent event) {
            for (ConnectionListener listener : this.listeners) {
                listener.opened(DTPConnectionWrapper.this);
            }
        }

        void databaseChanged(Database database, int eventType) {
            for (ConnectionListener listener : this.listeners) {
                listener.databaseChanged(DTPConnectionWrapper.this, database);
            }
        }

        void schemaChanged(Schema schema, Database database, int eventType) {
            for (ConnectionListener listener : this.listeners) {
                listener.schemaChanged(DTPConnectionWrapper.this, schema);
            }
        }

        void tableChanged(Table table, Schema schema, Database database, int eventType) {
            for (ConnectionListener listener : this.listeners) {
                listener.tableChanged(DTPConnectionWrapper.this, table);
            }
        }
    }
}

