/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.text.Collator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.db.internal.Column;
import org.eclipse.jpt.db.internal.DTPWrapper;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Catalog
extends DTPWrapper
implements Comparable<Catalog> {
    private final Database database;
    final org.eclipse.datatools.modelbase.sql.schema.Catalog dtpCatalog;
    private ICatalogObjectListener catalogListener;

    Catalog(Database database, org.eclipse.datatools.modelbase.sql.schema.Catalog dtpCatalog) {
        this.database = database;
        this.dtpCatalog = dtpCatalog;
    }

    @Override
    protected boolean connectionIsOnline() {
        return this.database.connectionIsOnline();
    }

    private ICatalogObjectListener buildCatalogListener() {
        return new ICatalogObjectListener(){

            public void notifyChanged(ICatalogObject catalog, int eventType) {
            }
        };
    }

    @Override
    protected void dispose() {
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.schema.Catalog catalog) {
        return this.dtpCatalog == catalog;
    }

    @Override
    public String getName() {
        return this.dtpCatalog.getName();
    }

    boolean isCaseSensitive() {
        return this.database.isCaseSensitive();
    }

    Column column(org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn) {
        return this.database.column(dtpColumn);
    }

    synchronized Set<Schema> buildSchemata() {
        EList<org.eclipse.datatools.modelbase.sql.schema.Schema> dtpSchemata = this.dtpSchemata();
        HashSet<Schema> result = new HashSet<Schema>(dtpSchemata.size());
        for (org.eclipse.datatools.modelbase.sql.schema.Schema dtpSchema : dtpSchemata) {
            result.add(this.wrap(dtpSchema));
        }
        return result;
    }

    private EList<org.eclipse.datatools.modelbase.sql.schema.Schema> dtpSchemata() {
        return this.dtpCatalog.getSchemas();
    }

    private Schema wrap(org.eclipse.datatools.modelbase.sql.schema.Schema schema) {
        return new Schema(this.database, schema);
    }

    @Override
    public int compareTo(Catalog catalog) {
        return Collator.getInstance().compare(this.getName(), catalog.getName());
    }
}

