/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class AddExceptionDialog
extends FilteredItemsSelectionDialog {
    private static final String SETTINGS_ID = String.valueOf(JDIDebugUIPlugin.getUniqueIdentifier()) + ".ADD_EXCEPTION_DIALOG";
    public static final String SETTING_CAUGHT_CHECKED = "caughtChecked";
    public static final String SETTING_UNCAUGHT_CHECKED = "uncaughtChecked";
    private Button fCaughtButton;
    private Button fUncaughtButton;
    private boolean fCaught = false;
    private boolean fUncaught = false;
    private TypeInfoUtil fTypeInfoUtil = new TypeInfoUtil();
    static /* synthetic */ Class class$0;

    public AddExceptionDialog() {
        super(JDIDebugUIPlugin.getShell(), false);
        this.setTitle(BreakpointMessages.AddExceptionAction_0);
        this.setMessage(BreakpointMessages.AddExceptionAction_1);
        this.setInitialPattern("*Exception*");
        this.setSelectionHistory(new ExceptionSelectionHistory());
        ExceptionLabelProvider lp = new ExceptionLabelProvider();
        this.setListLabelProvider((ILabelProvider)lp);
        this.setListSelectionLabelDecorator(lp);
        this.setDetailsLabelProvider((ILabelProvider)new ExceptionDetailsLabelProvider());
    }

    protected Control createDialogArea(Composite parent) {
        Control ctrl = super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(ctrl, IJavaDebugHelpContextIds.ADD_EXCEPTION_DIALOG);
        return ctrl;
    }

    public boolean shouldHandleCaughtExceptions() {
        return this.fCaught;
    }

    public boolean shouldHandleUncaughtExceptions() {
        return this.fUncaught;
    }

    protected Control createExtendedContentArea(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 768);
        this.fCaughtButton = SWTFactory.createCheckButton(comp, BreakpointMessages.AddExceptionDialog_15, null, this.getDialogSettings().getBoolean(SETTING_CAUGHT_CHECKED), 1);
        this.fCaughtButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AddExceptionDialog.this.fCaught = AddExceptionDialog.this.fCaughtButton.getSelection();
            }
        });
        this.fUncaughtButton = SWTFactory.createCheckButton(comp, BreakpointMessages.AddExceptionDialog_16, null, this.getDialogSettings().getBoolean(SETTING_UNCAUGHT_CHECKED), 1);
        this.fUncaughtButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AddExceptionDialog.this.fUncaught = AddExceptionDialog.this.fUncaughtButton.getSelection();
            }
        });
        return comp;
    }

    protected void okPressed() {
        this.fCaught = this.fCaughtButton.getSelection();
        this.fUncaught = this.fUncaughtButton.getSelection();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SETTING_CAUGHT_CHECKED, this.fCaught);
        settings.put(SETTING_UNCAUGHT_CHECKED, this.fUncaught);
        super.okPressed();
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ExceptionItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        progressMonitor.setTaskName(BreakpointMessages.AddExceptionDialog_10);
        SearchEngine engine = new SearchEngine(null);
        engine.searchAllTypeNames(null, 0, null, 0, 5, SearchEngine.createWorkspaceScope(), (TypeNameMatchRequestor)new ExceptionTypeNameRequestor(contentProvider, itemsFilter), 3, progressMonitor);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_ID);
        if (section == null) {
            section = settings.addNewSection(SETTINGS_ID);
            section.put(SETTING_CAUGHT_CHECKED, true);
            section.put(SETTING_UNCAUGHT_CHECKED, true);
        }
        return section;
    }

    public String getElementName(Object item) {
        if (item instanceof TypeNameMatch) {
            return ((TypeNameMatch)item).getSimpleTypeName();
        }
        return null;
    }

    protected Comparator getItemsComparator() {
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof TypeNameMatch && o2 instanceof TypeNameMatch) {
                    return ((TypeNameMatch)o1).getSimpleTypeName().compareTo(((TypeNameMatch)o2).getSimpleTypeName());
                }
                return -1;
            }
        };
        return comp;
    }

    protected IStatus validateItem(Object item) {
        if (item instanceof TypeNameMatch) {
            IType type = ((TypeNameMatch)item).getType();
            try {
                ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                IType curr = type;
                while (curr != null) {
                    if ("java.lang.Throwable".equals(curr.getFullyQualifiedName('.'))) {
                        return Status.OK_STATUS;
                    }
                    curr = hierarchy.getSuperclass(curr);
                }
            }
            catch (JavaModelException e) {
                JDIDebugUIPlugin.log(e);
                return Status.CANCEL_STATUS;
            }
        }
        return new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), BreakpointMessages.AddExceptionDialog_13);
    }

    class ExceptionDetailsLabelProvider
    extends ExceptionLabelProvider {
        ExceptionDetailsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof TypeNameMatch) {
                return AddExceptionDialog.this.fTypeInfoUtil.getQualificationText((TypeNameMatch)element);
            }
            return super.getText(element);
        }

        protected IJavaElement getDeclaringContainer(IType type) {
            IType outer = type.getDeclaringType();
            if (outer == null) {
                outer = type.getPackageFragment();
            }
            return outer;
        }

        public Image getImage(Object element) {
            if (element instanceof TypeNameMatch) {
                return super.getImage(this.getDeclaringContainer(((TypeNameMatch)element).getType()));
            }
            return super.getImage(element);
        }
    }

    class ExceptionItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        ExceptionItemsFilter() {
            super((FilteredItemsSelectionDialog)AddExceptionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return item instanceof IType;
        }

        public boolean matchItem(Object item) {
            TypeNameMatch tname;
            IType type;
            if (item instanceof TypeNameMatch && (type = (tname = (TypeNameMatch)item).getType()) != null) {
                return this.matches(type.getElementName());
            }
            return false;
        }
    }

    public class ExceptionLabelProvider
    extends LabelProvider
    implements ILabelDecorator {
        HashMap fImageMap = new HashMap();

        public Image getImage(Object element) {
            IType type = null;
            if (element instanceof TypeNameMatch) {
                type = ((TypeNameMatch)element).getType();
            }
            if (element instanceof IAdaptable) {
                type = (IAdaptable)element;
            }
            if (type != null) {
                IWorkbenchAdapter adapter;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (IWorkbenchAdapter)type.getAdapter((Class)clazz)) != null) {
                    ImageDescriptor descriptor = adapter.getImageDescriptor((Object)type);
                    Image image = (Image)this.fImageMap.get(descriptor);
                    if (image == null) {
                        image = descriptor.createImage();
                        this.fImageMap.put(descriptor, image);
                    }
                    return image;
                }
            }
            return null;
        }

        public String getText(Object element) {
            if (!(element instanceof TypeNameMatch)) {
                return super.getText(element);
            }
            return AddExceptionDialog.this.fTypeInfoUtil.getText((TypeNameMatch)element);
        }

        public String decorateText(String text, Object element) {
            if (!(element instanceof TypeNameMatch)) {
                return null;
            }
            return AddExceptionDialog.this.fTypeInfoUtil.getQualifiedText((TypeNameMatch)element);
        }

        public void dispose() {
            if (this.fImageMap != null) {
                Iterator iterator = this.fImageMap.values().iterator();
                while (iterator.hasNext()) {
                    Image image = (Image)iterator.next();
                    image.dispose();
                }
                this.fImageMap.clear();
            }
            this.fImageMap = null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image decorateImage(Image image, Object element) {
            return null;
        }
    }

    class ExceptionSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        ExceptionSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            IJavaElement element = JavaCore.create((String)memento.getTextData());
            return element instanceof IType ? element : null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
            if (item instanceof IType) {
                memento.putTextData(((IType)item).getHandleIdentifier());
            }
        }
    }

    public class ExceptionTypeNameRequestor
    extends TypeNameMatchRequestor {
        private FilteredItemsSelectionDialog.AbstractContentProvider fContentProvider;
        private FilteredItemsSelectionDialog.ItemsFilter fFilter;

        public ExceptionTypeNameRequestor(FilteredItemsSelectionDialog.AbstractContentProvider provider, FilteredItemsSelectionDialog.ItemsFilter filter) {
            this.fContentProvider = provider;
            this.fFilter = filter;
        }

        public void acceptTypeNameMatch(TypeNameMatch match) {
            this.fContentProvider.add((Object)match, this.fFilter);
        }
    }

    private static class TypeInfoUtil {
        private Map fLib2Name = new HashMap();
        private String[] fInstallLocations;
        private String[] fVMNames;

        public TypeInfoUtil() {
            ArrayList locations = new ArrayList();
            ArrayList labels = new ArrayList();
            IVMInstallType[] installs = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < installs.length) {
                this.processVMInstallType(installs[i], locations, labels);
                ++i;
            }
            this.fInstallLocations = locations.toArray(new String[locations.size()]);
            this.fVMNames = labels.toArray(new String[labels.size()]);
        }

        private void processVMInstallType(IVMInstallType installType, List locations, List labels) {
            if (installType != null) {
                IVMInstall[] installs = installType.getVMInstalls();
                boolean isMac = "macosx".equals(Platform.getOS());
                int i = 0;
                while (i < installs.length) {
                    String label = this.getFormattedLabel(installs[i].getName());
                    LibraryLocation[] libLocations = installs[i].getLibraryLocations();
                    if (libLocations != null) {
                        this.processLibraryLocation(libLocations, label);
                    } else {
                        String filePath = installs[i].getInstallLocation().getAbsolutePath();
                        if (isMac && filePath.endsWith("/Home")) {
                            filePath = filePath.substring(0, filePath.length() - "/Home".length() + 1);
                        }
                        locations.add(filePath);
                        labels.add(label);
                    }
                    ++i;
                }
            }
        }

        private void processLibraryLocation(LibraryLocation[] libLocations, String label) {
            int l = 0;
            while (l < libLocations.length) {
                LibraryLocation location = libLocations[l];
                this.fLib2Name.put(location.getSystemLibraryPath().toOSString(), label);
                ++l;
            }
        }

        private String getFormattedLabel(String name) {
            return MessageFormat.format((String)BreakpointMessages.AddExceptionDialog_12, (Object[])new String[]{name});
        }

        public String getText(TypeNameMatch element) {
            return element.getSimpleTypeName();
        }

        public String getQualifiedText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            result.append(type.getSimpleTypeName());
            String containerName = type.getTypeContainerName();
            result.append(JavaElementLabels.CONCAT_STRING);
            if (containerName.length() > 0) {
                result.append(containerName);
            } else {
                result.append(BreakpointMessages.AddExceptionDialog_11);
            }
            return result.toString();
        }

        public String getFullyQualifiedText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            result.append(type.getSimpleTypeName());
            String containerName = type.getTypeContainerName();
            if (containerName.length() > 0) {
                result.append(JavaElementLabels.CONCAT_STRING);
                result.append(containerName);
            }
            result.append(JavaElementLabels.CONCAT_STRING);
            result.append(this.getContainerName(type));
            return result.toString();
        }

        public String getQualificationText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            String containerName = type.getTypeContainerName();
            if (containerName.length() > 0) {
                result.append(containerName);
                result.append(JavaElementLabels.CONCAT_STRING);
            }
            result.append(this.getContainerName(type));
            return result.toString();
        }

        private String getContainerName(TypeNameMatch type) {
            IPackageFragmentRoot root = type.getPackageFragmentRoot();
            if (root.isExternal()) {
                String name = root.getPath().toOSString();
                int i = 0;
                while (i < this.fInstallLocations.length) {
                    if (name.startsWith(this.fInstallLocations[i])) {
                        return this.fVMNames[i];
                    }
                    ++i;
                }
                String lib = (String)this.fLib2Name.get(name);
                if (lib != null) {
                    return lib;
                }
            }
            StringBuffer buf = new StringBuffer();
            JavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)root, (long)0x30000000000L, (StringBuffer)buf);
            return buf.toString();
        }
    }
}

