/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.StatusInfo;
import org.eclipse.jdt.internal.debug.ui.jres.IAddVMDialogRequestor;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.VMLibraryBlock;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddVMDialog
extends StatusDialog {
    private IAddVMDialogRequestor fRequestor;
    private IVMInstall fEditedVM;
    private IVMInstallType[] fVMTypes;
    private IVMInstallType fSelectedVMType;
    private Combo fVMCombo;
    private Text fVMName;
    private Text fVMArgs;
    private Text fJRERoot;
    private VMLibraryBlock fLibraryBlock;
    private URL fJavadocLocation = null;
    private boolean fAutoDetectJavadocLocation = false;
    private IStatus[] fStatus;
    private int fPrevIndex = -1;

    public AddVMDialog(IAddVMDialogRequestor requestor, Shell shell, IVMInstallType[] vmInstallTypes, IVMInstall editedVM) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRequestor = requestor;
        this.fStatus = new IStatus[5];
        int i = 0;
        while (i < this.fStatus.length) {
            this.fStatus[i] = new StatusInfo();
            ++i;
        }
        this.fVMTypes = vmInstallTypes;
        this.sortVMTypes();
        this.fSelectedVMType = editedVM != null ? editedVM.getVMInstallType() : vmInstallTypes[0];
        this.fEditedVM = editedVM;
        this.fAutoDetectJavadocLocation = this.fEditedVM == null || this.fEditedVM.getJavadocLocation() == null;
    }

    private void sortVMTypes() {
        Comparator compare = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof IVMInstallType && o2 instanceof IVMInstallType) {
                    return ((IVMInstallType)o1).getName().compareTo(((IVMInstallType)o2).getName());
                }
                return 0;
            }
        };
        int i = 0;
        while (i < this.fVMTypes.length) {
            if (this.fVMTypes[i].getId().equals("org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType")) {
                if (i <= 0) break;
                IVMInstallType tmp = this.fVMTypes[0];
                this.fVMTypes[0] = this.fVMTypes[i];
                this.fVMTypes[i] = tmp;
                break;
            }
            ++i;
        }
        if (this.fVMTypes[0].getId().equals("org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType")) {
            Arrays.sort(this.fVMTypes, 1, this.fVMTypes.length, compare);
        } else {
            Arrays.sort(this.fVMTypes, compare);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, IJavaDebugHelpContextIds.EDIT_JRE_DIALOG);
    }

    protected String getVMName() {
        return this.fVMName.getText();
    }

    protected File getInstallLocation() {
        return new File(this.fJRERoot.getText());
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = (Composite)super.createDialogArea(ancestor);
        ((GridLayout)parent.getLayout()).numColumns = 3;
        SWTFactory.createLabel(parent, JREMessages.addVMDialog_jreType, 1);
        this.fVMCombo = SWTFactory.createCombo(parent, 8, 2, this.getVMTypeNames());
        SWTFactory.createLabel(parent, JREMessages.addVMDialog_jreName, 1);
        this.fVMName = SWTFactory.createSingleText(parent, 2);
        SWTFactory.createLabel(parent, JREMessages.addVMDialog_jreHome, 1);
        this.fJRERoot = SWTFactory.createSingleText(parent, 1);
        Button browse = SWTFactory.createPushButton(parent, JREMessages.addVMDialog_browse1, null);
        SWTFactory.createLabel(parent, JREMessages.AddVMDialog_23, 1);
        this.fVMArgs = SWTFactory.createSingleText(parent, 2);
        SWTFactory.createLabel(parent, JREMessages.AddVMDialog_JRE_system_libraries__1, 3);
        this.fLibraryBlock = new VMLibraryBlock(this);
        Control block = this.fLibraryBlock.createControl(parent);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        block.setLayoutData((Object)gd);
        this.initializeFields();
        this.fVMCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AddVMDialog.this.updateVMType();
            }
        });
        this.fVMName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddVMDialog.this.validateVMName();
                AddVMDialog.this.updateStatusLine();
            }
        });
        this.fJRERoot.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddVMDialog.this.validateJRELocation();
                AddVMDialog.this.updateStatusLine();
            }
        });
        browse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(AddVMDialog.this.getShell());
                dialog.setFilterPath(AddVMDialog.this.fJRERoot.getText());
                dialog.setMessage(JREMessages.addVMDialog_pickJRERootDialog_message);
                String newPath = dialog.open();
                if (newPath != null) {
                    AddVMDialog.this.fJRERoot.setText(newPath);
                }
            }
        });
        AddVMDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void updateVMType() {
        int selIndex = this.fVMCombo.getSelectionIndex();
        if (selIndex == this.fPrevIndex) {
            return;
        }
        this.fPrevIndex = selIndex;
        if (selIndex >= 0 && selIndex < this.fVMTypes.length) {
            this.fSelectedVMType = this.fVMTypes[selIndex];
        }
        this.validateJRELocation();
        this.fLibraryBlock.initializeFrom(this.fEditedVM, this.fSelectedVMType);
        this.updateStatusLine();
    }

    public void create() {
        super.create();
        this.fVMName.setFocus();
        this.selectVMType();
    }

    private String[] getVMTypeNames() {
        String[] names = new String[this.fVMTypes.length];
        int i = 0;
        while (i < this.fVMTypes.length) {
            names[i] = this.fVMTypes[i].getName();
            ++i;
        }
        return names;
    }

    private void selectVMType() {
        int i = 0;
        while (i < this.fVMTypes.length) {
            if (this.fSelectedVMType == this.fVMTypes[i] && i < this.fVMCombo.getItemCount()) {
                this.fVMCombo.select(i);
                return;
            }
            ++i;
        }
    }

    private void initializeFields() {
        if (this.fEditedVM == null) {
            this.fVMName.setText("");
            this.fJRERoot.setText("");
            this.fLibraryBlock.initializeFrom(null, this.fSelectedVMType);
            this.fVMArgs.setText("");
        } else {
            this.fVMCombo.setEnabled(false);
            this.fVMName.setText(this.fEditedVM.getName());
            this.fJRERoot.setText(this.fEditedVM.getInstallLocation().getAbsolutePath());
            this.fLibraryBlock.initializeFrom(this.fEditedVM, this.fSelectedVMType);
            if (this.fEditedVM instanceof IVMInstall2) {
                IVMInstall2 vm2 = (IVMInstall2)this.fEditedVM;
                String vmArgs = vm2.getVMArgs();
                if (vmArgs != null) {
                    this.fVMArgs.setText(vmArgs);
                }
            } else {
                String[] vmArgs = this.fEditedVM.getVMArguments();
                if (vmArgs != null) {
                    StringBuffer buffer = new StringBuffer();
                    int length = vmArgs.length;
                    if (length > 0) {
                        buffer.append(vmArgs[0]);
                        int i = 1;
                        while (i < length) {
                            buffer.append(' ').append(vmArgs[i]);
                            ++i;
                        }
                    }
                    this.fVMArgs.setText(buffer.toString());
                }
            }
        }
        this.validateVMName();
        this.updateStatusLine();
    }

    private IStatus validateJRELocation() {
        String locationName = this.fJRERoot.getText();
        StatusInfo s = null;
        File file = null;
        if (locationName.length() == 0) {
            s = new StatusInfo(1, JREMessages.addVMDialog_enterLocation);
        } else {
            file = new File(locationName);
            if (!file.exists()) {
                s = new StatusInfo(4, JREMessages.addVMDialog_locationNotExists);
            } else {
                final IStatus[] temp = new IStatus[1];
                final File tempFile = file;
                Runnable r = new Runnable(){

                    public void run() {
                        temp[0] = AddVMDialog.this.fSelectedVMType.validateInstallLocation(tempFile);
                    }
                };
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
                s = temp[0];
            }
        }
        if (s.isOK()) {
            this.fLibraryBlock.setHomeDirectory(file);
            String name = this.fVMName.getText();
            if (name == null || name.trim().length() == 0) {
                try {
                    String genName = null;
                    Path path = new Path(file.getCanonicalPath());
                    int segs = path.segmentCount();
                    if (segs == 1) {
                        genName = path.segment(0);
                    } else if (segs >= 2) {
                        String last = path.lastSegment();
                        genName = "jre".equalsIgnoreCase(last) ? path.segment(segs - 2) : last;
                    }
                    if (genName != null) {
                        this.fVMName.setText(genName);
                    }
                }
                catch (IOException iOException) {}
            }
        } else {
            this.fLibraryBlock.setHomeDirectory(null);
        }
        this.fLibraryBlock.restoreDefaultLibraries();
        this.detectJavadocLocation();
        this.fStatus[1] = s;
        return s;
    }

    private void detectJavadocLocation() {
        if (this.fAutoDetectJavadocLocation) {
            if (this.fSelectedVMType instanceof AbstractVMInstallType) {
                AbstractVMInstallType type = (AbstractVMInstallType)this.fSelectedVMType;
                this.fJavadocLocation = type.getDefaultJavadocLocation(this.getInstallLocation());
            }
        } else {
            this.fJavadocLocation = this.fEditedVM.getJavadocLocation();
        }
    }

    private IStatus validateVMName() {
        StatusInfo status = new StatusInfo();
        String name = this.fVMName.getText();
        if (name == null || name.trim().length() == 0) {
            status.setInfo(JREMessages.addVMDialog_enterName);
        } else if (this.fRequestor.isDuplicateName(name) && (this.fEditedVM == null || !name.equals(this.fEditedVM.getName()))) {
            status.setError(JREMessages.addVMDialog_duplicateName);
        } else {
            IStatus s = ResourcesPlugin.getWorkspace().validateName(name, 1);
            if (!s.isOK()) {
                status.setError(MessageFormat.format((String)JREMessages.AddVMDialog_JRE_name_must_be_a_valid_file_name___0__1, (Object[])new String[]{s.getMessage()}));
            }
        }
        this.fStatus[0] = status;
        return status;
    }

    protected void updateStatusLine() {
        IStatus max = null;
        int i = 0;
        while (i < this.fStatus.length) {
            IStatus curr = this.fStatus[i];
            if (curr.matches(4)) {
                this.updateStatus(curr);
                return;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        this.updateStatus(max);
    }

    protected URL getURL() {
        return this.fJavadocLocation;
    }

    protected void okPressed() {
        if (this.fEditedVM == null) {
            VMStandin vm = new VMStandin(this.fSelectedVMType, this.createUniqueId(this.fSelectedVMType));
            this.setFieldValuesToVM((IVMInstall)vm);
            this.fRequestor.vmAdded((IVMInstall)vm);
        } else {
            this.setFieldValuesToVM(this.fEditedVM);
        }
        super.okPressed();
    }

    private String createUniqueId(IVMInstallType vmType) {
        String id = null;
        while (vmType.findVMInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    protected void setFieldValuesToVM(IVMInstall vm) {
        File dir = new File(this.fJRERoot.getText());
        try {
            vm.setInstallLocation(dir.getCanonicalFile());
        }
        catch (IOException iOException) {
            vm.setInstallLocation(dir.getAbsoluteFile());
        }
        vm.setName(this.fVMName.getText());
        vm.setJavadocLocation(this.getURL());
        String argString = this.fVMArgs.getText().trim();
        if (vm instanceof IVMInstall2) {
            IVMInstall2 vm2 = (IVMInstall2)vm;
            if (argString != null && argString.length() > 0) {
                vm2.setVMArgs(argString);
            } else {
                vm2.setVMArgs(null);
            }
        } else if (argString != null && argString.length() > 0) {
            vm.setVMArguments(DebugPlugin.parseArguments((String)argString));
        } else {
            vm.setVMArguments(null);
        }
        this.fLibraryBlock.performApply(vm);
    }

    protected File getAbsoluteFileOrEmpty(String path) {
        if (path == null || path.length() == 0) {
            return new File("");
        }
        return new File(path).getAbsoluteFile();
    }

    protected IStatus getSystemLibraryStatus() {
        return this.fStatus[3];
    }

    protected void setSystemLibraryStatus(IStatus status) {
        this.fStatus[3] = status;
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button ok = this.getButton(0);
        if (ok != null && !ok.isDisposed()) {
            ok.setEnabled(status.getSeverity() == 0);
        }
    }

    protected String getDialogSettingsSectionName() {
        return "ADD_VM_DIALOG_SECTION";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    protected Point getInitialSize() {
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings != null) {
            try {
                int width = settings.getInt("DIALOG_WIDTH");
                int height = settings.getInt("DIALOG_HEIGHT");
                if (width > 0 & height > 0) {
                    return new Point(width, height);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return new Point(500, 570);
            }
        }
        return new Point(500, 570);
    }

    protected void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
    }
}

