/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.RunToLineHandler;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ValidBreakpointLocationLocator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineAdapter
implements IRunToLineTarget {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        ITextEditor textEditor = this.getTextEditor(part);
        String errorMessage = null;
        if (textEditor == null) {
            errorMessage = ActionMessages.RunToLineAdapter_1;
        } else {
            IEditorInput input = textEditor.getEditorInput();
            if (input == null) {
                errorMessage = ActionMessages.RunToLineAdapter_0;
            } else {
                final IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
                if (document == null) {
                    errorMessage = ActionMessages.RunToLineAdapter_1;
                } else {
                    final int[] validLine = new int[1];
                    final String[] typeName = new String[1];
                    final int[] lineNumber = new int[1];
                    final ITextSelection textSelection = (ITextSelection)selection;
                    Runnable r = new Runnable(){

                        public void run() {
                            lineNumber[0] = textSelection.getStartLine() + 1;
                            ASTParser parser = ASTParser.newParser((int)3);
                            parser.setSource(document.get().toCharArray());
                            CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
                            ValidBreakpointLocationLocator locator = new ValidBreakpointLocationLocator(compilationUnit, lineNumber[0], false, false);
                            compilationUnit.accept((ASTVisitor)locator);
                            validLine[0] = locator.getLineLocation();
                            typeName[0] = locator.getFullyQualifiedTypeName();
                        }
                    };
                    BusyIndicator.showWhile((Display)JDIDebugUIPlugin.getStandardDisplay(), (Runnable)r);
                    if (validLine[0] == lineNumber[0]) {
                        IJavaLineBreakpoint breakpoint = null;
                        HashMap attributes = new HashMap(4);
                        BreakpointUtils.addRunToLineAttributes(attributes);
                        breakpoint = JDIDebugModel.createLineBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), (String)typeName[0], (int)lineNumber[0], (int)-1, (int)-1, (int)1, (boolean)false, attributes);
                        errorMessage = ActionMessages.RunToLineAdapter_2;
                        if (target instanceof IAdaptable) {
                            IDebugTarget debugTarget;
                            IAdaptable iAdaptable = (IAdaptable)target;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((debugTarget = (IDebugTarget)iAdaptable.getAdapter((Class)clazz)) != null) {
                                RunToLineHandler handler = new RunToLineHandler(debugTarget, target, (IBreakpoint)breakpoint);
                                handler.run((IProgressMonitor)new NullProgressMonitor());
                                return;
                            }
                        }
                    } else {
                        errorMessage = textSelection.getLength() > 0 ? ActionMessages.RunToLineAdapter_3 : ActionMessages.RunToLineAdapter_4;
                    }
                }
            }
        }
        throw new CoreException((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IDebugElement) {
            IJavaDebugTarget adapter;
            IDebugElement element = (IDebugElement)target;
            IDebugTarget iDebugTarget = element.getDebugTarget();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (adapter = (IJavaDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null;
        }
        return false;
    }

    protected ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ITextEditor)part.getAdapter((Class)clazz);
    }
}

