/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.IExpressionsListener;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.jface.viewers.Viewer;

public class ExpressionManagerModelProxy
extends AbstractModelProxy
implements IExpressionsListener {
    public void init(IPresentationContext context) {
        super.init(context);
        this.getExpressionManager().addExpressionListener((IExpressionsListener)this);
    }

    public void installed(Viewer viewer) {
        this.updateExpressions(this.getExpressionManager().getExpressions(), 0x400000);
    }

    protected IExpressionManager getExpressionManager() {
        return DebugPlugin.getDefault().getExpressionManager();
    }

    public synchronized void dispose() {
        super.dispose();
        this.getExpressionManager().removeExpressionListener((IExpressionsListener)this);
    }

    public void expressionsAdded(IExpression[] expressions) {
        this.updateExpressions(expressions, 0x400001);
    }

    public void expressionsRemoved(IExpression[] expressions) {
        this.updateExpressions(expressions, 0x800002);
    }

    public void expressionsChanged(IExpression[] expressions) {
        this.updateExpressions(expressions, 3072);
    }

    private void updateExpressions(IExpression[] expressions, int flags) {
        ModelDelta delta = new ModelDelta(this.getExpressionManager(), 0);
        int i = 0;
        while (i < expressions.length) {
            IExpression expression = expressions[i];
            delta.addNode(expression, flags);
            ++i;
        }
        this.fireModelChanged(delta);
    }
}

