/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import org.eclipse.debug.internal.core.commands.Request;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.TreeItem;

class LabelUpdate
extends Request
implements ILabelUpdate {
    private TreePath fElementPath;
    private String[] fColumnIds;
    private RGB[] fBackgrounds;
    private RGB[] fForegrounds;
    private ImageDescriptor[] fImageDescriptors;
    private String[] fLabels;
    private FontData[] fFontDatas;
    private TreeModelLabelProvider fProvider;
    private TreeItem fItem;
    private int fNumColumns;
    private IPresentationContext fContext;
    static String PREV_LABEL_KEY = "PREV_LABEL_KEY";
    static String PREV_IMAGE_KEY = "PREV_IMAGE_KEY";
    static String PREV_FONT_KEY = "PREV_FONT_KEY";
    static String PREV_FOREGROUND_KEY = "PREV_FOREGROUND_KEY";
    static String PREV_BACKGROUND_KEY = "PREV_BACKGROUND_KEY";

    public LabelUpdate(TreePath elementPath, TreeItem item, TreeModelLabelProvider provider, String[] columnIds, IPresentationContext context) {
        this.fContext = context;
        this.fElementPath = elementPath;
        this.fProvider = provider;
        this.fColumnIds = columnIds;
        this.fItem = item;
        this.fNumColumns = 1;
        if (columnIds != null) {
            this.fNumColumns = columnIds.length;
        }
        this.fLabels = new String[this.fNumColumns];
        this.fProvider.updateStarted(this);
    }

    public String[] getColumnIds() {
        return this.fColumnIds;
    }

    public TreePath getElementPath() {
        return this.fElementPath;
    }

    public void setBackground(RGB background, int columnIndex) {
        if (background == null) {
            return;
        }
        if (this.fBackgrounds == null) {
            this.fBackgrounds = new RGB[this.fNumColumns];
        }
        this.fBackgrounds[columnIndex] = background;
    }

    public void setFontData(FontData fontData, int columnIndex) {
        if (fontData == null) {
            return;
        }
        if (this.fFontDatas == null) {
            this.fFontDatas = new FontData[this.fNumColumns];
        }
        this.fFontDatas[columnIndex] = fontData;
    }

    public void setForeground(RGB foreground, int columnIndex) {
        if (foreground == null) {
            return;
        }
        if (this.fForegrounds == null) {
            this.fForegrounds = new RGB[this.fNumColumns];
        }
        this.fForegrounds[columnIndex] = foreground;
    }

    public void setImageDescriptor(ImageDescriptor image, int columnIndex) {
        if (image == null) {
            return;
        }
        if (this.fImageDescriptors == null) {
            this.fImageDescriptors = new ImageDescriptor[this.fNumColumns];
        }
        this.fImageDescriptors[columnIndex] = image;
    }

    public void setLabel(String text, int columnIndex) {
        this.fLabels[columnIndex] = text;
    }

    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    public void done() {
        this.fProvider.complete(this);
    }

    public void update() {
        if (!this.fItem.isDisposed()) {
            int i;
            int i2 = 0;
            while (i2 < this.fNumColumns) {
                this.fItem.setText(i2, this.fLabels[i2] == null ? "" : this.fLabels[i2]);
                ++i2;
            }
            this.fItem.setData(PREV_LABEL_KEY, (Object)this.fLabels);
            if (this.fImageDescriptors == null) {
                i2 = 0;
                while (i2 < this.fNumColumns) {
                    this.fItem.setImage(i2, null);
                    ++i2;
                }
                this.fItem.setData(PREV_IMAGE_KEY, null);
            } else {
                Image[] images = new Image[this.fImageDescriptors.length];
                i = 0;
                while (i < this.fImageDescriptors.length) {
                    images[i] = this.fProvider.getImage(this.fImageDescriptors[i]);
                    ++i;
                }
                if (this.fColumnIds == null) {
                    this.fItem.setImage(images[0]);
                } else {
                    this.fItem.setImage(images);
                }
                this.fItem.setData(PREV_IMAGE_KEY, (Object)images);
            }
            if (this.fForegrounds == null) {
                i = 0;
                while (i < this.fNumColumns) {
                    this.fItem.setForeground(i, null);
                    ++i;
                }
                this.fItem.setData(PREV_FOREGROUND_KEY, null);
            } else {
                Color[] foregrounds = new Color[this.fForegrounds.length];
                i = 0;
                while (i < foregrounds.length) {
                    foregrounds[i] = this.fProvider.getColor(this.fForegrounds[i]);
                    ++i;
                }
                if (this.fColumnIds == null) {
                    this.fItem.setForeground(0, foregrounds[0]);
                } else {
                    i = 0;
                    while (i < foregrounds.length) {
                        this.fItem.setForeground(i, foregrounds[i]);
                        ++i;
                    }
                }
                this.fItem.setData(PREV_FOREGROUND_KEY, (Object)foregrounds);
            }
            if (this.fBackgrounds == null) {
                i = 0;
                while (i < this.fNumColumns) {
                    this.fItem.setBackground(i, null);
                    ++i;
                }
                this.fItem.setData(PREV_BACKGROUND_KEY, null);
            } else {
                Color[] backgrounds = new Color[this.fBackgrounds.length];
                i = 0;
                while (i < backgrounds.length) {
                    backgrounds[i] = this.fProvider.getColor(this.fBackgrounds[i]);
                    ++i;
                }
                if (this.fColumnIds == null) {
                    this.fItem.setBackground(0, backgrounds[0]);
                } else {
                    i = 0;
                    while (i < backgrounds.length) {
                        this.fItem.setBackground(i, backgrounds[i]);
                        ++i;
                    }
                }
                this.fItem.setData(PREV_BACKGROUND_KEY, (Object)backgrounds);
            }
            if (this.fFontDatas == null) {
                i = 0;
                while (i < this.fNumColumns) {
                    this.fItem.setFont(i, null);
                    ++i;
                }
                this.fItem.setData(PREV_FONT_KEY, null);
            } else {
                Font[] fonts = new Font[this.fFontDatas.length];
                i = 0;
                while (i < this.fFontDatas.length) {
                    fonts[i] = this.fProvider.getFont(this.fFontDatas[i]);
                    ++i;
                }
                if (this.fColumnIds == null) {
                    this.fItem.setFont(0, fonts[0]);
                } else {
                    i = 0;
                    while (i < fonts.length) {
                        this.fItem.setFont(i, fonts[i]);
                        ++i;
                    }
                }
                this.fItem.setData(PREV_FONT_KEY, (Object)fonts);
            }
        }
        this.fProvider.updateComplete(this);
    }

    public Object getElement() {
        return this.getElementPath().getLastSegment();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ILabelUpdate: ");
        buf.append(this.getElement());
        return buf.toString();
    }
}

