/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTypeContribution;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class LaunchHistory
implements ILaunchListener,
ILaunchConfigurationListener {
    private ILaunchGroup fGroup;
    private List fHistory = new ArrayList();
    private List fFavorites = new ArrayList();
    private boolean fDirty = false;
    private ILaunchConfiguration fRecentLaunch;
    private static List launchHistoryInstances = new ArrayList();

    public LaunchHistory(ILaunchGroup group) {
        this.fGroup = group;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        manager.addLaunchListener((ILaunchListener)this);
        manager.addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        launchHistoryInstances.add(this);
    }

    public void dispose() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        manager.removeLaunchListener((ILaunchListener)this);
        manager.removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        launchHistoryInstances.remove(this);
    }

    public void launchAdded(ILaunch launch) {
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        if (configuration != null && !configuration.isWorkingCopy() && DebugUIPlugin.doLaunchConfigurationFiltering(configuration) && this.accepts(configuration)) {
            this.addHistory(configuration, true);
            this.setRecentLaunch(configuration);
        }
    }

    protected void addHistory(ILaunchConfiguration configuration, boolean prepend) {
        this.clearDirty();
        if (this.fFavorites.contains(configuration)) {
            return;
        }
        if (this.checkIfFavorite(configuration)) {
            return;
        }
        int index = this.fHistory.indexOf(configuration);
        if (index < 0) {
            if (prepend) {
                this.fHistory.add(0, configuration);
            } else {
                this.fHistory.add(configuration);
            }
            this.resizeHistory();
            this.setDirty();
        } else if (index > 0) {
            int i = index;
            while (i > 0) {
                this.fHistory.set(i, this.fHistory.get(i - 1));
                --i;
            }
            this.fHistory.set(0, configuration);
            this.setDirty();
        }
        this.save();
    }

    private void save() {
        if (this.isDirty()) {
            try {
                DebugUIPlugin.getDefault().getLaunchConfigurationManager().persistLaunchHistory();
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            catch (IOException e) {
                DebugUIPlugin.log(e);
            }
            catch (ParserConfigurationException e) {
                DebugUIPlugin.log(e);
            }
            catch (TransformerException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    private void clearDirty() {
        this.fDirty = false;
    }

    private void setDirty() {
        this.fDirty = true;
    }

    private boolean isDirty() {
        return this.fDirty;
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }

    public ILaunchConfiguration getRecentLaunch() {
        try {
            if (this.fRecentLaunch != null && this.fRecentLaunch.exists() && DebugUIPlugin.doLaunchConfigurationFiltering(this.fRecentLaunch) && !WorkbenchActivityHelper.filterItem((Object)new LaunchConfigurationTypeContribution(this.fRecentLaunch.getType()))) {
                return this.fRecentLaunch;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        return null;
    }

    protected void setRecentLaunch(ILaunchConfiguration configuration) {
        if (this.accepts(configuration) && !configuration.equals(this.fRecentLaunch)) {
            this.fRecentLaunch = configuration;
            this.setDirty();
            this.save();
        }
    }

    public ILaunchConfiguration[] getHistory() {
        return this.fHistory.toArray(new ILaunchConfiguration[this.fHistory.size()]);
    }

    public ILaunchConfiguration[] getFavorites() {
        return this.fFavorites.toArray(new ILaunchConfiguration[this.fFavorites.size()]);
    }

    public void setFavorites(ILaunchConfiguration[] favorites) {
        this.fFavorites = new ArrayList(favorites.length);
        int i = 0;
        while (i < favorites.length) {
            this.fFavorites.add(favorites[i]);
            ++i;
        }
        this.setDirty();
        this.save();
    }

    public void addFavorite(ILaunchConfiguration configuration) {
        this.clearDirty();
        if (!this.fFavorites.contains(configuration)) {
            this.fFavorites.add(configuration);
            this.fHistory.remove(configuration);
            this.setDirty();
        }
        this.save();
    }

    public ILaunchGroup getLaunchGroup() {
        return this.fGroup;
    }

    public boolean accepts(ILaunchConfiguration configuration) {
        block5: {
            if (LaunchConfigurationManager.isVisible(configuration)) break block5;
            return false;
        }
        try {
            if (configuration.getType().supportsMode(this.getLaunchGroup().getMode())) {
                String launchCategory = null;
                launchCategory = configuration.getCategory();
                String category = this.getLaunchGroup().getCategory();
                if (launchCategory == null || category == null) {
                    return launchCategory == category;
                }
                return category.equals(launchCategory);
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        return false;
    }

    public static void launchHistoryChanged() {
        Iterator iter = launchHistoryInstances.iterator();
        while (iter.hasNext()) {
            LaunchHistory history = (LaunchHistory)iter.next();
            history.resizeHistory();
            history.save();
        }
    }

    protected void resizeHistory() {
        int max = this.getMaxHistorySize();
        while (this.fHistory.size() > max) {
            this.fHistory.remove(this.fHistory.size() - 1);
            this.setDirty();
        }
    }

    protected int getMaxHistorySize() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getInt(IDebugUIConstants.PREF_MAX_HISTORY_SIZE);
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        ILaunchConfiguration movedFrom = DebugPlugin.getDefault().getLaunchManager().getMovedFrom(configuration);
        if (movedFrom == null) {
            this.checkIfFavorite(configuration);
        } else {
            String movedFromName = movedFrom.getName();
            ILaunchConfiguration[] history = this.getHistory();
            int i = 0;
            while (i < history.length) {
                if (history[i].getName().equals(movedFromName)) {
                    if (i == 0) {
                        this.fRecentLaunch = configuration;
                    }
                    this.setDirty();
                }
                ++i;
            }
        }
    }

    protected boolean checkIfFavorite(ILaunchConfiguration configuration) {
        block11: {
            List favoriteGroups;
            block9: {
                block10: {
                    if (configuration.isWorkingCopy()) {
                        return false;
                    }
                    try {
                        favoriteGroups = configuration.getAttribute(IDebugUIConstants.ATTR_FAVORITE_GROUPS, null);
                        if (favoriteGroups != null) break block9;
                        String groupId = this.getLaunchGroup().getIdentifier();
                        boolean fav = false;
                        if (groupId.equals(IDebugUIConstants.ID_DEBUG_LAUNCH_GROUP)) {
                            fav = configuration.getAttribute(IDebugUIConstants.ATTR_DEBUG_FAVORITE, false);
                        } else if (groupId.equals(IDebugUIConstants.ID_RUN_LAUNCH_GROUP)) {
                            fav = configuration.getAttribute(IDebugUIConstants.ATTR_RUN_FAVORITE, false);
                        }
                        if (!fav) break block10;
                        this.addFavorite(configuration);
                        return true;
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                }
                this.removeFavorite(configuration);
                return false;
            }
            if (!favoriteGroups.contains(this.getLaunchGroup().getIdentifier())) break block11;
            this.addFavorite(configuration);
            return true;
        }
        this.removeFavorite(configuration);
        return false;
    }

    protected void removeFavorite(ILaunchConfiguration configuration) {
        if (this.fFavorites.contains(configuration)) {
            this.fFavorites.remove(configuration);
            this.setDirty();
            this.save();
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        this.checkIfFavorite(configuration);
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        boolean changed = false;
        ILaunchConfiguration newConfig = DebugPlugin.getDefault().getLaunchManager().getMovedTo(configuration);
        if (newConfig == null) {
            changed = this.fHistory.remove(configuration) || this.fFavorites.remove(configuration);
        } else {
            int index = this.fHistory.indexOf(configuration);
            if (index >= 0) {
                this.fHistory.remove(index);
                this.fHistory.add(index, newConfig);
                changed = true;
            } else {
                index = this.fFavorites.indexOf(configuration);
                if (index >= 0) {
                    this.fFavorites.remove(index);
                    this.fFavorites.add(index, newConfig);
                }
            }
            this.checkIfFavorite(newConfig);
        }
        if (changed) {
            this.setDirty();
            if (configuration.equals(this.fRecentLaunch)) {
                this.fRecentLaunch = !this.fHistory.isEmpty() ? (ILaunchConfiguration)this.fHistory.get(0) : (!this.fFavorites.isEmpty() ? (ILaunchConfiguration)this.fFavorites.get(0) : null);
            }
            this.save();
        }
    }
}

