/*******************************************************************************
 * Copyright (c) 2006 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.wizards;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.fe.internal.ui.wizards.FEConfigurationData;
import org.eclipse.datatools.connectivity.sqm.fe.internal.ui.wizards.FESelectOptionsWizardPage;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesFactory;
import org.eclipse.datatools.sqltools.tablewizard.ui.DefaultTableFormModel;
import org.eclipse.datatools.sqltools.tablewizard.ui.TableFormModel;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.ResourceLoader;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.UIUtils;
import org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.columns.GenericColumnsPage;
import org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.pk.GenericPrimaryKeyPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/**
 * XXX consider access rule to
 * "org/eclipse/datatools/connectivity/sqm/fe/internal/ui/wizards/*"
 * 
 * @author yuanying
 * 
 */
public class GenericTableDefinitionWizard extends Wizard {

	private static final String NEW_TABLE_NAME = "new_table.name"; //$NON-NLS-1$

	private final IConnectionProfile connectionProfile;

	private final Schema schema;

	private final PersistentTable table;

	private final PersistentTable oldTable;

	private boolean isNewTable = false;

	private final DatabaseDefinition databaseDefinition;

	private FESelectOptionsWizardPage selectOptionsPage;

	/**
	 * If you want to create 'new' Table. Use this constructor.
	 * 
	 * @param schema
	 */
	public GenericTableDefinitionWizard(IConnectionProfile connectionProfile,
			Schema schema) {
		this(connectionProfile, schema, null);
		this.isNewTable = true;
	}

	/**
	 * If you want to modfy table. Use this constructor.
	 * 
	 * @param schema
	 * @param oldTable
	 */
	public GenericTableDefinitionWizard(IConnectionProfile connectionProfile,
			Schema schema, PersistentTable oldTable) {
		this.connectionProfile = connectionProfile;
		this.schema = schema;
		this.table = SQLTablesFactory.eINSTANCE.createPersistentTable();
		this.table.setSchema(this.schema);
		this.oldTable = oldTable;
		Database db = this.schema.getDatabase() != null?
							this.schema.getDatabase():this.schema.getCatalog().getDatabase();
		this.databaseDefinition = RDBCorePlugin.getDefault()
				.getDatabaseDefinitionRegistry().getDefinition(db);
		this.table.setName(ResourceLoader.queryString(NEW_TABLE_NAME));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	// @Override
	public boolean performFinish() {
		WorkspaceModifyOperation operation = new WorkspaceModifyOperation() {
			protected void execute(IProgressMonitor monitor) {
				try {
					String[] sqls = createSql(monitor);
					Database db = schema.getDatabase() != null?
										schema.getDatabase():schema.getCatalog().getDatabase();
					UIUtils.openSQLEditor(connectionProfile, db, sqls, monitor);
				} catch (Exception e) {
					System.out.println(e.getMessage());
				} finally {
					monitor.done();
				}
			}
		};

		try {
			getContainer().run(false, false, operation);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;
	}

	/**
	 * 
	 * @param monitor
	 * @return
	 */
	protected String[] createSql(IProgressMonitor monitor) {
		String sql[];
		DDLGenerator generator = this.databaseDefinition.getDDLGenerator();

		if (this.isNewTable) {
			sql = this.createTableSql(generator, this.table, monitor);
		} else {
			sql = this.modyfyTableSql(generator, this.table, this.oldTable,
					monitor);
		}
		return sql;
	}

	/**
	 * 
	 * @param generator
	 * @param table
	 * @param oldTable
	 * @param monitor
	 * @return
	 */
	protected String[] modyfyTableSql(DDLGenerator generator,
			PersistentTable table, PersistentTable oldTable,
			IProgressMonitor monitor) {
		// TODO Auto-generated method stub
		return new String[] { "not yet implemented." }; //$NON-NLS-1$
	}

	/**
	 * 
	 * @param generator
	 * @param table
	 * @param monitor
	 */
	protected String[] createTableSql(DDLGenerator generator,
			PersistentTable table, IProgressMonitor monitor) {
		// TODO Consider PK and other consttains.
		SQLObject[] objs = new SQLObject[] { table };
		// String[] sqls = generator.createSQLObjects(objs, false, false,
		// monitor);
		String[] sqls = generator.generateDDL(objs, monitor);
		return sqls;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.wizard.Wizard#addPages()
	 */
	// @Override
	public void addPages() {
		super.addPages();
		TableFormModel model = new DefaultTableFormModel(this.table);

		this.addPages(model);

	}

	/**
	 * 
	 * @param model
	 */
	protected void addPages(TableFormModel model) {
		FEConfigurationData configurationData = new FEConfigurationData(
				this.databaseDefinition.getDDLGenerator().getOptions(
						new SQLObject[] { model.getPersistentTable() }));
		selectOptionsPage = new FESelectOptionsWizardPage(
				"org.eclipse.datatools.sqltools.tablewizard.ui.SelectOptionPage", //$NON-NLS-1$
				configurationData);
		addPage(selectOptionsPage);

		GenericColumnsPage page1 = new GenericColumnsPage(
				"org.eclipse.datatools.sqltools.tablewizard.ui.GenericColumnPage", model //$NON-NLS-1$
						.getPersistentTable());
		this.addPage(page1);

		GenericPrimaryKeyPage page2 = new GenericPrimaryKeyPage(
				"org.eclipse.datatools.sqltools.tablewizard.ui.GenericPrimaryKeyPage", model //$NON-NLS-1$
						.getPersistentTable());
		this.addPage(page2);
	}
}
