/*******************************************************************************
 * Copyright (c) 2006 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.pk;

import java.util.List;

import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsFactory;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.EObjectListPropertyContentProvider;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.ResourceLoader;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.TableColumnsPropertyLabelProvider;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

/**
 * 
 * @author yuanying
 * 
 */
public class GenericPrimaryKeyPage extends WizardPage {

	private static final String PRIMARY_KEY_DEFAULT_NAME = "primary_key.default.name"; //$NON-NLS-1$

	private static final String PRIMARY_KEY_PAGE_TITLE_LABEL = "primary_key.page.title.label"; //$NON-NLS-1$

	private static final String PRIMARY_KEY_PAGE_DESCRIPTION_LABEL = "primary_key.page.description.label"; //$NON-NLS-1$

	private final PersistentTable table;

	private PrimaryKey primaryKey;

	public GenericPrimaryKeyPage(String pageName, PersistentTable table) {
		super(pageName);
		this.table = table;
		this.primaryKey = table.getPrimaryKey();
		if (this.primaryKey == null) {
			this.primaryKey = SQLConstraintsFactory.eINSTANCE
					.createPrimaryKey();
			this.primaryKey.setName(ResourceLoader
					.queryString(PRIMARY_KEY_DEFAULT_NAME));
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		this.setTitle(ResourceLoader.queryString(PRIMARY_KEY_PAGE_TITLE_LABEL));
		this.setDescription(ResourceLoader
				.queryString(PRIMARY_KEY_PAGE_DESCRIPTION_LABEL));

		GenericPrimaryKeyComposite composite = new GenericPrimaryKeyComposite(
				parent, SWT.NONE);
		this.setControl(composite);

		this.bindPrimaryKeyName(composite);

		this.bindMemberList(composite);
	}

	private void bindPrimaryKeyName(final GenericPrimaryKeyComposite composite) {
		// TODO change to binding style.
		composite.getPrimaryKeynNameText().setText(this.primaryKey.getName());
		composite.getPrimaryKeynNameText().addModifyListener(
				new ModifyListener() {
					public void modifyText(ModifyEvent e) {
						primaryKey.setName((String) e.data);
					}
				});
	}

	private void bindMemberList(GenericPrimaryKeyComposite composite) {
		composite.getPrimaryKeyMemberListViewer().setContentProvider(
				new EObjectListPropertyContentProvider(
						SQLTablesPackage.TABLE__COLUMNS));
		int[] observeChildrenIDs = new int[] { EcorePackage.ENAMED_ELEMENT__NAME,
				// FIXME if we support user defined
				// type(referenced type), fix this code.
				SQLSchemaPackage.TYPED_ELEMENT__CONTAINED_TYPE };
		composite
				.getPrimaryKeyMemberListViewer()
				.setLabelProvider(
						new TableColumnsPropertyLabelProvider(
								this.table,
								SQLTablesPackage.TABLE__COLUMNS,
								observeChildrenIDs));
		composite.getPrimaryKeyMemberListViewer().setInput(this.table);

		// TODO change to binding style.
		composite.getPrimaryKeyMemberListViewer().addSelectionChangedListener(
				new PrimaryKeyListViewerChangeLitener());
	}

	private class PrimaryKeyListViewerChangeLitener implements
			ISelectionChangedListener {
		public void selectionChanged(SelectionChangedEvent event) {
			ISelection selection = event.getSelection();
			if (selection instanceof IStructuredSelection) {
				IStructuredSelection ss = (IStructuredSelection) selection;
				List columns = ss.toList();
				GenericPrimaryKeyPage.this.primaryKey.getMembers().clear();
				if (columns.size() > 0) {
					table.getConstraints().add(primaryKey);
					GenericPrimaryKeyPage.this.primaryKey.getMembers().addAll(
							columns);
				} else {
					table.getConstraints().remove(primaryKey);
				}
			}
		}
	}
}
