/*******************************************************************************
 * Copyright (c) 2006 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.columns;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.ResourceLoader;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.TableViewer;

public class GenericColumnsComposite extends Composite {
	
	private final static String COLUMN_NAME_LABEL = "column.name.label"; //$NON-NLS-1$
	private final static String COLUMN_DATATYPE_LABEL = "column.datatype.label"; //$NON-NLS-1$
	private final static String COLUMN_NULLABLE_LABEL = "column.nullable.label"; //$NON-NLS-1$
	private final static String COLUMN_DEFAULT_VALUE_LABEL = "column.default_value.label"; //$NON-NLS-1$
	
	private final static String TABLE_NAME_LABEL = "table.name.label"; //$NON-NLS-1$
	
	private final static String COLUMN_ADD_BUTTON_LABEL = "column.add_button.label"; //$NON-NLS-1$
	private final static String COLUMN_DELETE_BUTTON_LABEL = "column.delete_button.label"; //$NON-NLS-1$
	
	private final static String COLUMNS_DETAIL_GROUP_LABEL = "columns.detail_group.label"; //$NON-NLS-1$
	
	private final static String COLUMNS_NAME_LABEL = "columns.name.label"; //$NON-NLS-1$
	private final static String COLUMNS_DATATYPE_LABEL = "columns.datatype.label"; //$NON-NLS-1$
	private final static String COLUMNS_LENGTH_LABEL = "columns.length.label"; //$NON-NLS-1$
	private final static String COLUMNS_NULLABLE_LABEL = "columns.nullable.label"; //$NON-NLS-1$
	private final static String COLUMNS_DEFAULT_VALUE_LABEL = "columns.default_value.label"; //$NON-NLS-1$

	private Composite header = null;
	private Label tableNameLabel = null;
	private Text tableNameText = null;
	//private Table columnsTable = null;
	private Composite buttonComposite = null;
	private Button addButton = null;
	private Button deleteButton = null;
	private Group detailGroup = null;
	private Label columnNameLabel = null;
	private Text columnNameText = null;
	private Label dataTypeLabel = null;
	//private Combo dataTypeCombo = null;
	private Button notNullCheck = null;
	private Label defaultValueLabel = null;
	private Text defaultValueText = null;
	private TableViewer columnsTableViewer = null;
	private ComboViewer dataTypeComboViewer = null;
	private Label dataTypeLengthLabel = null;
	private Text dataTypeLengthText = null;
	
	public GenericColumnsComposite(Composite parent, int style) {
		super(parent, style);
		initialize();
	}

	public TableViewer getColumnsTableViewer() {
		return columnsTableViewer;
	}

	public ComboViewer getDataTypeComboViewer() {
		return dataTypeComboViewer;
	}

	public Button getAddButton() {
		return addButton;
	}

	public Composite getButtonComposite() {
		return buttonComposite;
	}

	public Text getColumnNameText() {
		return columnNameText;
	}

	public Text getDefaultValueText() {
		return defaultValueText;
	}

	public Button getDeleteButton() {
		return deleteButton;
	}

	public Group getDetailGroup() {
		return detailGroup;
	}

	public Composite getHeader() {
		return header;
	}

	public Button getNotNullCheck() {
		return notNullCheck;
	}

	public Text getTableNameText() {
		return tableNameText;
	}

	public Text getDataTypeLengthText() {
		return dataTypeLengthText;
	}

	public Label getDataTypeLengthLabel() {
		return dataTypeLengthLabel;
	}

	private void initialize() {
		GridData gridData1 = new GridData();
		gridData1.horizontalAlignment = GridData.FILL;
		gridData1.verticalAlignment = GridData.FILL;
		gridData1.heightHint = 160;
		gridData1.grabExcessHorizontalSpace = true;
		gridData1.grabExcessVerticalSpace = true;
		GridLayout gridLayout1 = new GridLayout();
		gridLayout1.numColumns = 1;
		createHeader();
		this.setLayout(gridLayout1);
		this.setSize(new Point(596, 300));
		Table columnsTable = new Table(this, SWT.FULL_SELECTION);
		columnsTable.setHeaderVisible(true);
		columnsTable.setLayoutData(gridData1);
		columnsTable.setLinesVisible(true);
		columnsTableViewer = new TableViewer(columnsTable);
		TableColumn nameColumn = new TableColumn(columnsTable, SWT.NONE);
		nameColumn.setWidth(100);
		nameColumn.setText(ResourceLoader.queryString(COLUMN_NAME_LABEL));
		TableColumn dataTypeColumn = new TableColumn(columnsTable, SWT.NONE);
		dataTypeColumn.setWidth(60);
		dataTypeColumn.setText(ResourceLoader.queryString(COLUMN_DATATYPE_LABEL));
		TableColumn notNullColumn = new TableColumn(columnsTable, SWT.NONE);
		notNullColumn.setWidth(60);
		notNullColumn.setText(ResourceLoader.queryString(COLUMN_NULLABLE_LABEL));
		TableColumn defaultValueColumn = new TableColumn(columnsTable, SWT.NONE);
		defaultValueColumn.setWidth(160);
		defaultValueColumn.setText(ResourceLoader.queryString(COLUMN_DEFAULT_VALUE_LABEL));
		createButtonComposite();
		createDetailGroup();
	}

	/**
	 * This method initializes header	
	 *
	 */
	private void createHeader() {
		GridData gridData21 = new GridData();
		gridData21.widthHint = 120;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.BEGINNING;
		gridData.grabExcessHorizontalSpace = true;
		gridData.verticalAlignment = GridData.CENTER;
		header = new Composite(this, SWT.NONE);
		header.setLayoutData(gridData);
		header.setLayout(gridLayout);
		tableNameLabel = new Label(header, SWT.NONE);
		tableNameLabel.setText(ResourceLoader.queryString(TABLE_NAME_LABEL));
		tableNameText = new Text(header, SWT.BORDER);
		tableNameText.setLayoutData(gridData21);
	}

	/**
	 * This method initializes buttonComposite	
	 *
	 */
	private void createButtonComposite() {
		GridLayout gridLayout2 = new GridLayout();
		gridLayout2.numColumns = 2;
		buttonComposite = new Composite(this, SWT.NONE);
		buttonComposite.setLayout(gridLayout2);
		addButton = new Button(buttonComposite, SWT.NONE);
		addButton.setText(ResourceLoader.queryString(COLUMN_ADD_BUTTON_LABEL));
		deleteButton = new Button(buttonComposite, SWT.NONE);
		deleteButton.setText(ResourceLoader.queryString(COLUMN_DELETE_BUTTON_LABEL));
	}

	/**
	 * This method initializes detailGroup	
	 *
	 */
	private void createDetailGroup() {
		GridData gridData4 = new GridData();
		gridData4.widthHint = 40;
		GridData gridData7 = new GridData();
		gridData7.widthHint = 120;
		GridData gridData5 = new GridData();
		gridData5.widthHint = 120;
		GridData gridData3 = new GridData();
		gridData3.horizontalSpan = 2;
		GridData gridData2 = new GridData();
		gridData2.grabExcessHorizontalSpace = true;
		gridData2.verticalAlignment = GridData.CENTER;
		gridData2.horizontalAlignment = GridData.FILL;
		GridLayout gridLayout3 = new GridLayout();
		gridLayout3.numColumns = 6;
		detailGroup = new Group(this, SWT.NONE);
		detailGroup.setText(ResourceLoader.queryString(COLUMNS_DETAIL_GROUP_LABEL));
		detailGroup.setLayoutData(gridData2);
		detailGroup.setLayout(gridLayout3);
		columnNameLabel = new Label(detailGroup, SWT.NONE);
		columnNameLabel.setText(ResourceLoader.queryString(COLUMNS_NAME_LABEL));
		columnNameText = new Text(detailGroup, SWT.BORDER);
		columnNameText.setLayoutData(gridData5);
		dataTypeLabel = new Label(detailGroup, SWT.NONE);
		dataTypeLabel.setText(ResourceLoader.queryString(COLUMNS_DATATYPE_LABEL));
		createDataTypeCombo();
		dataTypeLengthLabel = new Label(getDetailGroup(), SWT.NONE);
		dataTypeLengthLabel.setText(ResourceLoader.queryString(COLUMNS_LENGTH_LABEL));
		dataTypeLengthText = new Text(getDetailGroup(), SWT.BORDER);
		dataTypeLengthText.setLayoutData(gridData4);
		notNullCheck = new Button(detailGroup, SWT.CHECK);
		notNullCheck.setText(ResourceLoader.queryString(COLUMNS_NULLABLE_LABEL));
		notNullCheck.setLayoutData(gridData3);
		defaultValueLabel = new Label(detailGroup, SWT.NONE);
		defaultValueLabel.setText(ResourceLoader.queryString(COLUMNS_DEFAULT_VALUE_LABEL));
		defaultValueText = new Text(detailGroup, SWT.BORDER);
		defaultValueText.setLayoutData(gridData7);
	}

	/**
	 * This method initializes dataTypeCombo	
	 *
	 */
	private void createDataTypeCombo() {
		GridData gridData6 = new GridData();
		gridData6.widthHint = 120;
		Combo dataTypeCombo = new Combo(getDetailGroup(), SWT.READ_ONLY);
		dataTypeCombo.setLayoutData(gridData6);
		dataTypeComboViewer = new ComboViewer(dataTypeCombo);
	}

}  //  @jve:decl-index=0:visual-constraint="0,0"
