/*******************************************************************************
 * Copyright (c) 2006 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.sqleditor.EditorConstants;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorage;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorageEditorInput;
import org.eclipse.datatools.sqltools.tablewizard.ui.Messages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/**
 * 
 * @author yuanying
 * 
 */
public class UIUtils {
	/**
	 * 
	 * @param connectionProfile
	 * @param database
	 * @param sqls
	 * @param monitor
	 * @throws PartInitException
	 */
	public static void openSQLEditor(IConnectionProfile connectionProfile,
			Database database, String[] sqls, IProgressMonitor monitor)
			throws PartInitException {
		DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault()
		.getDatabaseDefinitionRegistry().getDefinition(
				database);
		StringBuffer sql = new StringBuffer();
		for (int i = 0; i < sqls.length; i++) {
			sql.append(sqls[i]);
			sql.append(databaseDefinition.getSQLTerminationCharacter());
			sql.append("\n"); //$NON-NLS-1$
		}
		SQLEditorStorage storage = 
			new SQLEditorStorage(Messages.getString("UIUtils.UIUtils.SQLStatement"), //$NON-NLS-1$ 
			                                       sql.toString()); 
		SQLEditorStorageEditorInput editorInput = new SQLEditorStorageEditorInput(
				storage);

		String profileName = connectionProfile.getName();
		DatabaseVendorDefinitionId dbVendorId = ProfileUtil
				.getDatabaseVendorDefinitionId(profileName);
		editorInput.setConnectionInfo(new SQLEditorConnectionInfo(dbVendorId,
				profileName, database.getName()));

		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()
				.openEditor(editorInput, EditorConstants.EDITOR_ID);
	}
}
