/*******************************************************************************
 * Copyright (c) 2006 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.popup.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.UIUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/**
 * @author yuanying
 * 
 */
public class DeleteTableWizardAction implements IObjectActionDelegate {

	private ISelection selection = null;

	private IWorkbenchPart workbenchPart = null;

	/**
	 * 
	 */
	public DeleteTableWizardAction() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction,
	 *      org.eclipse.ui.IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.workbenchPart = targetPart;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		if (!(this.selection instanceof ITreeSelection)) {
			return;
		}
		try {
			ITreeSelection ss = (ITreeSelection) this.selection;
			PersistentTable table = (PersistentTable) ss.getFirstElement();
			IConnectionProfile profile = (IConnectionProfile) ss.getPaths()[0]
					.getSegment(1);

			this.deleteTable(profile, table);

		} catch (Exception e) {
			// TODO open error dialog.
			throw new RuntimeException(e);
		}
	}

	/**
	 * @param profile
	 * @param table
	 */
	private void deleteTable(final IConnectionProfile profile,
			final PersistentTable table) throws Exception {
		Database db = table.getSchema().getDatabase() != null?
						table.getSchema().getDatabase():table.getSchema().getCatalog().getDatabase();
		final DatabaseDefinition databaseDefinition = RDBCorePlugin
				.getDefault().getDatabaseDefinitionRegistry().getDefinition(db);

		WorkspaceModifyOperation operation = new WorkspaceModifyOperation() {
			protected void execute(IProgressMonitor monitor) {
				try {
					String[] sqls = createDeleteSql(table, databaseDefinition,
							monitor);
					UIUtils.openSQLEditor(profile, table.getSchema()
							.getDatabase(), sqls, monitor);
				} catch (Exception e) {
					System.out.println(e.getMessage());
				} finally {
					monitor.done();
				}
			}
		};

		this.workbenchPart.getSite().getWorkbenchWindow().run(false, false,
				operation);
	}

	/**
	 * 
	 * @param table
	 * @param databaseDefinition
	 * @param monitor
	 * @return
	 */
	protected String[] createDeleteSql(PersistentTable table,
			DatabaseDefinition databaseDefinition, IProgressMonitor monitor) {
		DDLGenerator generator = databaseDefinition.getDDLGenerator();
		// TODO consider option.
		return generator.dropSQLObjects(new SQLObject[] { table }, false,
				false, monitor);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}

}
