/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.tabledataeditor.actions;

import java.sql.Connection;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.popup.AbstractAction;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.icons.ImageDescription;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.internal.tabledataeditor.query.execute.QueryOutputHelper;
import org.eclipse.datatools.sqltools.internal.tabledataeditor.util.ResourceLoader;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SampleContentAction
extends AbstractAction {
    private static final String TEXT = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.DATA.SAMPCONTENTS");
    private final String SQ = "'";
    private final String SQ2 = "`";
    private final String DQ = "\"";
    private final String SPACE = " ";
    private String quote = "";

    private String wrapName(String name) {
        if (this.quote.equals("'") || this.quote.equals("`")) {
            return this.quote + SampleContentAction.doubleStringDelim(name, this.quote) + this.quote;
        }
        if (" ".equals(this.quote)) {
            return SampleContentAction.doubleStringDelim(name, " ");
        }
        return "\"" + SampleContentAction.doubleStringDelim(name, "\"") + "\"";
    }

    private String getFullyQualifiedName(Table table) {
        Database db = table.getSchema().getCatalog() != null ? table.getSchema().getCatalog().getDatabase() : table.getSchema().getDatabase();
        RDBCorePlugin plugin = RDBCorePlugin.getDefault();
        DatabaseDefinition dbDefinition = plugin.getDatabaseDefinitionRegistry().getDefinition(db);
        if (dbDefinition.supportsSchema()) {
            return this.wrapName(table.getSchema().getName()) + "." + this.wrapName(table.getName());
        }
        return this.wrapName(table.getName());
    }

    private Database getDatabase(Schema schema) {
        return schema.getCatalog() == null ? schema.getDatabase() : schema.getCatalog().getDatabase();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        if (event.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)event.getSelection()).getFirstElement() instanceof EObject) {
            EObject o = (EObject)((IStructuredSelection)event.getSelection()).getFirstElement();
            ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
            String groupID = containmentService.getGroupId(o);
            this.setEnabled(groupID != null && groupID.startsWith("core."));
        }
    }

    public void initialize() {
        ImageDescriptor descriptor = ImageDescription.getSampleContent();
        this.initializeAction(descriptor, descriptor, TEXT, TEXT);
    }

    public void run() {
        this.quote = "\"";
        Connection connection = null;
        if (!this.event.getSelection().isEmpty()) {
            Iterator iter = ((IStructuredSelection)this.event.getSelection()).iterator();
            String selectString = "";
            Object selectedObj = iter.next();
            Database database = null;
            if (selectedObj instanceof Table) {
                database = this.getDatabase(((Table)selectedObj).getSchema());
                if (connection == null) {
                    connection = ((ICatalogObject)selectedObj).getConnection();
                }
                try {
                    this.quote = connection.getMetaData().getIdentifierQuoteString();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                selectString = selectString + "SELECT * FROM " + this.getFullyQualifiedName((Table)selectedObj);
            } else if (selectedObj instanceof Column) {
                PredefinedDataTypeDefinition datatypeDefinition;
                if (connection == null) {
                    connection = ((ICatalogObject)selectedObj).getConnection();
                }
                Column column = (Column)selectedObj;
                String columnName = column.getName();
                database = this.getDatabase(column.getTable().getSchema());
                DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
                DataType datatype = column.getDataType();
                if (datatype instanceof DistinctUserDefinedType) {
                    datatype = ((DistinctUserDefinedType)datatype).getPredefinedRepresentation();
                }
                if ((datatypeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(datatype.getName())).isOrderingSupported() && datatypeDefinition.isGroupingSupported()) {
                    selectString = selectString + "SELECT DISTINCT " + this.wrapName(columnName) + " , COUNT(*) AS OCCURRENCE";
                    selectString = selectString + " FROM " + this.getFullyQualifiedName(column.getTable());
                    selectString = selectString + " GROUP BY " + this.wrapName(columnName);
                    selectString = selectString + " ORDER BY " + this.wrapName(columnName);
                } else {
                    selectString = selectString + "SELECT " + this.wrapName(columnName);
                    selectString = selectString + " FROM " + this.getFullyQualifiedName(column.getTable());
                }
            }
            String profileName = DatabaseConnectionRegistry.getConnectionForDatabase(database).getName();
            QueryOutputHelper queryHelper = new QueryOutputHelper(selectString, connection, profileName, database.getName());
            queryHelper.setObjectName(ResourceLoader.INSTANCE.queryString("_UI_SAMPLE_CONTENTS_OUTPUTVIEW_TITLE"));
            queryHelper.runQuery();
        }
    }

    public static String doubleStringDelim(String s, String delim) {
        if (delim == null || delim.length() == 0) {
            return s;
        }
        int i = s.indexOf(delim);
        if (i != -1) {
            StringBuffer sb = new StringBuffer(s);
            while (i != -1) {
                sb = sb.insert(i, delim);
                int j = i + 2 * delim.length();
                i = sb.toString().indexOf(delim, j);
            }
            return sb.toString();
        }
        return s;
    }
}

