/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.sqltools.result.Parameter;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultSection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultsView;
import org.eclipse.datatools.sqltools.result.internal.utils.Images;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.internal.utils.UIUtil;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class SingleWindowModeSection
extends ResultSection {
    protected Composite _composite;
    protected boolean _isResultHid;
    protected boolean _isLabelCreated = false;

    public SingleWindowModeSection(Composite composite, IResultInstance instance, ResultsView view) {
        super(instance, view);
        this._parent = composite;
        this.createInitialControl(composite);
    }

    public SingleWindowModeSection(Composite composite, ResultsView view) {
        super(null, view);
        this._parent = composite;
        this.createInitialControl(composite);
    }

    protected void createInitialControl(Composite composite) {
        this._composite = new Composite(composite, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        this._composite.setLayout((Layout)layout);
        this._composite.setLayoutData((Object)new GridData(1808));
    }

    public void showDetail(IResultInstance instance) {
        super.showDetail(instance);
        if (instance == this._resultInstance) {
            return;
        }
        this._view.clearStatusLine();
        this._view.refreshResults();
        this._resultInstance = instance;
        this.createViewerForResultInstance(instance);
    }

    public Composite getControl() {
        return this._composite;
    }

    protected abstract void createViewerForResultInstance(IResultInstance var1);

    public void onInstanceFinished() {
        if (this._isResultHid && !this._isLabelCreated) {
            this._isLabelCreated = true;
            Composite warnComp = new Composite(this._composite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            warnComp.setLayout((Layout)layout);
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = false;
            gd.heightHint = UIUtil.convertHeightInCharsToPixels(1, (Control)this._parent);
            warnComp.setLayoutData((Object)gd);
            Label warnIcon = new Label(warnComp, 0);
            warnIcon.setImage(Images.get("org.eclipse.datatools.sqltools.resultwarning_st_obj.gif"));
            Label label = new Label(warnComp, 0);
            label.setText(Messages.ResultSection_warnning_rowshidden);
            this._composite.layout(true);
        }
    }

    public void onParametersShown(List params) {
    }

    protected List getValidParamList(List params) {
        if (params == null) {
            return new ArrayList();
        }
        Iterator iter = params.iterator();
        ArrayList newList = new ArrayList();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null || !(obj instanceof Parameter)) continue;
            newList.add(obj);
        }
        return newList;
    }
}

