/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.ui.view.MultipleTabsGridSection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.MultipleTabsTextSection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultSection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultsView;
import org.eclipse.datatools.sqltools.result.internal.ui.view.SingleWindowGridSection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.SingleWindowTextSection;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;

public class ResultSectionFactory {
    private static final int MULTI_GRID = 1;
    private static final int MULTI_TEXT = 2;
    private static final int SINGLE_GRID = 3;
    private static final int SINGLE_TEXT = 4;

    public static ResultSection createResultSection(Composite comp, ResultsView view) {
        int mode = ResultSectionFactory.getDisplayMode();
        ResultSection resultSection = null;
        switch (mode) {
            case 1: {
                resultSection = new MultipleTabsGridSection(comp, view);
                break;
            }
            case 2: {
                resultSection = new MultipleTabsTextSection(comp, view);
                break;
            }
            case 3: {
                resultSection = new SingleWindowGridSection(comp, view);
                break;
            }
            case 4: {
                resultSection = new SingleWindowTextSection(comp, view);
                break;
            }
        }
        return resultSection;
    }

    private static int getDisplayMode() {
        IPreferenceStore store = ResultsViewPlugin.getDefault().getPreferenceStore();
        int windows = store.getInt("org.eclipse.datatools.sqltools.result.preferences.display.displaywindow");
        int mode = store.getInt("org.eclipse.datatools.sqltools.result.preferences.display.displaymode");
        if (windows == 1 && mode == 1) {
            return 4;
        }
        if (windows == 1 && mode == 2) {
            return 3;
        }
        if (windows == 2 && mode == 1) {
            return 2;
        }
        if (windows == 2 && mode == 2) {
            return 1;
        }
        return 1;
    }
}

