/*******************************************************************************
 * Copyright (c) 2005 Sybase, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.result.internal;

import org.eclipse.datatools.sqltools.result.ResultsConstants;

/**
 * Preference page related constants
 * 
 * @author Dafan Yang
 */
public class PreferenceConstants
{
    /* Preference page id */
    public static final String PAGE_RESULT                             = "org.eclipse.datatools.sqltools.result.displayOption";
    public static final String PAGE_EXPORT                             = "org.eclipse.datatools.sqltools.result.exportFormat";
    public static final String PAGE_HISTORY                            = "org.eclipse.datatools.sqltools.result.resultHistory";
    
    /* SQL Results View display options */
    public static final String SQL_RESULTS_VIEW_MAX_ROW_COUNT          = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.display.maxrowcount";
    public static final String SQL_RESULTS_VIEW_MAX_DISPLAY_ROW_COUNT  = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.display.maxdisplayrowcount";
    // 1: single window 2: multi-windows
    public static final String SQL_RESULTS_VIEW_DISPLAY_WINDOW         = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.display.displaywindow";
    // 1: text mode 2: grid mode
    public static final String SQL_RESULTS_VIEW_DISPLAY_MODE           = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.display.displaymode";
    public static final String SQL_RESULTS_VIEW_SHOW_HEADING           = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.display.showheadings";
    public static final String SQL_RESULTS_VIEW_SHOW_ROW_NUMBER        = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.display.showrownumber";
    public static final String SQL_RESULTS_VIEW_SHOW_ROW_COUNT_MSG     = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.display.showrowcountmsg";
    public static final String SQL_RESULTS_VIEW_NULL_STRING            = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.display.nulldisplaystr";
    public static final String SQL_RESULTS_VIEW_SPLIT_MESSAGES         = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.display.splitmessages";
    public static final String SQL_RESULTS_VIEW_TABS_NUMBER            = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.display.tabsnumber";
    public static final String SQL_RESULTS_VIEW_TABLES_LIMITATION      = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.display.tablesnumber.limitation";
    public static final String VERTICAL_LAYOUT_RESULTS_VIEW            = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.results.vertical";
    
    /* Export format options */
    public static final String EXPORT_FORMAT_ADD_XML_HEADER            = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.exportformat.addxmlheader";
    public static final String EXPORT_FORMAT_XML_HEADER                = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.exportformat.xmlheader";
    public static final String EXPORT_FORMAT_ADD_XML_ROOT_TAG          = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.exportformat.addxmlroottag";
    public static final String EXPORT_FORMAT_XML_ROOT_TAG              = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.exportformat.xmlroottag";
    public static final String EXPORT_FORMAT_OUTPUT_FORMAT             = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.exportformat.outputformat";
    public static final String EXPORT_FORMAT_DELIMITER                 = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.exportformat.delimiter";
    public static final String EXPORT_FORMAT_DEFAULT_ENCODEING         = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.exportformat.defalut";
    public static final String EXPORT_FORMAT_OTHER_ENCODEING           = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.exportformat.other";
    public static final String EXPORT_FORMAT_OTHER_ENCODEING_SELECTION = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.exportformat.other.selection";
    public static final String EXPORT_FORMAT_PREF_ENCODING             = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.exportformat.pref_encoding";
    /* Connection profile filters */

    public static final String PROFILE_FILTERS_STATUS_SUCCESS          = ResultsConstants.PLUGIN_ID
                                                                               + ".ResultsFilterDialog.success";
    public static final String PROFILE_FILTERS_STATUS_FAILED           = ResultsConstants.PLUGIN_ID
                                                                               + ".ResultsFilterDialog.failed";
    public static final String PROFILE_FILTERS_STATUS_TERMINATED       = ResultsConstants.PLUGIN_ID
                                                                               + ".ResultsFilterDialog.terminated";
    public static final String PROFILE_FILTERS_STATUS_WARNING          = ResultsConstants.PLUGIN_ID
                                                                               + ".ResultsFilterDialog.warning";
    public static final String PROFILE_FILTERS_STATUS_CRITICAL         = ResultsConstants.PLUGIN_ID
                                                                               + ".ResultsFilterDialog.critical";
    public static final String PROFILE_FILTERS_LIMIT_CHECK             = ResultsConstants.PLUGIN_ID
                                                                               + ".ResultsFilterDialog.limitcheck";
    public static final String PROFILE_FILTERS_LIMIT_NUM               = ResultsConstants.PLUGIN_ID
                                                                               + ".ResultsFilterDialog.limitnum";
    public static final String PROFILE_FILTERS_UNKNOWNPROFILE          = ResultsConstants.PLUGIN_ID
                                                                               + ".ResultsFilterDialog.unknownProfile";
    public static final String PROFILE_FILTERS_PROFILE_MAY_CHANGED     = ResultsConstants.PLUGIN_ID
                                                                               + ".ResultsFilterDialog.profileFilter.change";
    public static final String PROFILE_FILTERS_FILTERED_PROFILES       = ResultsConstants.PLUGIN_ID
                                                                               + ".ResultsFilterDialog.filtered.profiles";
    
    /* Result history display options */ 
    public static final String RESULT_HISTORY_STATUS_COLUMN            = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.resulthistory.status";
    public static final String RESULT_HISTORY_OPER_COLUMN              = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.resulthistory.operation";
    public static final String RESULT_HISTORY_FREQ_COLUMN              = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.resulthistory.frequency";
    public static final String RESULT_HISTORY_DATE_COLUMN              = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.resulthistory.date";
    public static final String RESULT_HISTORY_ACTION_COLUMN            = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.resulthistory.action";
    public static final String RESULT_HISTORY_CONSUMER_COLUMN          = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.resulthistory.consumer";
    public static final String RESULT_HISTORY_PROFILE_COLUMN           = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.resulthistory.profile";
    public static final String RESULT_HISTORY_SAVE_HISTORY             = ResultsConstants.PLUGIN_ID
                                                                               + ".preferences.resulthistory.autosave";

}
