/*******************************************************************************
 * Copyright (c) 2005 Sybase, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.result;

/**
 * 
 * This file contains all the context help ID that are used by following DTP plugins:
 * 
 * TPS_helpKey_constants_for_plug-in: org.eclipse.datatools.sqltools.result
 * 
 * @author bshen
 */
public interface IHelpConstants
{
    public static final String PREFIX = "org.eclipse.datatools.sqltools.result";
    
    /**
     * Used for SQL result view.
     */
    public static final String VIEW_SQL_RESULT                              = PREFIX + "view_sql_result";

    /**
     * Used for SQL result view's SQL Results View preference page.
     */
    public static final String PREFERENCE_PAGE_SQL_RESULTS_VIEW              = PREFIX + "preference_page_sql_result_view";
    
    /**
     * Used for SQL result view's Export Format preference page.
     */
    public static final String PREFERENCE_PAGE_EXPORT_FORMAT                = PREFIX + "preference_page_export_format";
    
    /**
     * Used for SQL result view's History preference page.
     */
    public static final String PREFERENCE_PAGE_RESULT_HISTORY               = PREFIX + "preference_page_result_history";
    
    /**
     * Used for SQL result view's Re-execute action.
     */
    public static final String ACTION_REEXECUTE                             = PREFIX + "action_reexecute";
    
    /**
     * Used for SQL result view's Remove All action.
     */
    public static final String ACTION_REMOVE_ALL_VISIBLE_FINISHED_RESULT    = PREFIX + "action_remove_all_visible_finished_result";
    
    /**
     * Used for SQL result view's Remove action.
     */
    public static final String ACTION_REMOVE_RESULT                         = PREFIX + "action_remove_result";
    
    /**
     * Used for SQL result view's Save History action.
     */
    public static final String ACTION_SAVE_RESULT_INSTANCE                  = PREFIX + "action_save_result_instance";
    
    /**
     * Used for SQL result view's Terminate action.
     */
    public static final String ACTION_TERMINATE_INSTANCE                    = PREFIX + "action_terminate_instance";
    
    /**
     * Used for SQL result view's All Results action.
     */
    public static final String ACTION_EXPORT_ALL_RESULTSETS                 = PREFIX + "action_export_all_resultsets";
    
    /**
     * Used for SQL result view's Export Current Result action.
     */
    public static final String ACTION_EXPORT_RESULTSET                      = PREFIX + "action_export_resultset";
    
    /**
     * Used for SQL result view's Save All Results action.
     */
    public static final String ACTION_SAVE_ALL_RESULTSETS                   = PREFIX + "action_save_all_resultsets";
    
    /**
     * Used for SQL result view's Save Current Result action.
     */
    public static final String ACTION_SAVE_RESULTSET                        = PREFIX + "action_save_resultset";
    
    /**
     * Used for SQL result view's Print Current Result action.
     */
    public static final String ACTION_PRINT_RESULTSET                       = PREFIX + "action_print_resultset";
    
    /**
     * Used for SQL result view's Open Filters action.
     */
    public static final String ACTION_OPEN_FILTER_DIALOG                    = PREFIX + "action_open_filter_dialog";
    
    /**
     * Used for SQL result view's Display result in single tab action.
     */
    public static final String ACTION_SINGLE_TAB_DISPLAY                    = PREFIX + "action_single_tab_display";
    
    /**
     * Used for SQL result view's Display result in text mode action.
     */
    public static final String ACTION_TEXT_MODE_DISPLAY                     = PREFIX + "action_text_mode_display";
    
    /**
     * Used for SQL result view's Long data dialog.
     */
    public static final String DIALOG_LONG_DATA                             = PREFIX + "dialog_long_data";
    
    /**
     * Used for SQL result view's Save All Results/ Save Result dialog.
     */
    public static final String DIALOG_SAVE_RESULTSET                        = PREFIX + "dialog_save_resultset";
    
    /**
     * Used for SQL result view's SQL Results Filters dialog.
     */
    public static final String DIALOG_RESULTS_FILTER                        = PREFIX + "dialog_results_filter";
    
    /**
     * Used for SQL result view's Export Result wizard.
     */
    public static final String WIZARD_RESULT_EXPORT                         = PREFIX + "wizard_result_export";
}