/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.sqltools.plan.IPlanService;
import org.eclipse.datatools.sqltools.plan.PlanService;
import org.eclipse.datatools.sqltools.plan.internal.PlanViewPlugin;
import org.eclipse.datatools.sqltools.plan.internal.util.ILogger;

public class PlanServiceRegistry {
    private static ILogger _log = PlanViewPlugin.getLogger(null);
    private static PlanServiceRegistry _instance;
    private static Map _extensions;
    private static PlanService _defaultService;

    private PlanServiceRegistry() {
        _extensions = new HashMap();
        this.readRegistries();
    }

    public static synchronized PlanServiceRegistry getInstance() {
        if (_instance == null) {
            _instance = new PlanServiceRegistry();
        }
        return _instance;
    }

    public IPlanService getPlanService(String databaseDefinitionId) {
        IPlanService service = (IPlanService)_extensions.get(databaseDefinitionId);
        if (service == null) {
            return _defaultService;
        }
        return service;
    }

    private void readRegistries() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.datatools.sqltools.plan", "planService");
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            for (int j = 0; j < elements.length; ++j) {
                String databaseDefinitionId = elements[j].getAttribute("databaseVendorDefinitionId");
                try {
                    IPlanService planService = (IPlanService)elements[j].createExecutableExtension("serviceClass");
                    if (_extensions.containsKey(databaseDefinitionId)) continue;
                    _extensions.put(databaseDefinitionId, planService);
                    continue;
                }
                catch (CoreException ce) {
                    _log.error("PlanServiceRegistry.create.runnable.error", (Throwable)ce);
                }
            }
        }
    }

    static {
        _defaultService = new PlanService();
    }
}

