/*
 * This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */

package org.eclipse.datatools.sqltools.parsers.sql.lexer;

public interface SQLParsersym {
    public final static int
      TK_ACCESS = 1,
      TK_ACCTNG = 2,
      TK_ACTION = 3,
      TK_ACTIVATE = 4,
      TK_ADD = 5,
      TK_ADMIN = 6,
      TK_ADMINISTRATION = 7,
      TK_AFTER = 8,
      TK_AGE = 9,
      TK_ALIAS = 10,
      TK_ALL = 11,
      TK_ALLOCATE = 12,
      TK_ALLOW = 13,
      TK_ALTER = 14,
      TK_ALTERIN = 15,
      TK_ALWAYS = 16,
      TK_AND = 17,
      TK_ANY = 18,
      TK_APPEND = 19,
      TK_APPL_ID = 20,
      TK_APPL_NAME = 21,
      TK_APPLNAME = 22,
      TK_ARRAY = 23,
      TK_AS = 24,
      TK_ASC = 25,
      TK_ASCII = 26,
      TK_ASENSITIVE = 27,
      TK_ASSIGNMENT = 28,
      TK_ASSOCIATE = 29,
      TK_AST = 30,
      TK_ASUTIME = 31,
      TK_AT = 32,
      TK_ATOMIC = 33,
      TK_ATTRIBUTE = 34,
      TK_ATTRIBUTES = 35,
      TK_AUTHORIZATION = 36,
      TK_AUTH_ID = 37,
      TK_AUTHID = 38,
      TK_AUTOMATIC = 39,
      TK_AUTOSTART = 40,
      TK_AVAILABLE = 41,
      TK_B = 42,
      TK_BEFORE = 43,
      TK_BEGIN = 44,
      TK_BERNOULLI = 45,
      TK_BETWEEN = 46,
      TK_BIGINT = 47,
      TK_BINARY = 48,
      TK_BIND = 49,
      TK_BINDADD = 50,
      TK_BIT = 51,
      TK_BLOB = 52,
      TK_BLOCKED = 53,
      TK_BLOCKSIZE = 54,
      TK_BOTH = 55,
      TK_BUFFER = 56,
      TK_BUFFERPOOL = 57,
      TK_BUFFERPOOLS = 58,
      TK_BUFFERSIZE = 59,
      TK_BUILD = 60,
      TK_BY = 61,
      TK_BYPASS = 62,
      TK_C = 63,
      TK_CACHE = 64,
      TK_CACHING = 65,
      TK_CALL = 66,
      TK_CALLED = 67,
      TK_CALLER = 68,
      TK_CAPTURE = 69,
      TK_CARDINALITIES = 70,
      TK_CARDINALITY = 71,
      TK_CASCADE = 72,
      TK_CASCADED = 73,
      TK_CASE = 74,
      TK_CAST = 75,
      TK_CCSID = 76,
      TK_CHANGE = 77,
      TK_CHANGED = 78,
      TK_CHANGES = 79,
      TK_CHAR = 80,
      TK_CHARACTER = 81,
      TK_CHECK = 82,
      TK_CHECKED = 83,
      TK_CLIENT = 84,
      TK_CLIENT_ACCTNG = 85,
      TK_CLIENT_APPLNAME = 86,
      TK_CLIENT_USERID = 87,
      TK_CLIENT_WRKSTNNAME = 88,
      TK_CLOB = 89,
      TK_CLOSE = 90,
      TK_CLR = 91,
      TK_CLUSTER = 92,
      TK_COBOL = 93,
      TK_COLLECT = 94,
      TK_COLLID = 95,
      TK_COLUMN = 96,
      TK_COLUMNS = 97,
      TK_COMM = 98,
      TK_COMMENT = 99,
      TK_COMMIT = 100,
      TK_COMMITTED = 101,
      TK_COMPACT = 102,
      TK_COMPARE = 103,
      TK_COMPARISONS = 104,
      TK_COMPRESS = 105,
      TK_COMPRESSION = 106,
      TK_CONCAT = 107,
      TK_CONDITION = 108,
      TK_CONN = 109,
      TK_CONNECT = 110,
      TK_CONNECTIONS = 111,
      TK_CONNECTOPT = 112,
      TK_CONNHEADER = 113,
      TK_CONNMEMUSE = 114,
      TK_CONSERVATIVE = 115,
      TK_CONSTRAINT = 116,
      TK_CONSTRAINTS = 117,
      TK_CONSTRUCTOR = 118,
      TK_CONTAINERS = 119,
      TK_CONTAINS = 120,
      TK_CONTENT = 121,
      TK_CONTINUE = 122,
      TK_CONTINUOUSLY = 123,
      TK_CONTROL = 124,
      TK_COPY = 125,
      TK_COUNT = 126,
      TK_COUNT_BIG = 127,
      TK_CPU = 128,
      TK_CREATE = 129,
      TK_CREATE_EXTERNAL_ROUTINE = 130,
      TK_CREATEIN = 131,
      TK_CREATE_NOT_FENCED = 132,
      TK_CREATE_NOT_FENCED_ROUTINE = 133,
      TK_CREATETAB = 134,
      TK_CS = 135,
      TK_CUBE = 136,
      TK_CURRENT = 137,
      TK_CURRENT_DATE = 138,
      TK_CURRENT_DEFAULT_TRANSFORM_GROUP = 139,
      TK_CURRENT_PATH = 140,
      TK_CURRENT_ROLE = 141,
      TK_CURRENT_SCHEMA = 142,
      TK_CURRENT_SERVER = 143,
      TK_CURRENT_TIME = 144,
      TK_CURRENT_TIMESTAMP = 145,
      TK_CURRENT_TIMEZONE = 146,
      TK_CURRENT_TRANSFORM_GROUP_FOR_TYPE = 147,
      TK_CURRENT_USER = 148,
      TK_CURRVAL = 149,
      TK_CURSOR = 150,
      TK_CURSORS = 151,
      TK_CYCLE = 152,
      TK_DATA = 153,
      TK_DATABASE = 154,
      TK_DATALINK = 155,
      TK_DATE = 156,
      TK_DAY = 157,
      TK_DAYS = 158,
      TK_DB = 159,
      TK_DBADM = 160,
      TK_DBCLOB = 161,
      TK_DBINFO = 162,
      TK_DBMEMUSE = 163,
      TK_DBPARTITIONNUM = 164,
      TK_DBPARTITIONNUMS = 165,
      TK_DB2DARI = 166,
      TK_DB2GENRL = 167,
      TK_DB2GENERAL = 168,
      TK_DB2OPTIONS = 169,
      TK_DB2SPL = 170,
      TK_DB2SQL = 171,
      TK_DB2_RETURN_STATUS = 172,
      TK_DB2_TOKEN_STRING = 173,
      TK_DEACTIVATE = 174,
      TK_DEADLOCK = 175,
      TK_DEADLOCKS = 176,
      TK_DEC = 177,
      TK_DECIMAL = 178,
      TK_DECLARE = 179,
      TK_DEFAULT = 180,
      TK_DEFAULTS = 181,
      TK_DEFINE = 182,
      TK_DEFINITION = 183,
      TK_DEGREE = 184,
      TK_DEFER = 185,
      TK_DEFERRED = 186,
      TK_DELETE = 187,
      TK_DESC = 188,
      TK_DESCRIPTOR = 189,
      TK_DETAILED = 190,
      TK_DETAILS = 191,
      TK_DETERMINED = 192,
      TK_DETERMINISTIC = 193,
      TK_DEVICE = 194,
      TK_DIAGNOSTICS = 195,
      TK_DIMENSIONS = 196,
      TK_DIRTY = 197,
      TK_DISABLE = 198,
      TK_DISALLOW = 199,
      TK_DISPATCH = 200,
      TK_DISTINCT = 201,
      TK_DISTRIBUTION = 202,
      TK_DLCONN = 203,
      TK_DLLOCK = 204,
      TK_DO = 205,
      TK_DOUBLE = 206,
      TK_DROP = 207,
      TK_DROPIN = 208,
      TK_DROPPED = 209,
      TK_DYNAMIC = 210,
      TK_EACH = 211,
      TK_ELEMENT = 212,
      TK_ELSE = 213,
      TK_ELSEIF = 214,
      TK_EMPTY = 215,
      TK_ENABLE = 216,
      TK_ENCRYPTION = 217,
      TK_END = 218,
      TK_ENDING = 219,
      TK_ENFORCED = 220,
      TK_ERASE = 221,
      TK_ESCAPE = 222,
      TK_ESTIMATE = 223,
      TK_EUR = 224,
      TK_EVALUATE = 225,
      TK_EVENT = 226,
      TK_EXACT = 227,
      TK_EXCEPT = 228,
      TK_EXCEPTION = 229,
      TK_EXCLUDE = 230,
      TK_EXCLUDES = 231,
      TK_EXCLUDING = 232,
      TK_EXCLUSIVE = 233,
      TK_EXECNODE = 234,
      TK_EXECUTE = 235,
      TK_EXISTS = 236,
      TK_EXIT = 237,
      TK_EXPAND = 238,
      TK_EXPLAIN = 239,
      TK_EXPRESSION = 240,
      TK_EXTEND = 241,
      TK_EXTENDED = 242,
      TK_EXTENSION = 243,
      TK_EXTENTSIZE = 244,
      TK_EXTERNAL = 245,
      TK_FALSE = 246,
      TK_FEDERATED = 247,
      TK_FEDERATED_TOOL = 248,
      TK_FENCED = 249,
      TK_FETCH = 250,
      TK_FILE = 251,
      TK_FILTER = 252,
      TK_FINAL = 253,
      TK_FIRST = 254,
      TK_FLOAT = 255,
      TK_FLUSH = 256,
      TK_FOLLOWING = 257,
      TK_FOR = 258,
      TK_FORCE = 259,
      TK_FOREIGN = 260,
      TK__FOREIGNKEY = 261,
      TK_FOUND = 262,
      TK_FREE = 263,
      TK_FREEPAGE = 264,
      TK_FROM = 265,
      TK_FS = 266,
      TK_FULL = 267,
      TK_FUNCTION = 268,
      TK_G = 269,
      TK_GBPCACHE = 270,
      TK_GENERAL = 271,
      TK_GENERATE = 272,
      TK_GENERATED = 273,
      TK_GET = 274,
      TK_GLOBAL = 275,
      TK_GOTO = 276,
      TK_GRANT = 277,
      TK_GRAPHIC = 278,
      TK_GROUP = 279,
      TK_GROUPING = 280,
      TK_HANDLER = 281,
      TK_HASHING = 282,
      TK_HAVING = 283,
      TK_HIDDEN = 284,
      TK_HIERARCHY = 285,
      TK_HIGH = 286,
      TK_HOLD = 287,
      TK_HOUR = 288,
      TK_HOURS = 289,
      TK_HPJ = 290,
      TK_ID = 291,
      TK_IDENTITY = 292,
      TK_IF = 293,
      TK_IGNORE = 294,
      TK_IMMEDIATE = 295,
      TK_IMPLICIT_SCHEMA = 296,
      TK_IN = 297,
      TK_INCLUDE = 298,
      TK_INCLUDES = 299,
      TK_INCLUDING = 300,
      TK_INCREMENT = 301,
      TK_INCREMENTAL = 302,
      TK_INDEX = 303,
      TK_INDEXES = 304,
      TK_INDICATOR = 305,
      TK_INFIX = 306,
      TK_INFO = 307,
      TK_INHERIT = 308,
      TK_INITIALLY = 309,
      TK_INITIAL_INSTS = 310,
      TK_INITIAL_IOS = 311,
      TK_INLINE = 312,
      TK_INNER = 313,
      TK_INOUT = 314,
      TK_INPUT = 315,
      TK_INSENSITIVE = 316,
      TK_INSERT = 317,
      TK_INSTANTIABLE = 318,
      TK_INSTEAD = 319,
      TK_INSTS_PER_ARGBYTE = 320,
      TK_INSTS_PER_INVOC = 321,
      TK_INT = 322,
      TK_INTEGER = 323,
      TK_INTEGRITY = 324,
      TK_INTERSECT = 325,
      TK_INTO = 326,
      TK_IO = 327,
      TK_IOS_PER_ARGBYTE = 328,
      TK_IOS_PER_INVOC = 329,
      TK_IS = 330,
      TK_ISO = 331,
      TK_ITERATE = 332,
      TK_ISOLATION = 333,
      TK_JAVA = 334,
      TK_JIS = 335,
      TK_JOIN = 336,
      TK_K = 337,
      TK_KEEP = 338,
      TK_KEY = 339,
      TK_KEYS = 340,
      TK_L = 341,
      TK_LANGUAGE = 342,
      TK_LARGE = 343,
      TK_LAST = 344,
      TK_LATERAL = 345,
      TK_LC_CTYPE = 346,
      TK_LEADING = 347,
      TK_LEAVE = 348,
      TK_LEFT = 349,
      TK_LENGTH = 350,
      TK_LEVEL = 351,
      TK_LEVEL2 = 352,
      TK_LIBRARY = 353,
      TK_LIBRARYADM = 354,
      TK_LIKE = 355,
      TK_LIMIT = 356,
      TK_LINK = 357,
      TK_LINKTYPE = 358,
      TK_LOAD = 359,
      TK_LOCAL = 360,
      TK_LOCALE = 361,
      TK_LOCALTIME = 362,
      TK_LOCALTIMESTAMP = 363,
      TK_LOCATOR = 364,
      TK_LOCATORS = 365,
      TK_LOCK = 366,
      TK_LOCKS = 367,
      TK_LOCKSIZE = 368,
      TK_LOG = 369,
      TK_LOGGED = 370,
      TK_LONG = 371,
      TK_LONGVAR = 372,
      TK_LOOP = 373,
      TK_LOW = 374,
      TK_M = 375,
      TK_MAINTAINED = 376,
      TK_MAIN_PROG = 377,
      TK_MANAGED = 378,
      TK_MANUALSTART = 379,
      TK_MAPPING = 380,
      TK_MATCHED = 381,
      TK_MATERIALIZED = 382,
      TK_MAXFILES = 383,
      TK_MAXFILESIZE = 384,
      TK_MAXVALUE = 385,
      TK_MDC = 386,
      TK_MERGE = 387,
      TK_MESSAGE_TEXT = 388,
      TK_METHOD = 389,
      TK_METHODS = 390,
      TK_MICROSECOND = 391,
      TK_MICROSECONDS = 392,
      TK_MINPCTUSED = 393,
      TK_MINUTE = 394,
      TK_MINUTES = 395,
      TK_MINVALUE = 396,
      TK_MIXED = 397,
      TK_MODE = 398,
      TK_MODIFIES = 399,
      TK_MONITOR = 400,
      TK_MONTH = 401,
      TK_MONTHS = 402,
      TK_MOVEMENT = 403,
      TK_MULTISET = 404,
      TK_N = 405,
      TK_NAME = 406,
      TK_NEW = 407,
      TK_NEW_TABLE = 408,
      TK_NEXT = 409,
      TK_NEXTVAL = 410,
      TK_NICKNAME = 411,
      TK_NO = 412,
      TK_NOCACHE = 413,
      TK_NOCYCLE = 414,
      TK_NODE = 415,
      TK_NODES = 416,
      TK_NODEGROUP = 417,
      TK_NOMAXVALUE = 418,
      TK_NOMINVALUE = 419,
      TK_NONBLOCKED = 420,
      TK_NONE = 421,
      TK_NOORDER = 422,
      TK_NOT = 423,
      TK_NULL = 424,
      TK_NULLS = 425,
      TK_NUM = 426,
      TK_NUMBLOCKPAGES = 427,
      TK_NUMERIC = 428,
      TK_NUM_FREQVALUES = 429,
      TK_NUM_QUANTILES = 430,
      TK_OBJECT = 431,
      TK_OF = 432,
      TK_OFF = 433,
      TK_OLD = 434,
      TK_OLD_TABLE = 435,
      TK_OLE = 436,
      TK_OLEDB = 437,
      TK_ON = 438,
      TK_ONCE = 439,
      TK_ONLINE = 440,
      TK_ONLY = 441,
      TK_OPEN = 442,
      TK_OPTIMIZATION = 443,
      TK_OPTIMIZE = 444,
      TK_OPTION = 445,
      TK_OPTIONS = 446,
      TK_OR = 447,
      TK_ORDER = 448,
      TK_ORGANIZE = 449,
      TK_OUT = 450,
      TK_OUTER = 451,
      TK_OVER = 452,
      TK_OVERFLOW = 453,
      TK_OVERHEAD = 454,
      TK_OVERRIDING = 455,
      TK_P = 456,
      TK_PACKAGE = 457,
      TK_PAGE = 458,
      TK_PAGESIZE = 459,
      TK_PARALLEL = 460,
      TK_PARAMETER = 461,
      TK_PASSTHRU = 462,
      TK_PASSWORD = 463,
      TK_PATH = 464,
      TK_PARTITION = 465,
      TK_PARTITIONING = 466,
      TK_PARTITIONINGS = 467,
      TK_PATROLLER = 468,
      TK_PCTDEACTIVATE = 469,
      TK_PCTFREE = 470,
      TK_PENDING = 471,
      TK_PERCENT_ARGBYTES = 472,
      TK_PERMISSION = 473,
      TK_PIECESIZE = 474,
      TK_PIPE = 475,
      TK_PLAN = 476,
      TK_PRECEDING = 477,
      TK_PRECISION = 478,
      TK_PREDICATES = 479,
      TK_PREFETCHSIZE = 480,
      TK_PREPARE = 481,
      TK_PRESERVE = 482,
      TK_PREVIOUS = 483,
      TK_PREVVAL = 484,
      TK_PRIMARY = 485,
      TK__PRIMARYKEY = 486,
      TK_PRIQTY = 487,
      TK_PRIVILEGES = 488,
      TK_PROCEDURE = 489,
      TK_PROFILE = 490,
      TK_PROGRAM = 491,
      TK_PROPAGATE = 492,
      TK_PROTOCOL = 493,
      TK_PRUNE = 494,
      TK_PUBLIC = 495,
      TK_QUERY = 496,
      TK_QUERYNO = 497,
      TK_QUERYTAG = 498,
      TK_QUIESCE_CONNECT = 499,
      TK_RANGE = 500,
      TK_RATE = 501,
      TK_RATIO = 502,
      TK_READ = 503,
      TK_READS = 504,
      TK_REAL = 505,
      TK_RECOMMEND = 506,
      TK_RECONCILE = 507,
      TK_RECOVERY = 508,
      TK_RECREATE = 509,
      TK_REDUCE = 510,
      TK_REF = 511,
      TK_REFERENCE = 512,
      TK_REFERENCES = 513,
      TK_REFERENCING = 514,
      TK_REFRESH = 515,
      TK_REGISTERS = 516,
      TK_REGULAR = 517,
      TK_RELEASE = 518,
      TK_REMAIN = 519,
      TK_REMOTE = 520,
      TK_RENAME = 521,
      TK_REOPT = 522,
      TK_REPEATABLE = 523,
      TK_REPEAT = 524,
      TK_REPLACE = 525,
      TK_REPLICATED = 526,
      TK_REQUIRING = 527,
      TK_RESET = 528,
      TK_RESIDENT = 529,
      TK_RESIGNAL = 530,
      TK_RESIZE = 531,
      TK_RESOLVE = 532,
      TK_RESTART = 533,
      TK_RESTORE = 534,
      TK_RESTRICT = 535,
      TK_RESULT = 536,
      TK_RESULT_SET_LOCATOR = 537,
      TK_RETAIN = 538,
      TK_RETURN = 539,
      TK_RETURNS = 540,
      TK_RETURN_STATUS = 541,
      TK_REVERSE = 542,
      TK_REVOKE = 543,
      TK_RIGHT = 544,
      TK_ROLLBACK = 545,
      TK_ROLLUP = 546,
      TK_ROUTINE = 547,
      TK_ROW = 548,
      TK_ROW_COUNT = 549,
      TK_ROWS = 550,
      TK_RR = 551,
      TK_RS = 552,
      TK_RUN = 553,
      TK_S = 554,
      TK_SAMPLED = 555,
      TK_SAVEPOINT = 556,
      TK_SBCS = 557,
      TK_SCANS = 558,
      TK_SCHEMA = 559,
      TK_SCOPE = 560,
      TK_SCRATCHPAD = 561,
      TK_SCROLL = 562,
      TK_SEARCH = 563,
      TK_SECOND = 564,
      TK_SECONDS = 565,
      TK_SECQTY = 566,
      TK_SECURITYADM = 567,
      TK_SELECT = 568,
      TK_SELECTION = 569,
      TK_SELECTIVE = 570,
      TK_SELECTIVITY = 571,
      TK_SELF = 572,
      TK_SENSITIVE = 573,
      TK_SEQUENCE = 574,
      TK_SERIALIZABLE = 575,
      TK_SERVER = 576,
      TK_SESSION = 577,
      TK_SESSION_USER = 578,
      TK_SET = 579,
      TK_SETS = 580,
      TK_SETTING = 581,
      TK_SHARE = 582,
      TK_SHRLEVEL = 583,
      TK_SIGNAL = 584,
      TK_SIMPLE = 585,
      TK_SIZE = 586,
      TK_SMALLINT = 587,
      TK_SNAPSHOT = 588,
      TK_SOME = 589,
      TK_SOURCE = 590,
      TK_SPECIAL = 591,
      TK_SPECIFIC = 592,
      TK_SPECIFICATION = 593,
      TK_SPLIT = 594,
      TK_SQL = 595,
      TK_SQLDATA = 596,
      TK_SQLERROR = 597,
      TK_SQLEXCEPTION = 598,
      TK_SQLWARNING = 599,
      TK_SQLID = 600,
      TK_SQLMACRO = 601,
      TK_SQLSTATE = 602,
      TK_SSA = 603,
      TK_STABILITY = 604,
      TK_STAGING = 605,
      TK_START = 606,
      TK_STATE = 607,
      TK_STATEMENT = 608,
      TK_STATEMENTS = 609,
      TK_STATIC = 610,
      TK_STATISTICS = 611,
      TK_STARTING = 612,
      TK_STAY = 613,
      TK_STMT = 614,
      TK_STOGROUP = 615,
      TK_STORAGE = 616,
      TK_STORED = 617,
      TK_STRIP = 618,
      TK_STRIPE = 619,
      TK_STYLE = 620,
      TK_SUB = 621,
      TK_SUBSECTION = 622,
      TK_SUMMARY = 623,
      TK_SWITCH = 624,
      TK_SYMMETRIC = 625,
      TK_SYNONYM = 626,
      TK_SYSTEM = 627,
      TK_SYSTEM_USER = 628,
      TK_T = 629,
      TK_TABLE = 630,
      TK_TABLES = 631,
      TK_TABLESAMPLE = 632,
      TK_TABLESPACE = 633,
      TK_TABLESPACES = 634,
      TK_TARGET = 635,
      TK_TEMPLATE = 636,
      TK_TEMPORARY = 637,
      TK_THEN = 638,
      TK_THREADSAFE = 639,
      TK_THROUGH = 640,
      TK_TIME = 641,
      TK_TIMEOUT = 642,
      TK_TIMESTAMP = 643,
      TK_TIMEZONE = 644,
      TK_TO = 645,
      TK_TOKEN = 646,
      TK_TRAILING = 647,
      TK_TRANSACTIONS = 648,
      TK_TRANSFERRATE = 649,
      TK_TRANSFORM = 650,
      TK_TRANSFORMS = 651,
      TK_TRANSLATE = 652,
      TK_TREAT = 653,
      TK_TRIGGER = 654,
      TK_TRUE = 655,
      TK_TRUNC = 656,
      TK_TWOLEVEL = 657,
      TK_TYPE = 658,
      TK_TYPES = 659,
      TK_UNBOUNDED = 660,
      TK_UNCHECKED = 661,
      TK_UNCOMMITTED = 662,
      TK_UNDER = 663,
      TK_UNDO = 664,
      TK_UNICODE = 665,
      TK_UNION = 666,
      TK_UNIQUE = 667,
      TK_UNLINK = 668,
      TK_UNTIL = 669,
      TK_UPDATE = 670,
      TK_UR = 671,
      TK_URL = 672,
      TK_USA = 673,
      TK_USE = 674,
      TK_USAGE = 675,
      TK_USER = 676,
      TK_USERID = 677,
      TK_USING = 678,
      TK_VALUE = 679,
      TK_VALUES = 680,
      TK_VARCHAR = 681,
      TK_VARGRAPHIC = 682,
      TK_VARIANT = 683,
      TK_VARYING = 684,
      TK_VCAT = 685,
      TK_VERSION = 686,
      TK_VIEW = 687,
      TK_VOLATILE = 688,
      TK_WAIT = 689,
      TK_WHEN = 690,
      TK_WHERE = 691,
      TK_WHILE = 692,
      TK_WITH = 693,
      TK_WITHOUT = 694,
      TK_WORK = 695,
      TK_WRAPPER = 696,
      TK_WRITE = 697,
      TK_WRKSTNNAME = 698,
      TK_X = 699,
      TK_XACT = 700,
      TK_YEAR = 701,
      TK_YEARS = 702,
      TK_YES = 703,
      TK_ABSENT = 704,
      TK_ACCORDING = 705,
      TK_BASE64 = 706,
      TK_DOCUMENT = 707,
      TK_ENCODING = 708,
      TK_HEX = 709,
      TK_LOCATION = 710,
      TK_NAMESPACE = 711,
      TK_NIL = 712,
      TK_ORDINALITY = 713,
      TK_PASSING = 714,
      TK_PI = 715,
      TK_RETURNING = 716,
      TK_URI = 717,
      TK_WHITESPACE = 718,
      TK_XML = 719,
      TK_XMLAGG = 720,
      TK_XMLATTRIBUTES = 721,
      TK_XMLBINARY = 722,
      TK_XMLCAST = 723,
      TK_XMLCOMMENT = 724,
      TK_XMLCONCAT = 725,
      TK_XMLDECLARATION = 726,
      TK_XMLDOCUMENT = 727,
      TK_XMLELEMENT = 728,
      TK_XMLEXISTS = 729,
      TK_XMLFOREST = 730,
      TK_XMLNAMESPACES = 731,
      TK_XMLPARSE = 732,
      TK_XMLPI = 733,
      TK_XMLQUERY = 734,
      TK_XMLSCHEMA = 735,
      TK_XMLSERIALIZE = 736,
      TK_XMLTABLE = 737,
      TK_XMLTEXT = 738,
      TK_XMLVALIDATE = 739,
      TK_EOLN = 740,
      TK_PARSE_ERROR = 741,
      TK_REGULAR_IDENTIFIER = 742,
      TK_DELIMITED_IDENTIFIER = 743,
      TK_EMBEDDED_VARIABLE_NAME = 744,
      TK_UNSIGNED_INTEGER = 745,
      TK_SUFFIXED_UNSIGNED_INTEGER = 746,
      TK_EXACT_NUMERIC_LITERAL = 747,
      TK_APPROXIMATE_NUMERIC_LITERAL = 748,
      TK_NATIONAL_CHAR_STRING_LITERAL = 749,
      TK_NATIONAL_HEX_STRING_LITERAL = 750,
      TK_BIT_STRING_LITERAL = 751,
      TK_HEX_STRING_LITERAL = 752,
      TK_CHAR_STRING_LITERAL = 753,
      TK_COMMENT_STRING = 754,
      TK_DELIMITED_TYPE_IDENTIFIER = 755,
      TK_VERSION_IDENTIFIER = 756,
      TK_DOUBLE_QUOTE = 757,
      TK_QUOTE = 758,
      TK_LEFT_PAREN = 759,
      TK_RIGHT_PAREN = 760,
      TK_ASTERISK = 761,
      TK_PLUS_SIGN = 762,
      TK_COMMA = 763,
      TK_MINUS_SIGN = 764,
      TK_PERIOD = 765,
      TK_SOLIDUS = 766,
      TK_COLON = 767,
      TK_SEMICOLON = 768,
      TK_LESS_THAN_OPERATOR = 769,
      TK_EQUALS_OPERATOR = 770,
      TK_GREATER_THAN_OPERATOR = 771,
      TK_QUESTION_MARK = 772,
      TK_LEFT_BRACKET = 773,
      TK_RIGHT_BRACKET = 774,
      TK_LEFT_BRACKET_TRIGRAPH = 775,
      TK_RIGHT_BRACKET_TRIGRAPH = 776,
      TK_VERTICAL_BAR = 777,
      TK_NOT_EQUALS_OPERATOR = 778,
      TK_GREATER_THAN_OR_EQUALS_OPERATOR = 779,
      TK_LESS_THAN_OR_EQUALS_OPERATOR = 780,
      TK_CONCAT_OPERATOR = 781,
      TK_DOUBLE_PERIOD = 782,
      TK_RIGHT_ARROW = 783,
      TK_STATEMENT_TERMINATOR = 784,
      TK_HOSTVARIABLE = 785,
      TK_PARAMETER_MARKER = 786,
      TK_LINE_COMMENT = 787,
      TK_EOF = 788;

      public final static String orderedTerminalSymbols[] = {
                 "",
                 "ACCESS",
                 "ACCTNG",
                 "ACTION",
                 "ACTIVATE",
                 "ADD",
                 "ADMIN",
                 "ADMINISTRATION",
                 "AFTER",
                 "AGE",
                 "ALIAS",
                 "ALL",
                 "ALLOCATE",
                 "ALLOW",
                 "ALTER",
                 "ALTERIN",
                 "ALWAYS",
                 "AND",
                 "ANY",
                 "APPEND",
                 "APPL_ID",
                 "APPL_NAME",
                 "APPLNAME",
                 "ARRAY",
                 "AS",
                 "ASC",
                 "ASCII",
                 "ASENSITIVE",
                 "ASSIGNMENT",
                 "ASSOCIATE",
                 "AST",
                 "ASUTIME",
                 "AT",
                 "ATOMIC",
                 "ATTRIBUTE",
                 "ATTRIBUTES",
                 "AUTHORIZATION",
                 "AUTH_ID",
                 "AUTHID",
                 "AUTOMATIC",
                 "AUTOSTART",
                 "AVAILABLE",
                 "B",
                 "BEFORE",
                 "BEGIN",
                 "BERNOULLI",
                 "BETWEEN",
                 "BIGINT",
                 "BINARY",
                 "BIND",
                 "BINDADD",
                 "BIT",
                 "BLOB",
                 "BLOCKED",
                 "BLOCKSIZE",
                 "BOTH",
                 "BUFFER",
                 "BUFFERPOOL",
                 "BUFFERPOOLS",
                 "BUFFERSIZE",
                 "BUILD",
                 "BY",
                 "BYPASS",
                 "C",
                 "CACHE",
                 "CACHING",
                 "CALL",
                 "CALLED",
                 "CALLER",
                 "CAPTURE",
                 "CARDINALITIES",
                 "CARDINALITY",
                 "CASCADE",
                 "CASCADED",
                 "CASE",
                 "CAST",
                 "CCSID",
                 "CHANGE",
                 "CHANGED",
                 "CHANGES",
                 "CHAR",
                 "CHARACTER",
                 "CHECK",
                 "CHECKED",
                 "CLIENT",
                 "CLIENT_ACCTNG",
                 "CLIENT_APPLNAME",
                 "CLIENT_USERID",
                 "CLIENT_WRKSTNNAME",
                 "CLOB",
                 "CLOSE",
                 "CLR",
                 "CLUSTER",
                 "COBOL",
                 "COLLECT",
                 "COLLID",
                 "COLUMN",
                 "COLUMNS",
                 "COMM",
                 "COMMENT",
                 "COMMIT",
                 "COMMITTED",
                 "COMPACT",
                 "COMPARE",
                 "COMPARISONS",
                 "COMPRESS",
                 "COMPRESSION",
                 "CONCAT",
                 "CONDITION",
                 "CONN",
                 "CONNECT",
                 "CONNECTIONS",
                 "CONNECTOPT",
                 "CONNHEADER",
                 "CONNMEMUSE",
                 "CONSERVATIVE",
                 "CONSTRAINT",
                 "CONSTRAINTS",
                 "CONSTRUCTOR",
                 "CONTAINERS",
                 "CONTAINS",
                 "CONTENT",
                 "CONTINUE",
                 "CONTINUOUSLY",
                 "CONTROL",
                 "COPY",
                 "COUNT",
                 "COUNT_BIG",
                 "CPU",
                 "CREATE",
                 "CREATE_EXTERNAL_ROUTINE",
                 "CREATEIN",
                 "CREATE_NOT_FENCED",
                 "CREATE_NOT_FENCED_ROUTINE",
                 "CREATETAB",
                 "CS",
                 "CUBE",
                 "CURRENT",
                 "CURRENT_DATE",
                 "CURRENT_DEFAULT_TRANSFORM_GROUP",
                 "CURRENT_PATH",
                 "CURRENT_ROLE",
                 "CURRENT_SCHEMA",
                 "CURRENT_SERVER",
                 "CURRENT_TIME",
                 "CURRENT_TIMESTAMP",
                 "CURRENT_TIMEZONE",
                 "CURRENT_TRANSFORM_GROUP_FOR_TYPE",
                 "CURRENT_USER",
                 "CURRVAL",
                 "CURSOR",
                 "CURSORS",
                 "CYCLE",
                 "DATA",
                 "DATABASE",
                 "DATALINK",
                 "DATE",
                 "DAY",
                 "DAYS",
                 "DB",
                 "DBADM",
                 "DBCLOB",
                 "DBINFO",
                 "DBMEMUSE",
                 "DBPARTITIONNUM",
                 "DBPARTITIONNUMS",
                 "DB2DARI",
                 "DB2GENRL",
                 "DB2GENERAL",
                 "DB2OPTIONS",
                 "DB2SPL",
                 "DB2SQL",
                 "DB2_RETURN_STATUS",
                 "DB2_TOKEN_STRING",
                 "DEACTIVATE",
                 "DEADLOCK",
                 "DEADLOCKS",
                 "DEC",
                 "DECIMAL",
                 "DECLARE",
                 "DEFAULT",
                 "DEFAULTS",
                 "DEFINE",
                 "DEFINITION",
                 "DEGREE",
                 "DEFER",
                 "DEFERRED",
                 "DELETE",
                 "DESC",
                 "DESCRIPTOR",
                 "DETAILED",
                 "DETAILS",
                 "DETERMINED",
                 "DETERMINISTIC",
                 "DEVICE",
                 "DIAGNOSTICS",
                 "DIMENSIONS",
                 "DIRTY",
                 "DISABLE",
                 "DISALLOW",
                 "DISPATCH",
                 "DISTINCT",
                 "DISTRIBUTION",
                 "DLCONN",
                 "DLLOCK",
                 "DO",
                 "DOUBLE",
                 "DROP",
                 "DROPIN",
                 "DROPPED",
                 "DYNAMIC",
                 "EACH",
                 "ELEMENT",
                 "ELSE",
                 "ELSEIF",
                 "EMPTY",
                 "ENABLE",
                 "ENCRYPTION",
                 "END",
                 "ENDING",
                 "ENFORCED",
                 "ERASE",
                 "ESCAPE",
                 "ESTIMATE",
                 "EUR",
                 "EVALUATE",
                 "EVENT",
                 "EXACT",
                 "EXCEPT",
                 "EXCEPTION",
                 "EXCLUDE",
                 "EXCLUDES",
                 "EXCLUDING",
                 "EXCLUSIVE",
                 "EXECNODE",
                 "EXECUTE",
                 "EXISTS",
                 "EXIT",
                 "EXPAND",
                 "EXPLAIN",
                 "EXPRESSION",
                 "EXTEND",
                 "EXTENDED",
                 "EXTENSION",
                 "EXTENTSIZE",
                 "EXTERNAL",
                 "FALSE",
                 "FEDERATED",
                 "FEDERATED_TOOL",
                 "FENCED",
                 "FETCH",
                 "FILE",
                 "FILTER",
                 "FINAL",
                 "FIRST",
                 "FLOAT",
                 "FLUSH",
                 "FOLLOWING",
                 "FOR",
                 "FORCE",
                 "FOREIGN",
                 "_FOREIGNKEY",
                 "FOUND",
                 "FREE",
                 "FREEPAGE",
                 "FROM",
                 "FS",
                 "FULL",
                 "FUNCTION",
                 "G",
                 "GBPCACHE",
                 "GENERAL",
                 "GENERATE",
                 "GENERATED",
                 "GET",
                 "GLOBAL",
                 "GOTO",
                 "GRANT",
                 "GRAPHIC",
                 "GROUP",
                 "GROUPING",
                 "HANDLER",
                 "HASHING",
                 "HAVING",
                 "HIDDEN",
                 "HIERARCHY",
                 "HIGH",
                 "HOLD",
                 "HOUR",
                 "HOURS",
                 "HPJ",
                 "ID",
                 "IDENTITY",
                 "IF",
                 "IGNORE",
                 "IMMEDIATE",
                 "IMPLICIT_SCHEMA",
                 "IN",
                 "INCLUDE",
                 "INCLUDES",
                 "INCLUDING",
                 "INCREMENT",
                 "INCREMENTAL",
                 "INDEX",
                 "INDEXES",
                 "INDICATOR",
                 "INFIX",
                 "INFO",
                 "INHERIT",
                 "INITIALLY",
                 "INITIAL_INSTS",
                 "INITIAL_IOS",
                 "INLINE",
                 "INNER",
                 "INOUT",
                 "INPUT",
                 "INSENSITIVE",
                 "INSERT",
                 "INSTANTIABLE",
                 "INSTEAD",
                 "INSTS_PER_ARGBYTE",
                 "INSTS_PER_INVOC",
                 "INT",
                 "INTEGER",
                 "INTEGRITY",
                 "INTERSECT",
                 "INTO",
                 "IO",
                 "IOS_PER_ARGBYTE",
                 "IOS_PER_INVOC",
                 "IS",
                 "ISO",
                 "ITERATE",
                 "ISOLATION",
                 "JAVA",
                 "JIS",
                 "JOIN",
                 "K",
                 "KEEP",
                 "KEY",
                 "KEYS",
                 "L",
                 "LANGUAGE",
                 "LARGE",
                 "LAST",
                 "LATERAL",
                 "LC_CTYPE",
                 "LEADING",
                 "LEAVE",
                 "LEFT",
                 "LENGTH",
                 "LEVEL",
                 "LEVEL2",
                 "LIBRARY",
                 "LIBRARYADM",
                 "LIKE",
                 "LIMIT",
                 "LINK",
                 "LINKTYPE",
                 "LOAD",
                 "LOCAL",
                 "LOCALE",
                 "LOCALTIME",
                 "LOCALTIMESTAMP",
                 "LOCATOR",
                 "LOCATORS",
                 "LOCK",
                 "LOCKS",
                 "LOCKSIZE",
                 "LOG",
                 "LOGGED",
                 "LONG",
                 "LONGVAR",
                 "LOOP",
                 "LOW",
                 "M",
                 "MAINTAINED",
                 "MAIN_PROG",
                 "MANAGED",
                 "MANUALSTART",
                 "MAPPING",
                 "MATCHED",
                 "MATERIALIZED",
                 "MAXFILES",
                 "MAXFILESIZE",
                 "MAXVALUE",
                 "MDC",
                 "MERGE",
                 "MESSAGE_TEXT",
                 "METHOD",
                 "METHODS",
                 "MICROSECOND",
                 "MICROSECONDS",
                 "MINPCTUSED",
                 "MINUTE",
                 "MINUTES",
                 "MINVALUE",
                 "MIXED",
                 "MODE",
                 "MODIFIES",
                 "MONITOR",
                 "MONTH",
                 "MONTHS",
                 "MOVEMENT",
                 "MULTISET",
                 "N",
                 "NAME",
                 "NEW",
                 "NEW_TABLE",
                 "NEXT",
                 "NEXTVAL",
                 "NICKNAME",
                 "NO",
                 "NOCACHE",
                 "NOCYCLE",
                 "NODE",
                 "NODES",
                 "NODEGROUP",
                 "NOMAXVALUE",
                 "NOMINVALUE",
                 "NONBLOCKED",
                 "NONE",
                 "NOORDER",
                 "NOT",
                 "NULL",
                 "NULLS",
                 "NUM",
                 "NUMBLOCKPAGES",
                 "NUMERIC",
                 "NUM_FREQVALUES",
                 "NUM_QUANTILES",
                 "OBJECT",
                 "OF",
                 "OFF",
                 "OLD",
                 "OLD_TABLE",
                 "OLE",
                 "OLEDB",
                 "ON",
                 "ONCE",
                 "ONLINE",
                 "ONLY",
                 "OPEN",
                 "OPTIMIZATION",
                 "OPTIMIZE",
                 "OPTION",
                 "OPTIONS",
                 "OR",
                 "ORDER",
                 "ORGANIZE",
                 "OUT",
                 "OUTER",
                 "OVER",
                 "OVERFLOW",
                 "OVERHEAD",
                 "OVERRIDING",
                 "P",
                 "PACKAGE",
                 "PAGE",
                 "PAGESIZE",
                 "PARALLEL",
                 "PARAMETER",
                 "PASSTHRU",
                 "PASSWORD",
                 "PATH",
                 "PARTITION",
                 "PARTITIONING",
                 "PARTITIONINGS",
                 "PATROLLER",
                 "PCTDEACTIVATE",
                 "PCTFREE",
                 "PENDING",
                 "PERCENT_ARGBYTES",
                 "PERMISSION",
                 "PIECESIZE",
                 "PIPE",
                 "PLAN",
                 "PRECEDING",
                 "PRECISION",
                 "PREDICATES",
                 "PREFETCHSIZE",
                 "PREPARE",
                 "PRESERVE",
                 "PREVIOUS",
                 "PREVVAL",
                 "PRIMARY",
                 "_PRIMARYKEY",
                 "PRIQTY",
                 "PRIVILEGES",
                 "PROCEDURE",
                 "PROFILE",
                 "PROGRAM",
                 "PROPAGATE",
                 "PROTOCOL",
                 "PRUNE",
                 "PUBLIC",
                 "QUERY",
                 "QUERYNO",
                 "QUERYTAG",
                 "QUIESCE_CONNECT",
                 "RANGE",
                 "RATE",
                 "RATIO",
                 "READ",
                 "READS",
                 "REAL",
                 "RECOMMEND",
                 "RECONCILE",
                 "RECOVERY",
                 "RECREATE",
                 "REDUCE",
                 "REF",
                 "REFERENCE",
                 "REFERENCES",
                 "REFERENCING",
                 "REFRESH",
                 "REGISTERS",
                 "REGULAR",
                 "RELEASE",
                 "REMAIN",
                 "REMOTE",
                 "RENAME",
                 "REOPT",
                 "REPEATABLE",
                 "REPEAT",
                 "REPLACE",
                 "REPLICATED",
                 "REQUIRING",
                 "RESET",
                 "RESIDENT",
                 "RESIGNAL",
                 "RESIZE",
                 "RESOLVE",
                 "RESTART",
                 "RESTORE",
                 "RESTRICT",
                 "RESULT",
                 "RESULT_SET_LOCATOR",
                 "RETAIN",
                 "RETURN",
                 "RETURNS",
                 "RETURN_STATUS",
                 "REVERSE",
                 "REVOKE",
                 "RIGHT",
                 "ROLLBACK",
                 "ROLLUP",
                 "ROUTINE",
                 "ROW",
                 "ROW_COUNT",
                 "ROWS",
                 "RR",
                 "RS",
                 "RUN",
                 "S",
                 "SAMPLED",
                 "SAVEPOINT",
                 "SBCS",
                 "SCANS",
                 "SCHEMA",
                 "SCOPE",
                 "SCRATCHPAD",
                 "SCROLL",
                 "SEARCH",
                 "SECOND",
                 "SECONDS",
                 "SECQTY",
                 "SECURITYADM",
                 "SELECT",
                 "SELECTION",
                 "SELECTIVE",
                 "SELECTIVITY",
                 "SELF",
                 "SENSITIVE",
                 "SEQUENCE",
                 "SERIALIZABLE",
                 "SERVER",
                 "SESSION",
                 "SESSION_USER",
                 "SET",
                 "SETS",
                 "SETTING",
                 "SHARE",
                 "SHRLEVEL",
                 "SIGNAL",
                 "SIMPLE",
                 "SIZE",
                 "SMALLINT",
                 "SNAPSHOT",
                 "SOME",
                 "SOURCE",
                 "SPECIAL",
                 "SPECIFIC",
                 "SPECIFICATION",
                 "SPLIT",
                 "SQL",
                 "SQLDATA",
                 "SQLERROR",
                 "SQLEXCEPTION",
                 "SQLWARNING",
                 "SQLID",
                 "SQLMACRO",
                 "SQLSTATE",
                 "SSA",
                 "STABILITY",
                 "STAGING",
                 "START",
                 "STATE",
                 "STATEMENT",
                 "STATEMENTS",
                 "STATIC",
                 "STATISTICS",
                 "STARTING",
                 "STAY",
                 "STMT",
                 "STOGROUP",
                 "STORAGE",
                 "STORED",
                 "STRIP",
                 "STRIPE",
                 "STYLE",
                 "SUB",
                 "SUBSECTION",
                 "SUMMARY",
                 "SWITCH",
                 "SYMMETRIC",
                 "SYNONYM",
                 "SYSTEM",
                 "SYSTEM_USER",
                 "T",
                 "TABLE",
                 "TABLES",
                 "TABLESAMPLE",
                 "TABLESPACE",
                 "TABLESPACES",
                 "TARGET",
                 "TEMPLATE",
                 "TEMPORARY",
                 "THEN",
                 "THREADSAFE",
                 "THROUGH",
                 "TIME",
                 "TIMEOUT",
                 "TIMESTAMP",
                 "TIMEZONE",
                 "TO",
                 "TOKEN",
                 "TRAILING",
                 "TRANSACTIONS",
                 "TRANSFERRATE",
                 "TRANSFORM",
                 "TRANSFORMS",
                 "TRANSLATE",
                 "TREAT",
                 "TRIGGER",
                 "TRUE",
                 "TRUNC",
                 "TWOLEVEL",
                 "TYPE",
                 "TYPES",
                 "UNBOUNDED",
                 "UNCHECKED",
                 "UNCOMMITTED",
                 "UNDER",
                 "UNDO",
                 "UNICODE",
                 "UNION",
                 "UNIQUE",
                 "UNLINK",
                 "UNTIL",
                 "UPDATE",
                 "UR",
                 "URL",
                 "USA",
                 "USE",
                 "USAGE",
                 "USER",
                 "USERID",
                 "USING",
                 "VALUE",
                 "VALUES",
                 "VARCHAR",
                 "VARGRAPHIC",
                 "VARIANT",
                 "VARYING",
                 "VCAT",
                 "VERSION",
                 "VIEW",
                 "VOLATILE",
                 "WAIT",
                 "WHEN",
                 "WHERE",
                 "WHILE",
                 "WITH",
                 "WITHOUT",
                 "WORK",
                 "WRAPPER",
                 "WRITE",
                 "WRKSTNNAME",
                 "X",
                 "XACT",
                 "YEAR",
                 "YEARS",
                 "YES",
                 "ABSENT",
                 "ACCORDING",
                 "BASE64",
                 "DOCUMENT",
                 "ENCODING",
                 "HEX",
                 "LOCATION",
                 "NAMESPACE",
                 "NIL",
                 "ORDINALITY",
                 "PASSING",
                 "PI",
                 "RETURNING",
                 "URI",
                 "WHITESPACE",
                 "XML",
                 "XMLAGG",
                 "XMLATTRIBUTES",
                 "XMLBINARY",
                 "XMLCAST",
                 "XMLCOMMENT",
                 "XMLCONCAT",
                 "XMLDECLARATION",
                 "XMLDOCUMENT",
                 "XMLELEMENT",
                 "XMLEXISTS",
                 "XMLFOREST",
                 "XMLNAMESPACES",
                 "XMLPARSE",
                 "XMLPI",
                 "XMLQUERY",
                 "XMLSCHEMA",
                 "XMLSERIALIZE",
                 "XMLTABLE",
                 "XMLTEXT",
                 "XMLVALIDATE",
                 "EOLN",
                 "PARSE_ERROR",
                 "REGULAR_IDENTIFIER",
                 "DELIMITED_IDENTIFIER",
                 "EMBEDDED_VARIABLE_NAME",
                 "UNSIGNED_INTEGER",
                 "SUFFIXED_UNSIGNED_INTEGER",
                 "EXACT_NUMERIC_LITERAL",
                 "APPROXIMATE_NUMERIC_LITERAL",
                 "NATIONAL_CHAR_STRING_LITERAL",
                 "NATIONAL_HEX_STRING_LITERAL",
                 "BIT_STRING_LITERAL",
                 "HEX_STRING_LITERAL",
                 "CHAR_STRING_LITERAL",
                 "COMMENT_STRING",
                 "DELIMITED_TYPE_IDENTIFIER",
                 "VERSION_IDENTIFIER",
                 "DOUBLE_QUOTE",
                 "QUOTE",
                 "LEFT_PAREN",
                 "RIGHT_PAREN",
                 "ASTERISK",
                 "PLUS_SIGN",
                 "COMMA",
                 "MINUS_SIGN",
                 "PERIOD",
                 "SOLIDUS",
                 "COLON",
                 "SEMICOLON",
                 "LESS_THAN_OPERATOR",
                 "EQUALS_OPERATOR",
                 "GREATER_THAN_OPERATOR",
                 "QUESTION_MARK",
                 "LEFT_BRACKET",
                 "RIGHT_BRACKET",
                 "LEFT_BRACKET_TRIGRAPH",
                 "RIGHT_BRACKET_TRIGRAPH",
                 "VERTICAL_BAR",
                 "NOT_EQUALS_OPERATOR",
                 "GREATER_THAN_OR_EQUALS_OPERATOR",
                 "LESS_THAN_OR_EQUALS_OPERATOR",
                 "CONCAT_OPERATOR",
                 "DOUBLE_PERIOD",
                 "RIGHT_ARROW",
                 "STATEMENT_TERMINATOR",
                 "HOSTVARIABLE",
                 "PARAMETER_MARKER",
                 "LINE_COMMENT",
                 "EOF"
             };


    public final static boolean isValidForParser = false;
}
