/**
 * <copyright>
 * </copyright>
 *
 * $Id: XMLValueFunctionText.java,v 1.1 2007/06/25 16:29:56 jgraham Exp $
 */
package org.eclipse.datatools.modelbase.sql.xml.query;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>XML Value Function Text</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Generates an XML value consisting of a XML text element from a given string expression.  See ISO SQL/XML sec. 6.18.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionText#getReturningOption <em>Returning Option</em>}</li>
 *   <li>{@link org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionText#getTextContent <em>Text Content</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.datatools.modelbase.sql.xml.query.SQLXMLQueryModelPackage#getXMLValueFunctionText()
 * @model
 * @generated
 */
public interface XMLValueFunctionText extends XMLValueFunction{
	/**
	 * Returns the value of the '<em><b>Returning Option</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.datatools.modelbase.sql.xml.query.XMLReturningType}.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Returning Option</em>' attribute isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Returning Option</em>' attribute.
	 * @see org.eclipse.datatools.modelbase.sql.xml.query.XMLReturningType
	 * @see #setReturningOption(XMLReturningType)
	 * @see org.eclipse.datatools.modelbase.sql.xml.query.SQLXMLQueryModelPackage#getXMLValueFunctionText_ReturningOption()
	 * @model
	 * @generated
	 */
    XMLReturningType getReturningOption();

	/**
	 * Sets the value of the '{@link org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionText#getReturningOption <em>Returning Option</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Returning Option</em>' attribute.
	 * @see org.eclipse.datatools.modelbase.sql.xml.query.XMLReturningType
	 * @see #getReturningOption()
	 * @generated
	 */
    void setReturningOption(XMLReturningType value);

	/**
	 * Returns the value of the '<em><b>Text Content</b></em>' containment reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionTextContent#getValueFunctionText <em>Value Function Text</em>}'.
	 * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Text Content</em>' containment reference isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
	 * @return the value of the '<em>Text Content</em>' containment reference.
	 * @see #setTextContent(XMLValueFunctionTextContent)
	 * @see org.eclipse.datatools.modelbase.sql.xml.query.SQLXMLQueryModelPackage#getXMLValueFunctionText_TextContent()
	 * @see org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionTextContent#getValueFunctionText
	 * @model opposite="valueFunctionText" containment="true" required="true"
	 * @generated
	 */
    XMLValueFunctionTextContent getTextContent();

	/**
	 * Sets the value of the '{@link org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionText#getTextContent <em>Text Content</em>}' containment reference.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Text Content</em>' containment reference.
	 * @see #getTextContent()
	 * @generated
	 */
    void setTextContent(XMLValueFunctionTextContent value);

} // XMLValueFunctionText
