/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.query.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceWriter;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceWriterProvider;
import org.osgi.framework.BundleContext;

public class SQLQueryModelPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.datatools.modelbase.sql.query";
    public static final String EXTENSION_POINT_ID = "sourceWriterExtension";
    public static final String EXTENSION_CONFIGURATION_PLUGINJAVA = "pluginJava";
    public static final String EXTENSION_CONFIG_PLUGINJAVA_ATTRIBUTE_CLASS = "class";
    public static final String EXTENSION_CONFIGURATION_SOURCEWRITER = "sourceWriter";
    public static final String EXTENSION_CONFIG_SOURCEWRITER_ATTRIBUTE_PACKAGE_NAME = "packageName";
    public static final String EXTENSION_CONFIG_SOURCEWRITER_ATTRIBUTE_IMPL_PACKAGE_NAME = "implPackageName";
    public static final String EXTENSION_CONFIG_SOURCEWRITER_ATTRIBUTE_SOURCEWRITER_CLASS = "class";
    private static SQLQueryModelPlugin plugin;

    public SQLQueryModelPlugin() {
        plugin = this;
        this.registerSourceWriter();
    }

    public static SQLQueryModelPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerSourceWriter();
    }

    private void registerSourceWriter() {
        SQLQuerySourceWriterProvider swProvider = SQLQuerySourceWriterProvider.getInstance();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        if (extensionPoint != null) {
            boolean extensionFound = false;
            IExtension[] extensions = extensionPoint.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                int j;
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                boolean isThisExtension = false;
                for (j = 0; j < configElements.length; ++j) {
                    if (!configElements[j].getName().equals(EXTENSION_CONFIGURATION_PLUGINJAVA)) continue;
                    String pluginJava = configElements[j].getAttribute("class");
                    if (!((Object)((Object)this)).getClass().getName().equals(pluginJava)) break;
                    isThisExtension = true;
                    break;
                }
                if (!isThisExtension) continue;
                for (j = 0; j < configElements.length; ++j) {
                    if (!configElements[j].getName().equals(EXTENSION_CONFIGURATION_SOURCEWRITER)) continue;
                    extensionFound = true;
                    IConfigurationElement configElement = configElements[j];
                    Class<?> sourceWriterClass = null;
                    String packageName = configElements[j].getAttribute(EXTENSION_CONFIG_SOURCEWRITER_ATTRIBUTE_PACKAGE_NAME);
                    String implPackageName = configElements[j].getAttribute(EXTENSION_CONFIG_SOURCEWRITER_ATTRIBUTE_IMPL_PACKAGE_NAME);
                    try {
                        SQLQuerySourceWriter sourceWriter = (SQLQuerySourceWriter)configElements[j].createExecutableExtension("class");
                        sourceWriterClass = sourceWriter.getClass();
                    }
                    catch (CoreException e) {
                        this.logErrorInstanciateSourceWriter(j, configElement, e, packageName, implPackageName);
                    }
                    if (sourceWriterClass != null) {
                        if (packageName != null) {
                            swProvider.registerSourceWriter(sourceWriterClass, packageName);
                        } else {
                            this.logErrorRegisterSourceWriterPackage(i, sourceWriterClass);
                        }
                        if (implPackageName != null) {
                            swProvider.registerSourceWriter(sourceWriterClass, implPackageName);
                            continue;
                        }
                        this.logErrorRegisterSourceWriterImplPackage(i, sourceWriterClass);
                        continue;
                    }
                    this.logErrorRegisterSourceWriterClass(i);
                }
            }
            if (!extensionFound) {
                this.logErrorNoExtensionConfigSourceWriter();
            }
        } else {
            this.logErrorNoSourceWriterExtensionPoint();
        }
    }

    private void logErrorNoSourceWriterExtensionPoint() {
        this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, "extension-point could not be found for org.eclipse.datatools.modelbase.sql.query.sourceWriterExtension", null));
    }

    private void logErrorInstanciateSourceWriter(int configurationNumber, IConfigurationElement configElement, CoreException ce, String packageName, String implPackageName) {
        String msg = "unable to instanciate SourceWriter " + configElement.getAttribute("class") + " in extension-point: " + PLUGIN_ID + "." + EXTENSION_POINT_ID + " configuration[" + configurationNumber + "]: " + EXTENSION_CONFIGURATION_SOURCEWRITER + " for " + EXTENSION_CONFIG_SOURCEWRITER_ATTRIBUTE_PACKAGE_NAME + " " + packageName + " and " + EXTENSION_CONFIG_SOURCEWRITER_ATTRIBUTE_IMPL_PACKAGE_NAME + " " + implPackageName;
        this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, msg, (Throwable)ce));
    }

    private void logErrorNoExtensionConfigSourceWriter() {
        String msg = "configuration: sourceWriter in extension-point: org.eclipse.datatools.modelbase.sql.query.sourceWriterExtension could not be found.";
        this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, msg, null));
    }

    private void logErrorRegisterSourceWriterClass(int configurationNumber) {
        String msg = "unable to register SourceWriter  in extension-point: org.eclipse.datatools.modelbase.sql.query.sourceWriterExtension configuration[" + configurationNumber + "]: " + EXTENSION_CONFIGURATION_SOURCEWRITER + ", " + "class" + " is null";
        this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, msg, null));
    }

    private void logErrorRegisterSourceWriterImplPackage(int configurationNumber, Class sourceWriterClass) {
        String msg = "unable to register SourceWriter " + sourceWriterClass.getName() + " for " + EXTENSION_CONFIG_SOURCEWRITER_ATTRIBUTE_IMPL_PACKAGE_NAME + " in extension-point: " + PLUGIN_ID + "." + EXTENSION_POINT_ID + " configuration[" + configurationNumber + "]: " + EXTENSION_CONFIGURATION_SOURCEWRITER + ", " + EXTENSION_CONFIG_SOURCEWRITER_ATTRIBUTE_IMPL_PACKAGE_NAME + " is null";
        this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, msg, null));
    }

    private void logErrorRegisterSourceWriterPackage(int confiurationNumber, Class sourceWriterClass) {
        String msg = "unable to register SourceWriter " + sourceWriterClass.getName() + " for " + EXTENSION_CONFIG_SOURCEWRITER_ATTRIBUTE_PACKAGE_NAME + " in extension-point: " + PLUGIN_ID + "." + EXTENSION_POINT_ID + " configuration[" + confiurationNumber + "]: " + EXTENSION_CONFIGURATION_SOURCEWRITER + ", " + EXTENSION_CONFIG_SOURCEWRITER_ATTRIBUTE_PACKAGE_NAME + " is null";
        this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, msg, null));
    }
}

