/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.query.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.query.ColumnName;
import org.eclipse.datatools.modelbase.sql.query.CursorReference;
import org.eclipse.datatools.modelbase.sql.query.GroupingExpression;
import org.eclipse.datatools.modelbase.sql.query.GroupingSets;
import org.eclipse.datatools.modelbase.sql.query.GroupingSetsElement;
import org.eclipse.datatools.modelbase.sql.query.GroupingSpecification;
import org.eclipse.datatools.modelbase.sql.query.OrderBySpecification;
import org.eclipse.datatools.modelbase.sql.query.OrderByValueExpression;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.PredicateBasic;
import org.eclipse.datatools.modelbase.sql.query.PredicateBetween;
import org.eclipse.datatools.modelbase.sql.query.PredicateExists;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueList;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueRowSelect;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueSelect;
import org.eclipse.datatools.modelbase.sql.query.PredicateIsNull;
import org.eclipse.datatools.modelbase.sql.query.PredicateLike;
import org.eclipse.datatools.modelbase.sql.query.PredicateQuantifiedRowSelect;
import org.eclipse.datatools.modelbase.sql.query.PredicateQuantifiedValueSelect;
import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QueryResultSpecification;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.QueryValues;
import org.eclipse.datatools.modelbase.sql.query.ResultColumn;
import org.eclipse.datatools.modelbase.sql.query.ResultTableAllColumns;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelFactory;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionNested;
import org.eclipse.datatools.modelbase.sql.query.SuperGroup;
import org.eclipse.datatools.modelbase.sql.query.SuperGroupElement;
import org.eclipse.datatools.modelbase.sql.query.TableCorrelation;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableFunction;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.TableJoined;
import org.eclipse.datatools.modelbase.sql.query.TableNested;
import org.eclipse.datatools.modelbase.sql.query.TableReference;
import org.eclipse.datatools.modelbase.sql.query.UpdateAssignmentExpression;
import org.eclipse.datatools.modelbase.sql.query.UpdateSourceExprList;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseElse;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearch;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearchContent;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimple;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimpleContent;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCast;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionDefaultValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionFunction;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionLabeledDuration;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNested;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNullValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionScalarSelect;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionSimple;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionVariable;
import org.eclipse.datatools.modelbase.sql.query.ValuesRow;
import org.eclipse.datatools.modelbase.sql.query.WithTableReference;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.ValueExpressionHelper;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TableHelper {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    public static final String DELIMITED_IDENTIFIER_QUOTE = "\"";

    public static ValueExpressionColumn getColumnExpressionForName(TableReference tableRef, String columnName) {
        if (tableRef != null) {
            if (tableRef instanceof TableExpression) {
                TableExpression tableExpr = (TableExpression)tableRef;
                return TableHelper.getColumnExpressionForName(tableExpr, columnName);
            }
            if (tableRef instanceof TableNested) {
                TableNested nest = (TableNested)tableRef;
                return TableHelper.getColumnExpressionForName(nest.getNestedTableRef(), columnName);
            }
            if (tableRef instanceof TableJoined) {
                TableJoined tableJoined = (TableJoined)tableRef;
                TableReference leftTableRef = tableJoined.getTableRefLeft();
                TableReference rightTableRef = tableJoined.getTableRefRight();
                ValueExpressionColumn leftColumn = TableHelper.getColumnExpressionForName(leftTableRef, columnName);
                if (leftColumn != null) {
                    return leftColumn;
                }
                ValueExpressionColumn rightColumn = TableHelper.getColumnExpressionForName(rightTableRef, columnName);
                return rightColumn;
            }
        }
        return null;
    }

    public static boolean isTableReferencedByColumnWithName(TableExpression tableExpr, String referencedByColumnName) {
        boolean colExprFound = false;
        if (tableExpr != null && referencedByColumnName != null) {
            EList colRefs = tableExpr.getValueExprColumns();
            Iterator colIt = colRefs.iterator();
            while (colIt.hasNext()) {
                ValueExpressionColumn colExpr = (ValueExpressionColumn)colIt.next();
                if (!referencedByColumnName.equals(colExpr.getName())) continue;
                colExprFound = true;
                break;
            }
        }
        return colExprFound;
    }

    public static ValueExpressionColumn getColumnExpressionForName(TableExpression tableExpr, String columnName) {
        ValueExpressionColumn colExprFound = null;
        if (tableExpr != null && columnName != null) {
            EList colList = tableExpr.getColumnList();
            Iterator colIt = colList.iterator();
            while (colIt.hasNext()) {
                ValueExpressionColumn colExpr = (ValueExpressionColumn)colIt.next();
                if (!columnName.equals(colExpr.getName())) continue;
                colExprFound = colExpr;
                break;
            }
        }
        return colExprFound;
    }

    public static ValueExpressionColumn getColumnExpressionForNameRecursively(TableExpression tableExpr, String columnName) {
        ValueExpressionColumn colExprFound = null;
        if (tableExpr != null && columnName != null) {
            colExprFound = TableHelper.getColumnExpressionForName(tableExpr, columnName);
        }
        if (colExprFound == null) {
            if (tableExpr instanceof QueryExpressionBody) {
                QueryExpressionBody tableQuery = (QueryExpressionBody)tableExpr;
                ResultColumn resultColFound = TableHelper.getResultColumnForAliasOrColumnName(tableQuery, columnName);
                if (resultColFound != null) {
                    ValueExpressionColumn resultColExpr = SQLQueryModelFactory.eINSTANCE.createValueExpressionColumn();
                    resultColExpr.setName(columnName);
                    tableQuery.getColumnList().add((Object)resultColExpr);
                    colExprFound = resultColExpr;
                }
            } else if (tableExpr instanceof WithTableReference) {
                WithTableReference withTable = (WithTableReference)tableExpr;
                StatementHelper.logError(TableHelper.class.getName() + "#getColumnExpressionForName(TableExpression,String) not implemented for TableExpression of type " + withTable.getClass().getName());
            } else {
                if (tableExpr instanceof TableFunction) {
                    TableFunction tableFunc = (TableFunction)tableExpr;
                    throw new UnsupportedOperationException(TableHelper.class.getName() + "#getColumnExpressionForName(TableExpression,String) not implemented for TableExpression of type " + tableFunc.getClass().getName());
                }
                if (tableExpr instanceof TableInDatabase) {
                    TableInDatabase tableInDB = (TableInDatabase)tableExpr;
                    Column dbColumn = TableHelper.getColumnForName(tableInDB, columnName);
                    if (dbColumn != null) {
                        colExprFound = TableHelper.getColumnExpressionForColumn(tableInDB, dbColumn);
                    }
                } else {
                    throw new UnsupportedOperationException(TableHelper.class.getName() + "#getColumnExpressionForName(TableExpression,String) not implemented for TableExpression of type " + tableExpr.getClass().getName());
                }
            }
        }
        return colExprFound;
    }

    public static ResultColumn getResultColumnForName(QueryExpressionBody tableQuery, String columnName) {
        ResultColumn resultColFound = null;
        if (tableQuery != null && columnName != null) {
            List resultColList = TableHelper.getResultColumnsOfQueryExpression(tableQuery);
            Iterator resultColIt = resultColList.iterator();
            while (resultColIt.hasNext()) {
                ResultColumn resultCol = (ResultColumn)resultColIt.next();
                if (!columnName.equals(resultCol.getName()) && (columnName.startsWith(DELIMITED_IDENTIFIER_QUOTE) || !columnName.equalsIgnoreCase(resultCol.getName()))) continue;
                resultColFound = resultCol;
                break;
            }
        }
        return resultColFound;
    }

    public static ResultColumn getResultColumnForAliasOrColumnName(QueryExpressionBody tableQuery, String columnName) {
        ResultColumn resultColFound = null;
        if (tableQuery != null && columnName != null) {
            List resultColList = TableHelper.getResultColumnsOfQueryExpression(tableQuery);
            Iterator resultColIt = resultColList.iterator();
            while (resultColIt.hasNext()) {
                ValueExpressionColumn resultColExpr;
                ResultColumn resultCol = (ResultColumn)resultColIt.next();
                QueryValueExpression resultExpr = resultCol.getValueExpr();
                if (columnName.equals(resultCol.getName()) || !columnName.startsWith(DELIMITED_IDENTIFIER_QUOTE) && columnName.equalsIgnoreCase(resultCol.getName())) {
                    resultColFound = resultCol;
                    break;
                }
                if (resultExpr == null || !(resultExpr instanceof ValueExpressionColumn) || !columnName.equals((resultColExpr = (ValueExpressionColumn)resultExpr).getName()) && (columnName.startsWith(DELIMITED_IDENTIFIER_QUOTE) || !columnName.equalsIgnoreCase(resultColExpr.getName()))) continue;
                resultColFound = resultCol;
                break;
            }
        }
        return resultColFound;
    }

    public static List getResultColumnsOfQueryExpression(QueryExpressionBody queryExpr) {
        ArrayList<ResultColumn> resultColList = new ArrayList<ResultColumn>();
        if (queryExpr != null) {
            if (queryExpr instanceof QuerySelect) {
                QuerySelect select = (QuerySelect)queryExpr;
                EList resultSpecList = select.getSelectClause();
                Iterator resultSpecIt = resultSpecList.iterator();
                while (resultSpecIt.hasNext()) {
                    QueryResultSpecification resultSpec = (QueryResultSpecification)resultSpecIt.next();
                    if (!(resultSpec instanceof ResultColumn)) continue;
                    ResultColumn resultCol = (ResultColumn)resultSpec;
                    resultColList.add(resultCol);
                }
            } else if (queryExpr instanceof QueryCombined) {
                QueryCombined combinedQ = (QueryCombined)queryExpr;
                resultColList.addAll(TableHelper.getResultColumnsOfQueryExpression(combinedQ.getLeftQuery()));
                resultColList.addAll(TableHelper.getResultColumnsOfQueryExpression(combinedQ.getRightQuery()));
            } else {
                throw new UnsupportedOperationException(TableHelper.class.getName() + "#getColumnExpressionForName(QueryExpressionBody,String) not implemented for TableExpression of type " + queryExpr.getClass().getName());
            }
        }
        return resultColList;
    }

    public static Column getColumnForName(TableExpression tableExpr, String columnName) {
        if (tableExpr == null) {
            return null;
        }
        if (tableExpr instanceof TableInDatabase) {
            TableInDatabase tableInDB = (TableInDatabase)tableExpr;
            return TableHelper.getColumnForName(tableInDB, columnName);
        }
        if (tableExpr instanceof WithTableReference) {
            // empty if block
        }
        return null;
    }

    public static Column getColumnForName(TableInDatabase tableInDB, String columnName) {
        Column columnFound = null;
        Table table = tableInDB.getDatabaseTable();
        if (table != null && columnName != null) {
            EList columnList = table.getColumns();
            Iterator columnIter = columnList.iterator();
            while (columnIter.hasNext() && columnFound == null) {
                Column column = (Column)columnIter.next();
                if (!columnName.equals(column.getName()) && (columnName.startsWith(DELIMITED_IDENTIFIER_QUOTE) || !columnName.equalsIgnoreCase(column.getName()))) continue;
                columnFound = column;
                break;
            }
        }
        return columnFound;
    }

    public static Column getColumnForName(WithTableReference withTableRef, String columnName) {
        Column columnFound = null;
        if (withTableRef != null && columnName != null && withTableRef.getWithTableSpecification() != null) {
            WithTableSpecification withTable = withTableRef.getWithTableSpecification();
            StatementHelper.logError(TableHelper.class.getName() + "#getColumnForName(WithTableReference,String) is not implemented.");
        }
        return columnFound;
    }

    public static Column getColumnForName(TableReference tableRef, String columnName) {
        if (tableRef != null) {
            if (tableRef instanceof TableExpression) {
                TableExpression tableExpr = (TableExpression)tableRef;
                return TableHelper.getColumnForName(tableExpr, columnName);
            }
            if (tableRef instanceof TableNested) {
                TableNested nest = (TableNested)tableRef;
                return TableHelper.getColumnForName(nest.getNestedTableRef(), columnName);
            }
            if (tableRef instanceof TableJoined) {
                TableJoined tableJoined = (TableJoined)tableRef;
                TableReference leftTableRef = tableJoined.getTableRefLeft();
                TableReference rightTableRef = tableJoined.getTableRefRight();
                Column leftColumn = TableHelper.getColumnForName(leftTableRef, columnName);
                Column rightColumn = TableHelper.getColumnForName(rightTableRef, columnName);
                if (leftColumn != null) {
                    return leftColumn;
                }
                return rightColumn;
            }
        }
        return null;
    }

    public static Column getColumnForColumnExpression(TableExpression tableExpr, ValueExpressionColumn colExpr) {
        if (colExpr != null) {
            String columnName = colExpr.getName();
            return TableHelper.getColumnForName(tableExpr, columnName);
        }
        return null;
    }

    public static TableInDatabase createTableExpressionForTable(Table table) {
        TableInDatabase tableInDB = null;
        if (table != null) {
            SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
            tableInDB = factory.createTableInDatabase();
            tableInDB.setDatabaseTable(table);
            String tableName = table.getName();
            tableInDB.setName(tableName);
            EList rdbColumnList = tableInDB.getColumnList();
            EList cList = table.getColumns();
            Iterator columnItr = cList.iterator();
            while (columnItr.hasNext()) {
                Column col = (Column)columnItr.next();
                ValueExpressionColumn valueExprColumn = factory.createValueExpressionColumn();
                valueExprColumn.setName(col.getName());
                valueExprColumn.setDataType(ValueExpressionHelper.copyDataType(col.getDataType()));
                rdbColumnList.add(valueExprColumn);
            }
        }
        return tableInDB;
    }

    public static void populateTableExpressionColumns(TableInDatabase tableInDB, Table databaseTable) {
        if (databaseTable == null || tableInDB == null) {
            return;
        }
        EList rdbColumnList = databaseTable.getColumns();
        Iterator colItr = rdbColumnList.iterator();
        EList columnList = tableInDB.getColumnList();
        columnList.clear();
        SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
        while (colItr.hasNext()) {
            Column col = (Column)colItr.next();
            ValueExpressionColumn valueExprColumn = null;
            valueExprColumn = factory.createValueExpressionColumn();
            valueExprColumn.setName(col.getName());
            DataType type = ValueExpressionHelper.copyDataType(col.getDataType());
            valueExprColumn.setDataType(type);
            valueExprColumn.setTableInDatabase(tableInDB);
            columnList.add(valueExprColumn);
        }
    }

    public static boolean isPrimaryKey(Column column) {
        boolean retValue = false;
        Table table = column.getTable();
        List primarykeyCols = TableHelper.getPrimaryKeyColumns(table);
        Iterator pkcolItr = primarykeyCols.iterator();
        while (pkcolItr.hasNext() && !retValue) {
            if (column != (Column)pkcolItr.next()) continue;
            retValue = true;
        }
        return retValue;
    }

    public static boolean isPrimaryKey(ValueExpressionColumn colExpr) {
        Column column;
        boolean retValue = false;
        if (colExpr != null && colExpr.getTableExpr() instanceof TableInDatabase && (column = TableHelper.getColumnForColumnExpression(colExpr.getTableExpr(), colExpr)) != null) {
            retValue = TableHelper.isPrimaryKey(column);
        }
        return retValue;
    }

    public static ValueExpressionColumn getColumnExpressionForColumn(TableExpression tableExpr, Column column) {
        ValueExpressionColumn colExpr = null;
        if (column != null && tableExpr != null) {
            String colName = column.getName();
            Iterator exprListItr = tableExpr.getColumnList().iterator();
            boolean found = false;
            while (exprListItr.hasNext() && !found) {
                ValueExpressionColumn tempExpr = (ValueExpressionColumn)exprListItr.next();
                if (!tempExpr.getName().equals(colName)) continue;
                colExpr = tempExpr;
                found = true;
            }
        }
        return colExpr;
    }

    public static List getPrimaryKeyColumns(Table table) {
        ArrayList primarykeyCols = new ArrayList();
        if (table instanceof BaseTable) {
            EList list = ((BaseTable)table).getConstraints();
            Iterator conItr = list.iterator();
            while (conItr.hasNext()) {
                Constraint con = (Constraint)conItr.next();
                if (!(con instanceof PrimaryKey)) continue;
                primarykeyCols.addAll(((PrimaryKey)con).getMembers());
            }
        }
        return primarykeyCols;
    }

    public static boolean isForeignKey(Column column) {
        boolean retValue = false;
        Table table = column.getTable();
        List fkCols = TableHelper.getForeignKeyColumns(table);
        Iterator fkcolItr = fkCols.iterator();
        while (fkcolItr.hasNext() && !retValue) {
            if (column != (Column)fkcolItr.next()) continue;
            retValue = true;
        }
        return retValue;
    }

    public static boolean isForeignKey(ValueExpressionColumn colExpr) {
        Column column;
        boolean retValue = false;
        if (colExpr != null && colExpr.getTableExpr() instanceof TableInDatabase && (column = TableHelper.getColumnForColumnExpression(colExpr.getTableExpr(), colExpr)) != null) {
            retValue = TableHelper.isForeignKey(column);
        }
        return retValue;
    }

    public static List getForeignKeyColumns(Table table) {
        ArrayList fkCols = new ArrayList();
        if (table instanceof BaseTable) {
            EList list = ((BaseTable)table).getConstraints();
            Iterator conItr = list.iterator();
            while (conItr.hasNext()) {
                Constraint con = (Constraint)conItr.next();
                if (!(con instanceof ForeignKey)) continue;
                fkCols.addAll(((ForeignKey)con).getMembers());
            }
        }
        return fkCols;
    }

    public static String getExposedTableName(TableExpression tableExpr) {
        String tablename = null;
        if (tableExpr != null) {
            tablename = tableExpr.getTableCorrelation() != null ? tableExpr.getTableCorrelation().getName() : tableExpr.getName();
        }
        return tablename;
    }

    public static String getFullTableName(Table table) {
        String tablename = table.getName();
        if (table.getSchema() != null) {
            tablename = table.getSchema().getName() + "." + tablename;
        }
        return tablename;
    }

    public static Table getTableForTableExpression(TableExpression tableExpr) {
        Table table = null;
        if (tableExpr != null && tableExpr instanceof TableInDatabase) {
            TableInDatabase tableInDB = (TableInDatabase)tableExpr;
            table = tableInDB.getDatabaseTable();
        }
        return table;
    }

    public static TableExpression getTableExpressionForNamedColumn(String aTableName, String aColName, List aTableExprList) {
        TableExpression tableExpr = null;
        Column rdbColumn = null;
        boolean foundIt = false;
        Iterator tableExprListIter = aTableExprList.iterator();
        while (tableExprListIter.hasNext() && !foundIt) {
            TableInDatabase dbTable;
            tableExpr = (TableExpression)tableExprListIter.next();
            if (aTableName != null && aTableName.length() > 0) {
                String tableExprName = tableExpr.getName();
                String tableExprCorrName = null;
                if (tableExpr.getTableCorrelation() != null) {
                    tableExprCorrName = tableExpr.getTableCorrelation().getName();
                }
                if (!aTableName.equals(tableExprName) && !aTableName.equals(tableExprCorrName)) continue;
                foundIt = true;
                continue;
            }
            if (!(tableExpr instanceof TableInDatabase) || (rdbColumn = TableHelper.getColumnForName(dbTable = (TableInDatabase)tableExpr, aColName)) == null) continue;
            foundIt = true;
        }
        if (!foundIt) {
            tableExpr = null;
        }
        return tableExpr;
    }

    public static TableExpression getTableExpressionFromTableExprList(String aTableName, List aTableExprList) {
        TableExpression retTableExpr = null;
        boolean foundIt = false;
        Iterator tableExprListIter = aTableExprList.iterator();
        while (tableExprListIter.hasNext() && !foundIt) {
            TableExpression tableExpr = null;
            tableExpr = (TableExpression)tableExprListIter.next();
            if (aTableName == null || aTableName.length() <= 0) continue;
            String tableExprName = tableExpr.getName();
            String tableExprCorrName = null;
            if (tableExpr.getTableCorrelation() != null) {
                tableExprCorrName = tableExpr.getTableCorrelation().getName();
            }
            if (!aTableName.equals(tableExprName) && !aTableName.equals(tableExprCorrName)) continue;
            retTableExpr = tableExpr;
            foundIt = true;
        }
        return retTableExpr;
    }

    public static Set findColumnReferencesInGroupingExpression(GroupingExpression groupingExpr) {
        if (groupingExpr == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(groupingExpr.getValueExpr()));
        return columnSet;
    }

    public static Set findColumnReferencesInQueryResultSpecificationList(List queryResultSpecList) {
        if (queryResultSpecList == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        Iterator it = queryResultSpecList.iterator();
        while (it.hasNext()) {
            QueryResultSpecification resultSpec = (QueryResultSpecification)it.next();
            columnSet.addAll(TableHelper.findColumnReferencesInQueryResultSpecification(resultSpec));
        }
        return columnSet;
    }

    public static Set findColumnReferencesInQueryResultSpecification(QueryResultSpecification queryResult) {
        if (queryResult == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        if (queryResult instanceof ResultColumn) {
            ResultColumn resultCol = (ResultColumn)queryResult;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(resultCol.getValueExpr()));
        }
        return columnSet;
    }

    public static Set findColumnReferencesInOrderBySpecificationList(List orderBySpecList) {
        if (orderBySpecList == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        Iterator orderIt = orderBySpecList.iterator();
        while (orderIt.hasNext()) {
            OrderBySpecification orderBySpec = (OrderBySpecification)orderIt.next();
            columnSet.addAll(TableHelper.findColumnReferencesInOrderBySpecification(orderBySpec));
        }
        return columnSet;
    }

    public static Set findColumnReferencesInOrderBySpecification(OrderBySpecification orderBySpec) {
        if (orderBySpec == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        if (orderBySpec instanceof OrderByValueExpression) {
            OrderByValueExpression orderByValue = (OrderByValueExpression)orderBySpec;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(orderByValue.getValueExpr()));
        }
        return columnSet;
    }

    public static Set findColumnReferencesInUpdateSourceExprList(UpdateSourceExprList updateSourceExprList) {
        if (updateSourceExprList == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        EList exprList = updateSourceExprList.getValueExprList();
        columnSet.addAll(TableHelper.findColumnReferencesInValueExpressionList((List)exprList));
        return columnSet;
    }

    public static Set findColumnReferencesInValuesRow(ValuesRow valuesRow) {
        if (valuesRow == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        columnSet.addAll(TableHelper.findColumnReferencesInValueExpressionList((List)valuesRow.getExprList()));
        return columnSet;
    }

    public static Set findColumnReferencesInSearchCondition(QuerySearchCondition searchCond) {
        if (searchCond == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        if (searchCond instanceof Predicate) {
            Predicate pred = (Predicate)searchCond;
            return TableHelper.findColumnReferencesInPredicate(pred);
        }
        if (searchCond instanceof SearchConditionCombined) {
            SearchConditionCombined combined = (SearchConditionCombined)searchCond;
            columnSet.addAll(TableHelper.findColumnReferencesInSearchCondition(combined.getLeftCondition()));
            columnSet.addAll(TableHelper.findColumnReferencesInSearchCondition(combined.getRightCondition()));
            return columnSet;
        }
        if (searchCond instanceof SearchConditionNested) {
            SearchConditionNested nest = (SearchConditionNested)searchCond;
            return TableHelper.findColumnReferencesInSearchCondition(nest.getNestedCondition());
        }
        return columnSet;
    }

    public static Set findColumnReferencesInPredicate(Predicate predicate) {
        if (predicate == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        if (predicate instanceof PredicateBasic) {
            PredicateBasic basic = (PredicateBasic)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(basic.getRightValueExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(basic.getLeftValueExpr()));
            return columnSet;
        }
        if (predicate instanceof PredicateBetween) {
            PredicateBetween between = (PredicateBetween)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(between.getRightValueExpr1()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(between.getRightValueExpr2()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(between.getLeftValueExpr()));
            return columnSet;
        }
        if (predicate instanceof PredicateExists) {
            PredicateExists exists = (PredicateExists)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionBody(exists.getQueryExpr()));
            return columnSet;
        }
        if (predicate instanceof PredicateInValueList) {
            PredicateInValueList inValueList = (PredicateInValueList)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(inValueList.getValueExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpressionList((List)inValueList.getValueExprList()));
            return columnSet;
        }
        if (predicate instanceof PredicateInValueRowSelect) {
            PredicateInValueRowSelect inRowSelect = (PredicateInValueRowSelect)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionRoot(inRowSelect.getQueryExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpressionList((List)inRowSelect.getValueExprList()));
            return columnSet;
        }
        if (predicate instanceof PredicateInValueSelect) {
            PredicateInValueSelect inValueSelect = (PredicateInValueSelect)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionRoot(inValueSelect.getQueryExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(inValueSelect.getValueExpr()));
            return columnSet;
        }
        if (predicate instanceof PredicateIsNull) {
            PredicateIsNull isNull = (PredicateIsNull)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(isNull.getValueExpr()));
            return columnSet;
        }
        if (predicate instanceof PredicateLike) {
            PredicateLike like = (PredicateLike)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(like.getMatchingValueExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(like.getPatternValueExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(like.getEscapeValueExpr()));
            return columnSet;
        }
        if (predicate instanceof PredicateQuantifiedRowSelect) {
            PredicateQuantifiedRowSelect rowSelect = (PredicateQuantifiedRowSelect)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionRoot(rowSelect.getQueryExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpressionList((List)rowSelect.getValueExprList()));
            return columnSet;
        }
        if (predicate instanceof PredicateQuantifiedValueSelect) {
            PredicateQuantifiedValueSelect inValueSelect = (PredicateQuantifiedValueSelect)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionRoot(inValueSelect.getQueryExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(inValueSelect.getValueExpr()));
            return columnSet;
        }
        return columnSet;
    }

    public static Set findColumnReferencesInValueExpression(QueryValueExpression valueExpr) {
        if (valueExpr == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<QueryValueExpression> columnSet = new HashSet<QueryValueExpression>();
        if (valueExpr instanceof ValueExpressionColumn) {
            columnSet.add(valueExpr);
            return columnSet;
        }
        if (valueExpr instanceof ValueExpressionSimple) {
            return Collections.EMPTY_SET;
        }
        if (valueExpr instanceof ValueExpressionCombined) {
            ValueExpressionCombined combi = (ValueExpressionCombined)valueExpr;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(combi.getRightValueExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(combi.getLeftValueExpr()));
            return columnSet;
        }
        if (valueExpr instanceof ValueExpressionDefaultValue || valueExpr instanceof ValueExpressionNullValue || valueExpr instanceof ValueExpressionVariable) {
            return Collections.EMPTY_SET;
        }
        if (valueExpr instanceof ValueExpressionNested) {
            ValueExpressionNested nest = (ValueExpressionNested)valueExpr;
            return TableHelper.findColumnReferencesInValueExpression(nest.getNestedValueExpr());
        }
        if (valueExpr instanceof ValueExpressionCaseSearch) {
            ValueExpressionCaseSearch caseSearch = (ValueExpressionCaseSearch)valueExpr;
            Iterator searchContentList = caseSearch.getSearchContentList().iterator();
            while (searchContentList.hasNext()) {
                ValueExpressionCaseSearchContent searchContent = (ValueExpressionCaseSearchContent)searchContentList.next();
                columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(searchContent.getValueExpr()));
                columnSet.addAll(TableHelper.findColumnReferencesInSearchCondition(searchContent.getSearchCondition()));
            }
            ValueExpressionCaseElse caseElse = caseSearch.getCaseElse();
            if (caseElse != null) {
                columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(caseElse.getValueExpr()));
            }
            return columnSet;
        }
        if (valueExpr instanceof ValueExpressionCaseSimple) {
            ValueExpressionCaseSimple caseSimple = (ValueExpressionCaseSimple)valueExpr;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(caseSimple.getValueExpr()));
            Iterator simpleContentList = caseSimple.getContentList().iterator();
            while (simpleContentList.hasNext()) {
                ValueExpressionCaseSimpleContent simpleContent = (ValueExpressionCaseSimpleContent)simpleContentList.next();
                columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(simpleContent.getResultValueExpr()));
                columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(simpleContent.getWhenValueExpr()));
            }
            ValueExpressionCaseElse caseElse = caseSimple.getCaseElse();
            if (caseElse != null) {
                columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(caseElse.getValueExpr()));
            }
            return columnSet;
        }
        if (valueExpr instanceof ValueExpressionCast) {
            ValueExpressionCast cast = (ValueExpressionCast)valueExpr;
            return TableHelper.findColumnReferencesInValueExpression(cast.getValueExpr());
        }
        if (valueExpr instanceof ValueExpressionFunction) {
            ValueExpressionFunction func = (ValueExpressionFunction)valueExpr;
            return TableHelper.findColumnReferencesInValueExpressionList((List)func.getParameterList());
        }
        if (valueExpr instanceof ValueExpressionLabeledDuration) {
            ValueExpressionLabeledDuration dur = (ValueExpressionLabeledDuration)valueExpr;
            return TableHelper.findColumnReferencesInValueExpression(dur.getValueExpr());
        }
        if (valueExpr instanceof ValueExpressionScalarSelect) {
            // empty if block
        }
        return columnSet;
    }

    public static Set findColumnReferencesInValueExpressionList(List valueExprList) {
        HashSet columnSet = null;
        if (valueExprList != null) {
            columnSet = new HashSet();
            Iterator valIt = valueExprList.iterator();
            while (valIt.hasNext()) {
                QueryValueExpression valueExpr = (QueryValueExpression)valIt.next();
                columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(valueExpr));
            }
        }
        return columnSet;
    }

    public static Set findColumnReferencesInGroupingSpecificationList(List groupingSpecList) {
        HashSet columnSet = new HashSet();
        if (groupingSpecList != null) {
            Iterator it = groupingSpecList.iterator();
            while (it.hasNext()) {
                GroupingSpecification groupingSpec = (GroupingSpecification)it.next();
                columnSet.addAll(TableHelper.findColumnReferencesInGroupingSpecification(groupingSpec));
            }
        }
        return columnSet;
    }

    public static Set findColumnReferencesInGroupingSpecification(GroupingSpecification groupingSpec) {
        HashSet columnSet = new HashSet();
        if (groupingSpec != null) {
            if (groupingSpec instanceof GroupingExpression) {
                GroupingExpression groupingExpr = (GroupingExpression)groupingSpec;
                columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(groupingExpr.getValueExpr()));
            } else if (groupingSpec instanceof SuperGroup) {
                Class refWanted = ValueExpressionColumn.class;
                Class[] refsToCheck = new Class[]{GroupingSpecification.class, SuperGroupElement.class};
                Set groupColumns = StatementHelper.getReferencesViaSpecificReferencePaths((EObject)groupingSpec, refWanted, refsToCheck);
                columnSet.addAll(groupColumns);
            } else if (groupingSpec instanceof GroupingSets) {
                Class refWanted = ValueExpressionColumn.class;
                Class[] refsToCheck = new Class[]{GroupingSpecification.class, GroupingSetsElement.class, SuperGroupElement.class};
                Set groupColumns = StatementHelper.getReferencesViaSpecificReferencePaths((EObject)groupingSpec, refWanted, refsToCheck);
                columnSet.addAll(groupColumns);
            } else {
                throw new UnsupportedOperationException(TableHelper.class.getName() + "#findColumnReferencesInGroupingSpecification() not implemented for " + groupingSpec.getClass().getName() + ".");
            }
        }
        return columnSet;
    }

    public static Set findColumnReferencesInQueryExpressionBody(QueryExpressionBody queryExprBody) {
        if (queryExprBody == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        if (queryExprBody instanceof QuerySelect) {
            QuerySelect select = (QuerySelect)queryExprBody;
            columnSet.addAll(TableHelper.findColumnReferencesInQueryResultSpecificationList((List)select.getSelectClause()));
            columnSet.addAll(TableHelper.findColumnReferencesInSearchCondition(select.getWhereClause()));
            columnSet.addAll(TableHelper.findColumnReferencesInSearchCondition(select.getHavingClause()));
            columnSet.addAll(TableHelper.findColumnReferencesInGroupingSpecificationList((List)select.getGroupByClause()));
        } else if (queryExprBody instanceof QueryCombined) {
            QueryCombined combined = (QueryCombined)queryExprBody;
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionBody(combined.getLeftQuery()));
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionBody(combined.getRightQuery()));
        } else if (!(queryExprBody instanceof QueryValues)) {
            throw new UnsupportedOperationException(TableHelper.class.getName() + "#findColumnReferencesInQueryExpressionBody( (" + queryExprBody.getClass().getName() + ") QueryExpressionBody ) not implemented.");
        }
        return columnSet;
    }

    public static Set findColumnReferencesInQueryExpressionRoot(QueryExpressionRoot queryExprRoot) {
        if (queryExprRoot == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionBody(queryExprRoot.getQuery()));
        return columnSet;
    }

    public static Set findColumnReferencesInQuerySelectStatement(QuerySelectStatement querySelect) {
        if (querySelect == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionRoot(querySelect.getQueryExpr()));
        EList orderBySpecList = querySelect.getOrderByClause();
        columnSet.addAll(TableHelper.findColumnReferencesInOrderBySpecificationList((List)orderBySpecList));
        return columnSet;
    }

    public static Set findColumnReferencesInQueryUpdateStatement(QueryUpdateStatement updateStmt) {
        if (updateStmt == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        columnSet.addAll(TableHelper.findColumnReferencesInUpdateAssignmentExprList((List)updateStmt.getAssignmentClause()));
        columnSet.addAll(TableHelper.findColumnReferencesInSearchCondition(updateStmt.getWhereClause()));
        if (updateStmt.getWhereCurrentOfClause() != null) {
            StatementHelper.logError(TableHelper.class.getName() + " implement findColumnReferencesInQueryUpdateStatement(QueryUpdateStatement)" + " for " + CursorReference.class.getName());
        }
        return columnSet;
    }

    public static Set findColumnReferencesInUpdateAssignmentExprList(List updateAssignmentExprList) {
        HashSet columnSet = new HashSet();
        Iterator assignIt = updateAssignmentExprList.iterator();
        while (assignIt.hasNext()) {
            UpdateAssignmentExpression upAssEx = (UpdateAssignmentExpression)assignIt.next();
            columnSet.addAll(TableHelper.findColumnReferencesInUpdateAssignmentExpr(upAssEx));
        }
        return columnSet;
    }

    public static Set findColumnReferencesInUpdateAssignmentExpr(UpdateAssignmentExpression updateAssignmentExpr) {
        HashSet columnSet = new HashSet();
        columnSet.addAll(updateAssignmentExpr.getTargetColumnList());
        if (updateAssignmentExpr.getUpdateSource() instanceof UpdateSourceExprList) {
            UpdateSourceExprList updateSrcExprList = (UpdateSourceExprList)updateAssignmentExpr.getUpdateSource();
            columnSet.addAll(TableHelper.findColumnReferencesInUpdateSourceExprList(updateSrcExprList));
        }
        return columnSet;
    }

    public static void resolveTableReferencesInSearchCondition(SearchCondition searchCondition, List tableExpressionList) throws ColumnInTwoTablesException {
        throw new UnsupportedOperationException(TableHelper.class.getName() + "# resolveTableReferencesInSearchCondition(SearchCondition searchCondition, List tableExpressionList) not implemented.");
    }

    public static String createFromClauseForStatement(QueryStatement stmt) {
        StringBuffer sqlBuf = new StringBuffer();
        List tableRefList = StatementHelper.getTablesForStatement(stmt);
        Iterator tableIt = tableRefList.iterator();
        while (tableIt.hasNext()) {
            TableExpression tblExpr = (TableExpression)tableIt.next();
            if (sqlBuf.length() > 0) {
                sqlBuf.append(", ");
            }
            String tblExprSQL = tblExpr.getSQL();
            sqlBuf.append(tblExprSQL);
        }
        if (sqlBuf.length() > 0) {
            sqlBuf.insert(0, "From ");
        }
        return sqlBuf.toString();
    }

    public static String createFromClauseForStatement(SQLQueryObject stmt) {
        String retVal = "";
        if (stmt instanceof QueryStatement) {
            retVal = TableHelper.createFromClauseForStatement((QueryStatement)stmt);
        } else if (stmt instanceof QuerySelect) {
            StringBuffer sqlBuf = new StringBuffer();
            List tableRefList = StatementHelper.getTablesForStatement(stmt);
            Iterator tableIt = tableRefList.iterator();
            while (tableIt.hasNext()) {
                TableExpression tblExpr = (TableExpression)tableIt.next();
                if (sqlBuf.length() > 0) {
                    sqlBuf.append(", ");
                }
                String tblExprSQL = tblExpr.getSQL();
                sqlBuf.append(tblExprSQL);
            }
            if (sqlBuf.length() > 0) {
                sqlBuf.insert(0, "FROM ");
            }
            retVal = sqlBuf.toString();
        }
        return retVal;
    }

    public static TableExpression findTableExpressionInTableExpressionList(String schemaName, String tableName, List tableExprList) {
        TableExpression foundTableExpr = null;
        SQLQuerySourceFormat sourceFormat = null;
        if (tableName != null && tableExprList != null) {
            Iterator tableIt = tableExprList.iterator();
            while (tableIt.hasNext()) {
                TableExpression tableExpr = (TableExpression)tableIt.next();
                if (sourceFormat == null && tableExpr.getSourceInfo() != null && tableExpr.getSourceInfo().getSqlFormat() != null) {
                    sourceFormat = tableExpr.getSourceInfo().getSqlFormat();
                }
                if (!tableName.equals(tableExpr.getName())) continue;
                String tableExprSchemaName = TableHelper.getSchemaNameForTableExpression(tableExpr);
                if (schemaName != null && !schemaName.equals(tableExprSchemaName)) continue;
                foundTableExpr = tableExpr;
                break;
            }
        }
        return foundTableExpr;
    }

    private static TableExpression findTableExpressionInTableExpressionList(String schemaName, String tableName, List tableExprList, String defaultSchemaName) {
        TableExpression foundTableExpr = null;
        SQLQuerySourceFormat sourceFormat = null;
        if (tableName != null && tableExprList != null) {
            Iterator tableIt = tableExprList.iterator();
            while (tableIt.hasNext()) {
                String tableSchema;
                TableExpression tableExpr = (TableExpression)tableIt.next();
                String tableExprName = tableExpr.getName();
                if (tableExpr.getSourceInfo() != null && tableExpr.getSourceInfo().getSqlFormat() != null && (sourceFormat = tableExpr.getSourceInfo().getSqlFormat()).getOmitSchema() != null && sourceFormat.getOmitSchema().length() > 0) {
                    defaultSchemaName = sourceFormat.getOmitSchema();
                }
                if (!tableName.equals(tableExprName)) continue;
                if (schemaName != null) {
                    String tableExprSchemaName = TableHelper.getSchemaName(tableExpr);
                    if (tableExprSchemaName == null) {
                        tableExprSchemaName = defaultSchemaName;
                    }
                    if (!schemaName.equals(tableExprSchemaName) || tableExpr.getTableCorrelation() != null) continue;
                    foundTableExpr = tableExpr;
                    break;
                }
                if (tableExpr.getTableCorrelation() != null || (tableSchema = TableHelper.getSchemaName(tableExpr)) != null && !tableSchema.equals(defaultSchemaName)) continue;
                foundTableExpr = tableExpr;
                break;
            }
        }
        return foundTableExpr;
    }

    public static TableExpression findTableExpressionsByNameOrAlias(String tableNameOrAlias, List tableExprList, String defaultSchemaName) {
        TableExpression tableExprFound = null;
        SQLQuerySourceFormat sourceFormat = null;
        ArrayList<TableExpression> matchingSchemaQualifiedTables = new ArrayList<TableExpression>();
        if (tableNameOrAlias != null && tableExprList != null) {
            Iterator tableIt = tableExprList.iterator();
            while (tableIt.hasNext()) {
                TableExpression tableExpr = (TableExpression)tableIt.next();
                TableCorrelation tableCorr = tableExpr.getTableCorrelation();
                String tableName = tableExpr.getName();
                String tableAlias = null;
                if (tableCorr != null) {
                    tableAlias = tableCorr.getName();
                }
                if (tableExpr.getSourceInfo() != null && tableExpr.getSourceInfo().getSqlFormat() != null && (sourceFormat = tableExpr.getSourceInfo().getSqlFormat()).getOmitSchema() != null && sourceFormat.getOmitSchema().length() > 0) {
                    defaultSchemaName = sourceFormat.getOmitSchema();
                }
                boolean equalNames = tableNameOrAlias.equals(tableName);
                boolean equalAlias = tableNameOrAlias.equals(tableAlias);
                if (equalAlias) {
                    tableExprFound = tableExpr;
                    break;
                }
                if (!equalNames || tableAlias != null) continue;
                String tableSchema = TableHelper.getSchemaName(tableExpr);
                if (tableSchema == null || tableSchema.equals(defaultSchemaName)) {
                    tableExprFound = tableExpr;
                    continue;
                }
                matchingSchemaQualifiedTables.add(tableExpr);
            }
        }
        if (tableExprFound == null && matchingSchemaQualifiedTables.size() == 1) {
            tableExprFound = (TableExpression)matchingSchemaQualifiedTables.get(0);
        }
        return tableExprFound;
    }

    public static String getSchemaNameForTableExpression(TableExpression tableExpr) {
        Schema schema;
        TableInDatabase tableInDB;
        Table table;
        String schemaName = null;
        if (tableExpr instanceof TableInDatabase && (table = (tableInDB = (TableInDatabase)tableExpr).getDatabaseTable()) != null && (schema = table.getSchema()) != null) {
            schemaName = schema.getName();
        }
        return schemaName;
    }

    public static List getTableExpressionsInTableReferenceList(List tableReferenceList) {
        ArrayList tableExprList = new ArrayList();
        Iterator tableRefIt = tableReferenceList.iterator();
        while (tableRefIt.hasNext()) {
            TableReference tableRef = (TableReference)tableRefIt.next();
            tableExprList.addAll(TableHelper.getTableExpressionsInTableReference(tableRef));
        }
        return tableExprList;
    }

    public static List getTableInDatabaseInTableReferenceList(List tableReferenceList) {
        ArrayList tableExprList = new ArrayList();
        Iterator tableRefIt = tableReferenceList.iterator();
        while (tableRefIt.hasNext()) {
            TableReference tableRef = (TableReference)tableRefIt.next();
            tableExprList.addAll(TableHelper.getTableExpressionsInTableReference(tableRef));
        }
        Iterator tableExprIt = tableExprList.iterator();
        while (tableExprIt.hasNext()) {
            if (tableExprIt.next() instanceof TableInDatabase) continue;
            tableExprIt.remove();
        }
        return tableExprList;
    }

    public static List getTableExpressionsInTableReference(TableReference tableRef) {
        ArrayList<TableExpression> tableExprList = new ArrayList<TableExpression>();
        if (tableRef instanceof TableExpression) {
            TableExpression tableExpr = (TableExpression)tableRef;
            tableExprList.add(tableExpr);
        }
        if (tableRef instanceof TableNested) {
            TableNested nest = (TableNested)tableRef;
            tableExprList.addAll(TableHelper.getTableExpressionsInTableReference(nest.getNestedTableRef()));
        }
        if (tableRef instanceof TableJoined) {
            TableJoined join = (TableJoined)tableRef;
            tableExprList.addAll(TableHelper.getTableExpressionsInTableReference(join.getTableRefLeft()));
            tableExprList.addAll(TableHelper.getTableExpressionsInTableReference(join.getTableRefRight()));
        }
        return tableExprList;
    }

    public static void removeColumnExpressionFromTableIfNotReferenced(ValueExpressionColumn col) {
        boolean isReferenced = false;
        if (col != null && col.getTableExpr() != null) {
            Iterator refIt = col.eClass().getEAllReferences().iterator();
            while (refIt.hasNext()) {
                EReference ref = (EReference)refIt.next();
                if (ref.isMany()) {
                    EList refList = (EList)col.eGet((EStructuralFeature)ref);
                    if (refList.size() <= 0) continue;
                    isReferenced = true;
                    continue;
                }
                EObject reference = (EObject)col.eGet((EStructuralFeature)ref);
                if (reference == null || reference == col.getTableExpr() || reference == col.getTableInDatabase()) continue;
                isReferenced = true;
            }
            if (!isReferenced) {
                col.setTableExpr(null);
            }
        }
    }

    public static void removeColumnExpressionFromTableIfDuplicate(ValueExpressionColumn columnExpr) {
        ValueExpressionColumn sameNameColExpr = null;
        if (columnExpr != null && columnExpr.getName() != null && columnExpr.getTableExpr() != null) {
            String columnName = columnExpr.getName();
            EList colList = columnExpr.getTableExpr().getValueExprColumns();
            Iterator colIt = colList.iterator();
            while (colIt.hasNext()) {
                ValueExpressionColumn otherColumnExpr = (ValueExpressionColumn)colIt.next();
                if (otherColumnExpr == columnExpr || !columnName.equals(otherColumnExpr.getName())) continue;
                sameNameColExpr = otherColumnExpr;
                break;
            }
        }
        if (sameNameColExpr != null) {
            columnExpr.setTableExpr(null);
        }
    }

    public static void resolveColumnTableReferences(Collection unresolvedColumns, List aTableRefList) {
        if (unresolvedColumns == null) {
            return;
        }
        List tableExprList = TableHelper.getTableExpressionsInTableReferenceList(aTableRefList);
        ValueExpressionColumn col = null;
        String colName = null;
        TableExpression colTblRef = null;
        TableCorrelation colTblRefCorr = null;
        String colTblRefSchemaName = null;
        String colQualifier = null;
        TableExpression refTableFound = null;
        Iterator colIt = unresolvedColumns.iterator();
        while (colIt.hasNext()) {
            col = (ValueExpressionColumn)colIt.next();
            colName = col.getName();
            colTblRef = col.getTableExpr();
            if (colTblRef == null) {
                refTableFound = tableExprList.size() == 1 ? (TableExpression)tableExprList.get(0) : TableHelper.findTableExpressionForColumnName(tableExprList, colName, true);
            } else if (StatementHelper.getQuerySelectForTableReference(colTblRef) != null) {
                refTableFound = colTblRef;
            } else {
                colQualifier = colTblRef.getName();
                colTblRefCorr = colTblRef.getTableCorrelation();
                if (colTblRefCorr != null) {
                    colQualifier = colTblRefCorr.getName();
                }
                refTableFound = (colTblRefSchemaName = TableHelper.getSchemaName(colTblRef)) != null ? TableHelper.findTableExpressionInTableExpressionList(colTblRefSchemaName, colTblRef.getName(), tableExprList, TableHelper.getDefaultSchemaName(col)) : TableHelper.findTableExpressionsByNameOrAlias(colQualifier, tableExprList, TableHelper.getDefaultSchemaName(col));
            }
            if (refTableFound == null) continue;
            ValueExpressionColumn corrExposedTableCol = TableHelper.getColumnExpressionForName(refTableFound, colName);
            if (corrExposedTableCol != null) {
                DataType dataType = corrExposedTableCol.getDataType();
                DataType colDataType = ValueExpressionHelper.copyDataType(dataType);
                if (colDataType != null) {
                    col.setDataType(colDataType);
                }
                if (corrExposedTableCol.getTableInDatabase() != null) {
                    col.setTableInDatabase(corrExposedTableCol.getTableInDatabase());
                }
            }
            col.setTableExpr(refTableFound);
            colIt.remove();
        }
    }

    private static TableExpression findTableExpressionForColumnName(List tableExprList, String columnName) {
        return TableHelper.findTableExpressionForColumnName(tableExprList, columnName, false);
    }

    private static TableExpression findTableExpressionForColumnName(List tableExprList, String columnName, boolean checkDisconnected) {
        TableExpression tableFound = null;
        ArrayList<TableExpression> tablesReferencedByColumn = null;
        if (checkDisconnected) {
            tablesReferencedByColumn = new ArrayList<TableExpression>();
        }
        Iterator it = tableExprList.iterator();
        while (it.hasNext()) {
            ValueExpressionColumn columnFound;
            TableExpression tableExpr = (TableExpression)it.next();
            if (checkDisconnected && TableHelper.isTableReferencedByColumnWithName(tableExpr, columnName)) {
                tablesReferencedByColumn.add(tableExpr);
            }
            if ((columnFound = TableHelper.getColumnExpressionForName(tableExpr, columnName)) == null) continue;
            if (tableFound == null) {
                tableFound = tableExpr;
                continue;
            }
            if (tableFound.getName() != null && tableFound.getName().equals(tableExpr.getName())) {
                tableFound = null;
                break;
            }
            String tableExprSchema = TableHelper.getSchemaName(tableExpr);
            String tableFoundSchema = TableHelper.getSchemaName(tableFound);
            String defaultSchema = TableHelper.getDefaultSchemaName(tableExpr);
            if (tableExprSchema == null) {
                tableExprSchema = defaultSchema;
            }
            if (tableFoundSchema == null) {
                tableFoundSchema = defaultSchema;
            }
            if (!TableHelper.equalIdentifiersOrNull(tableExprSchema, tableFoundSchema)) continue;
            tableFound = null;
            break;
        }
        if (tableFound == null && checkDisconnected && tablesReferencedByColumn != null && tablesReferencedByColumn.size() == 1) {
            tableFound = (TableExpression)tablesReferencedByColumn.get(0);
        }
        return tableFound;
    }

    protected static boolean equalIdentifiersOrNull(String ident1, String ident2) {
        if (ident1 == null && ident2 == null) {
            return true;
        }
        if (ident1 != null) {
            return ident1.equals(ident2);
        }
        return false;
    }

    private static String getDefaultSchemaName(SQLQueryObject queryObject) {
        String defaultSchema = null;
        if (queryObject.getSourceInfo() != null && queryObject.getSourceInfo().getSqlFormat() != null) {
            defaultSchema = queryObject.getSourceInfo().getSqlFormat().getOmitSchema();
        }
        return defaultSchema;
    }

    private static String getSchemaName(TableExpression tableExpr) {
        Schema schema;
        TableInDatabase tableInDB;
        Table dbTable;
        String schemaName = null;
        if (tableExpr instanceof TableInDatabase && (dbTable = (tableInDB = (TableInDatabase)tableExpr).getDatabaseTable()) != null && (schema = dbTable.getSchema()) != null) {
            schemaName = schema.getName();
        }
        return schemaName;
    }

    public static Schema getSchemaForTableInDatabase(TableInDatabase tableInDB) {
        Schema colTblRefSchema = null;
        if (tableInDB.getDatabaseTable() != null && tableInDB.getDatabaseTable().getSchema() != null) {
            colTblRefSchema = tableInDB.getDatabaseTable().getSchema();
        }
        return colTblRefSchema;
    }

    public static void resolveResultTableReferences(List resultTableList, List tableExprList) {
        if (resultTableList == null || resultTableList.isEmpty()) {
            return;
        }
        Iterator resultTableIt = resultTableList.iterator();
        while (resultTableIt.hasNext()) {
            String resultTableName;
            TableExpression tableExpr;
            ResultTableAllColumns resultTable = (ResultTableAllColumns)resultTableIt.next();
            if (resultTable == null || resultTable.getName() == null || (tableExpr = TableHelper.getTableExpressionFromTableExprList(resultTableName = resultTable.getName(), tableExprList)) == null) continue;
            resultTable.setTableExpr(tableExpr);
        }
    }

    public static void setTableAliasInTableExpression(TableExpression tableExpr, String alias) {
        if (alias.trim().length() > 0) {
            TableCorrelation tableCorr = SQLQueryModelFactory.eINSTANCE.createTableCorrelation();
            tableCorr.setName(alias.trim().toUpperCase());
            tableExpr.setTableCorrelation(tableCorr);
        }
    }

    private static List exposeResultColumnsOfQuerySelect(QuerySelect querySelect) {
        ArrayList<ValueExpressionColumn> exposedColumns = new ArrayList<ValueExpressionColumn>();
        if (querySelect == null) {
            return exposedColumns;
        }
        EList resultSpecList = querySelect.getSelectClause();
        if (resultSpecList == null || resultSpecList.isEmpty()) {
            Iterator it = querySelect.getFromClause().iterator();
            while (it.hasNext()) {
                TableReference tableRef = (TableReference)it.next();
                List tableRefCols = TableHelper.getEffectiveResultColumns(tableRef);
                exposedColumns.addAll(TableHelper.copyColumnExprList(tableRefCols));
            }
        } else {
            Iterator resultIt = resultSpecList.iterator();
            while (resultIt.hasNext()) {
                ValueExpressionColumn colExprsTableExposedColumn;
                ValueExpressionColumn colExpr;
                QueryResultSpecification resultSpec = (QueryResultSpecification)resultIt.next();
                if (resultSpec instanceof ResultTableAllColumns) {
                    ResultTableAllColumns tableAll = (ResultTableAllColumns)resultSpec;
                    TableExpression tableExpr = tableAll.getTableExpr();
                    if (tableExpr.getColumnList().isEmpty()) {
                        String tableNameOrAlias = tableAll.getName();
                        List tableExprList = TableHelper.getTableExpressionsInTableReferenceList((List)querySelect.getFromClause());
                        tableExpr = TableHelper.getTableExpressionFromTableExprList(tableNameOrAlias, tableExprList);
                    }
                    List tableExprCols = TableHelper.getEffectiveResultColumns(tableExpr);
                    exposedColumns.addAll(TableHelper.copyColumnExprList(tableExprCols));
                    continue;
                }
                if (!(resultSpec instanceof ResultColumn)) continue;
                ResultColumn resultCol = (ResultColumn)resultSpec;
                QueryValueExpression resultColExpr = resultCol.getValueExpr();
                String exposedColumnName = null;
                TableInDatabase derivedFromTableInDB = null;
                if (resultCol.getName() != null) {
                    exposedColumnName = resultCol.getName();
                } else if (resultColExpr != null && resultColExpr instanceof ValueExpressionColumn) {
                    colExpr = (ValueExpressionColumn)resultColExpr;
                    exposedColumnName = colExpr.getName();
                }
                if (resultColExpr != null && resultColExpr instanceof ValueExpressionColumn && (colExpr = (ValueExpressionColumn)resultColExpr).getDataType() == null) {
                    HashSet<ValueExpressionColumn> unresolvedColumns = new HashSet<ValueExpressionColumn>();
                    unresolvedColumns.add(colExpr);
                    EList tableRefList = querySelect.getFromClause();
                    TableHelper.resolveColumnTableReferences(unresolvedColumns, (List)tableRefList);
                }
                if (resultColExpr != null && resultColExpr instanceof ValueExpressionColumn && (colExprsTableExposedColumn = TableHelper.getColumnExpressionForName((colExpr = (ValueExpressionColumn)resultColExpr).getTableExpr(), colExpr.getName())) != null && colExprsTableExposedColumn.getTableInDatabase() != null) {
                    derivedFromTableInDB = colExprsTableExposedColumn.getTableInDatabase();
                }
                ValueExpressionColumn exposedColumn = TableHelper.getOrCreateColumnExpression(exposedColumnName, querySelect);
                if (resultColExpr != null) {
                    DataType resultColDataType = resultColExpr.getDataType();
                    if (resultColDataType == null) {
                        ValueExpressionHelper.resolveValueExpressionDatatypeRecursively(resultColExpr);
                        resultColDataType = resultColExpr.getDataType();
                    }
                    DataType exposedColumnDataType = ValueExpressionHelper.copyDataType(resultColDataType);
                    exposedColumn.setDataType(exposedColumnDataType);
                }
                exposedColumn.setTableInDatabase(derivedFromTableInDB);
                exposedColumns.add(exposedColumn);
            }
        }
        querySelect.getColumnList().clear();
        querySelect.getColumnList().addAll(exposedColumns);
        return exposedColumns;
    }

    private static List copyColumnExprList(List origColExprList) {
        ArrayList<ValueExpressionColumn> result = new ArrayList<ValueExpressionColumn>(origColExprList.size());
        Iterator it = origColExprList.iterator();
        while (it.hasNext()) {
            ValueExpressionColumn original = (ValueExpressionColumn)it.next();
            ValueExpressionColumn copy = (ValueExpressionColumn)EcoreUtil.copy((EObject)original);
            copy.setTableInDatabase(original.getTableInDatabase());
            result.add(copy);
        }
        return result;
    }

    private static List exposeResultColumnsOfQueryCombined(QueryCombined queryCombined) {
        ArrayList<ValueExpressionColumn> exposedColumns = new ArrayList<ValueExpressionColumn>();
        if (queryCombined == null) {
            return exposedColumns;
        }
        List exposedColListLeft = TableHelper.getEffectiveResultColumns(queryCombined.getLeftQuery());
        List exposedColListRight = TableHelper.getEffectiveResultColumns(queryCombined.getRightQuery());
        if (exposedColListLeft != null && exposedColListRight != null && exposedColListLeft.size() == exposedColListRight.size()) {
            for (int i = 0; i < exposedColListLeft.size(); ++i) {
                ValueExpressionColumn resultColExprLeft = (ValueExpressionColumn)exposedColListLeft.get(i);
                ValueExpressionColumn resultColExprRight = (ValueExpressionColumn)exposedColListRight.get(i);
                String leftName = resultColExprLeft.getName();
                String rightName = resultColExprRight.getName();
                String exposedColumnName = null;
                exposedColumnName = queryCombined.getLeftQuery() instanceof QueryValues && !(queryCombined.getRightQuery() instanceof QueryValues) ? rightName : leftName;
                ValueExpressionColumn exposedColumn = TableHelper.getOrCreateColumnExpression(exposedColumnName, queryCombined);
                DataType exposedColumnDataType = ValueExpressionHelper.resolveCombinedDataType(resultColExprLeft.getDataType(), resultColExprRight.getDataType());
                if (resultColExprLeft.getTableInDatabase() == resultColExprRight.getTableInDatabase()) {
                    exposedColumn.setTableInDatabase(resultColExprLeft.getTableInDatabase());
                }
                exposedColumns.add(exposedColumn);
            }
        }
        queryCombined.getColumnList().clear();
        queryCombined.getColumnList().addAll(exposedColumns);
        return exposedColumns;
    }

    private static List exposeResultColumnsOfQueryValues(QueryValues queryValues) {
        ArrayList<ValueExpressionColumn> exposedColumns = new ArrayList<ValueExpressionColumn>();
        if (queryValues == null || queryValues.getValuesRowList().isEmpty()) {
            return exposedColumns;
        }
        ValuesRow firstRow = (ValuesRow)queryValues.getValuesRowList().get(0);
        EList firstRowValues = firstRow.getExprList();
        for (int i = 0; i < firstRowValues.size(); ++i) {
            QueryValueExpression valueExpr = (QueryValueExpression)firstRowValues.get(i);
            ValueExpressionColumn exposedCol = StatementHelper.createColumnExpression(null);
            if (valueExpr.getDataType() == null) {
                ValueExpressionHelper.resolveValueExpressionDatatypeRecursively(valueExpr);
            }
            DataType exposedDataType = valueExpr.getDataType();
            exposedCol.setDataType(exposedDataType);
            exposedColumns.add(exposedCol);
        }
        queryValues.getColumnList().clear();
        queryValues.getColumnList().addAll(exposedColumns);
        return exposedColumns;
    }

    public static List exposeEffectiveResultColumns(QueryExpressionBody nestedQuery) {
        List exposedColumns = new ArrayList();
        if (nestedQuery instanceof QuerySelect) {
            QuerySelect select = (QuerySelect)nestedQuery;
            exposedColumns = TableHelper.exposeResultColumnsOfQuerySelect(select);
        } else if (nestedQuery instanceof QueryCombined) {
            QueryCombined combined = (QueryCombined)nestedQuery;
            exposedColumns = TableHelper.exposeResultColumnsOfQueryCombined(combined);
        } else if (nestedQuery instanceof QueryValues) {
            QueryValues values = (QueryValues)nestedQuery;
            exposedColumns = TableHelper.exposeResultColumnsOfQueryValues(values);
        }
        return exposedColumns;
    }

    public static List exposeEffectiveResultColumns(TableExpression tableExpr) {
        EList resultColExprList = new ArrayList();
        if (tableExpr == null) {
            return null;
        }
        if (tableExpr instanceof QueryExpressionBody) {
            QueryExpressionBody query = (QueryExpressionBody)tableExpr;
            resultColExprList = TableHelper.exposeEffectiveResultColumns(query);
        } else if (tableExpr instanceof TableInDatabase) {
            TableInDatabase tableInDB = (TableInDatabase)tableExpr;
            Table dbTable = tableInDB.getDatabaseTable();
            if (dbTable != null && dbTable.getColumns().size() != tableInDB.getColumnList().size()) {
                TableHelper.populateTableExpressionColumns(tableInDB, dbTable);
            }
            resultColExprList = tableInDB.getColumnList();
        } else if (tableExpr instanceof WithTableReference) {
            WithTableReference withTableRef = (WithTableReference)tableExpr;
            resultColExprList = TableHelper.exposeEffectiveResultColumns(withTableRef);
        } else if (tableExpr instanceof TableFunction) {
            StatementHelper.logError(TableHelper.class.getName() + ": implement exposeEffectiveResultColumns(TableExpression) for type" + TableFunction.class.getName());
        } else {
            StatementHelper.logError(TableHelper.class.getName() + ": implement exposeEffectiveResultColumns(TableExpression) for type" + tableExpr.getClass().getName());
        }
        return resultColExprList;
    }

    public static List getEffectiveResultColumns(TableReference tableRef) {
        List resultColExprList = new ArrayList();
        if (tableRef == null) {
            return null;
        }
        if (tableRef instanceof TableExpression) {
            TableExpression tableExpr = (TableExpression)tableRef;
            if (tableExpr.getColumnList() == null || tableExpr.getColumnList().isEmpty()) {
                TableHelper.exposeEffectiveResultColumns(tableExpr);
            }
            resultColExprList.addAll(tableExpr.getColumnList());
        } else if (tableRef instanceof TableJoined) {
            TableJoined tableJoin = (TableJoined)tableRef;
            List leftCols = TableHelper.getEffectiveResultColumns(tableJoin.getTableRefLeft());
            List rightCols = TableHelper.getEffectiveResultColumns(tableJoin.getTableRefRight());
            resultColExprList.addAll(leftCols);
            resultColExprList.addAll(rightCols);
        } else if (tableRef instanceof TableNested) {
            TableNested tableNest = (TableNested)tableRef;
            resultColExprList = TableHelper.getEffectiveResultColumns(tableNest.getNestedTableRef());
        } else {
            StatementHelper.logError(TableHelper.class.getName() + ": implement getEffectiveResultColumns(TableReference)" + " for " + tableRef.getClass().getName());
        }
        return resultColExprList;
    }

    public static List exposeEffectiveResultColumns(WithTableReference withTable) {
        ArrayList<ValueExpressionColumn> resultColExprList = new ArrayList<ValueExpressionColumn>();
        if (withTable == null || withTable.getWithTableSpecification() == null) {
            return resultColExprList;
        }
        WithTableSpecification withTableSpec = withTable.getWithTableSpecification();
        QueryExpressionBody withTableQuery = withTableSpec.getWithTableQueryExpr();
        List withTableQueryResultCols = TableHelper.getEffectiveResultColumns(withTableQuery);
        EList withTableColNames = withTableSpec.getColumnNameList();
        if (withTableColNames == null || withTableColNames.isEmpty()) {
            resultColExprList.addAll(TableHelper.copyColumnExprList(withTableQueryResultCols));
        } else if (withTableColNames != null && !withTableColNames.isEmpty() && withTableColNames.size() <= withTableQueryResultCols.size()) {
            for (int i = 0; i < withTableColNames.size(); ++i) {
                ColumnName columnName = (ColumnName)withTableColNames.get(i);
                ValueExpressionColumn exposedCol = StatementHelper.createColumnExpression(columnName.getName());
                ValueExpressionColumn withQueryResultCol = (ValueExpressionColumn)withTableQueryResultCols.get(i);
                DataType withQueryResultColDataType = withQueryResultCol.getDataType();
                DataType exposedColDataType = ValueExpressionHelper.copyDataType(withQueryResultColDataType);
                exposedCol.setTableInDatabase(withQueryResultCol.getTableInDatabase());
                exposedCol.setDataType(exposedColDataType);
                resultColExprList.add(exposedCol);
            }
        } else if (withTableColNames != null && !withTableColNames.isEmpty() && withTableQueryResultCols.isEmpty()) {
            for (int i = 0; i < withTableColNames.size(); ++i) {
                ColumnName columnName = (ColumnName)withTableColNames.get(i);
                ValueExpressionColumn exposedCol = StatementHelper.createColumnExpression(columnName.getName());
                resultColExprList.add(exposedCol);
            }
        }
        withTable.getColumnList().clear();
        withTable.getColumnList().addAll(resultColExprList);
        return resultColExprList;
    }

    public static ValueExpressionColumn getOrCreateColumnExpression(String columnName, TableExpression tableExpr) {
        ValueExpressionColumn newCol = null;
        if (columnName != null && tableExpr != null && tableExpr.getColumnList() != null) {
            newCol = TableHelper.getColumnExpressionForName(tableExpr, columnName);
        }
        if (newCol == null) {
            newCol = StatementHelper.createColumnExpression(columnName);
        }
        return newCol;
    }

    public static SortedSet getDistinctColumnExpressionList(TableExpression tableExpr) {
        TreeSet columnExprSet = null;
        if (tableExpr != null && tableExpr.getColumnList().size() > 0) {
            Comparator columnExprNameComp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    int columnComp = 0;
                    String colName1 = ((ValueExpressionColumn)o1).getName();
                    String colName2 = ((ValueExpressionColumn)o2).getName();
                    columnComp = colName1 != null && colName1.startsWith(TableHelper.DELIMITED_IDENTIFIER_QUOTE) ? colName1.compareTo(colName2) : colName1.compareToIgnoreCase(colName2);
                    return columnComp;
                }
            };
            columnExprSet = new TreeSet(columnExprNameComp);
            columnExprSet.addAll(tableExpr.getColumnList());
        }
        return columnExprSet;
    }

    private class ColumnInTwoTablesException
    extends Exception {
        private ColumnInTwoTablesException() {
        }
    }
}

