/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.deltaddl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.enablement.sybase.IGenericDdlConstants;
import org.eclipse.datatools.enablement.sybase.asa.ISybaseASADdlConstants;
import org.eclipse.datatools.enablement.sybase.asa.ddl.SybaseASADdlBuilder;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.Schedule;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseEvent;
import org.eclipse.datatools.enablement.sybase.ddl.ISybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.enablement.sybase.parser.QuickSQLParser;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;

public class SybaseASAEventDeltaDdlGenProvider
implements IDeltaDdlGenProvider,
IGenericDdlConstants,
ISybaseASADdlConstants {
    private static final int TYPE_IND = 0;
    private static final int WHERE_IND = 1;
    private static final int SCHEDULE_IND = 2;
    private static final int ENABLE_IND = 3;
    private static final int LOCATION_IND = 4;
    private static final String MODIFY = "MODIFY";

    public void processAlterStatement(SQLObject element, Map modifyRecordMap, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, IProgressMonitor monitor) {
        if (!(element instanceof SybaseASABaseEvent)) {
            return;
        }
        SybaseASABaseEvent event = (SybaseASABaseEvent)element;
        SybaseASADdlBuilder builder = SybaseASADdlBuilder.getInstance();
        String[] alters = new String[5];
        ArrayList<String> altSchedules = new ArrayList<String>();
        List records = (List)modifyRecordMap.get(element);
        if (records != null) {
            String[] create = builder.createEvent((Event)event, quoteIdentifiers, qualifyNames, fullSyntax);
            String comment = null;
            Iterator iter = records.iterator();
            while (iter.hasNext()) {
                int i;
                SybaseDeltaDdlGeneration.FeatureChangeRecord r = (SybaseDeltaDdlGeneration.FeatureChangeRecord)iter.next();
                if (r.feature.getFeatureID() == 1) {
                    String oldName = (String)r.oldValue;
                    String schemaName = event.getEventCreator().getName();
                    if (quoteIdentifiers) {
                        oldName = SQLUtil.quote((String)oldName, (String)"\"");
                        schemaName = SQLUtil.quote((String)schemaName, (String)"\"");
                    }
                    if (qualifyNames) {
                        oldName = schemaName + "." + oldName;
                    }
                    StringBuffer drop = new StringBuffer(128);
                    drop.append("DROP").append(" ").append("EVENT").append(" ").append(oldName);
                    for (i = 0; i < create.length; ++i) {
                        script.addCreateEventStatements(create[i]);
                    }
                    script.addDropEventStatements(drop.toString());
                    return;
                }
                if (r.feature.getFeatureID() == 3) {
                    comment = builder.createComment((SQLObject)event, quoteIdentifiers, qualifyNames);
                    continue;
                }
                if (r.feature.getFeatureID() == 12) {
                    if (event.getEventType() == null || event.getEventType().getValue() == 0) {
                        alters[0] = "DELETE TYPE" + NEWLINE;
                        continue;
                    }
                    alters[0] = "TYPE " + event.getEventType().getLiteral() + NEWLINE;
                    continue;
                }
                if (r.feature.getFeatureID() == 8) {
                    if (event.getCondition() == null || event.getCondition().trim().equals("")) {
                        alters[1] = "WHERE NULL" + NEWLINE;
                        continue;
                    }
                    alters[1] = "WHERE " + event.getCondition() + NEWLINE;
                    continue;
                }
                if (r.feature.getFeatureID() == 15) {
                    boolean found;
                    EList oldSch = (EList)r.oldValue;
                    EList schedules = event.getSchedules();
                    if (schedules == null || schedules.isEmpty()) {
                        String sch;
                        if (oldSch == null || oldSch.isEmpty()) continue;
                        alters[2] = sch = "DELETE SCHEDULE " + ((Schedule)oldSch.get(0)).getName() + NEWLINE;
                        for (i = 1; i < oldSch.size(); ++i) {
                            sch = "DELETE SCHEDULE " + ((Schedule)oldSch.get(i)).getName() + NEWLINE;
                            altSchedules.add(sch);
                        }
                        continue;
                    }
                    if (oldSch == null && oldSch.isEmpty()) {
                        String sch;
                        alters[2] = sch = "ADD SCHEDULE " + builder.getEventSchedule((Schedule)schedules.get(0)) + NEWLINE;
                        for (i = 1; i < schedules.size(); ++i) {
                            sch = "ADD SCHEDULE " + ((Schedule)schedules.get(i)).getName() + NEWLINE;
                            altSchedules.add(sch);
                        }
                        continue;
                    }
                    for (int i2 = 0; i2 < oldSch.size(); ++i2) {
                        found = false;
                        for (int j = 0; j < schedules.size(); ++j) {
                            if (!((Schedule)schedules.get(j)).getName().equals(((Schedule)oldSch.get(i2)).getName())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        String sch = "DELETE SCHEDULE " + ((Schedule)oldSch.get(i2)).getName() + NEWLINE;
                        if (i2 == 0 && alters[2] == null) {
                            alters[2] = sch;
                            continue;
                        }
                        altSchedules.add(sch);
                    }
                    for (int j = 0; j < schedules.size(); ++j) {
                        String sch;
                        found = false;
                        for (int i3 = 0; i3 < oldSch.size(); ++i3) {
                            if (!((Schedule)schedules.get(j)).getName().equals(((Schedule)oldSch.get(i3)).getName())) continue;
                            found = true;
                            break;
                        }
                        if (found) {
                            sch = "MODIFY SCHEDULE " + builder.getEventSchedule((Schedule)schedules.get(j)) + NEWLINE;
                            if (j == 0 && alters[2] == null) {
                                alters[2] = sch;
                                continue;
                            }
                            altSchedules.add(sch);
                            continue;
                        }
                        sch = "ADD SCHEDULE " + builder.getEventSchedule((Schedule)schedules.get(j)) + NEWLINE;
                        if (j == 0 && alters[2] == null) {
                            alters[2] = sch;
                            continue;
                        }
                        altSchedules.add(sch);
                    }
                    continue;
                }
                if (r.feature.getFeatureID() == 10) {
                    if (event.isEnabled()) {
                        alters[3] = "ENABLE" + NEWLINE;
                        continue;
                    }
                    alters[3] = "DISABLE" + NEWLINE;
                    continue;
                }
                if (r.feature.getFeatureID() != 14) continue;
                alters[4] = "AT " + event.getLocation().getLiteral() + NEWLINE;
            }
            if (records.size() == 1 && ((SybaseDeltaDdlGeneration.FeatureChangeRecord)records.get((int)0)).feature.getFeatureID() == 3) {
                script.addCreateEventStatements(comment);
                return;
            }
            QuickSQLParser parser = QuickSQLParser.getInstance();
            int[] createIndex = parser.find(create[0], new String[]{"CREATE"});
            int[] handlerIndex = parser.find(create[0], new String[]{"HANDLER"});
            if (createIndex[0] >= 0 && handlerIndex[0] >= 0) {
                String alter = create[0].substring(0, createIndex[0]) + "ALTER" + " " + "EVENT" + builder.getName((ENamedElement)event, quoteIdentifiers, false) + NEWLINE;
                for (int i = 0; i < alters.length; ++i) {
                    if (alters[i] == null) continue;
                    alter = alter + alters[i];
                }
                alter = alter + create[0].substring(handlerIndex[0]);
                script.addCreateEventStatements(alter);
                Iterator it = altSchedules.iterator();
                while (it.hasNext()) {
                    String sch = (String)it.next();
                    script.addCreateEventStatements(sch);
                }
                if (comment != null) {
                    script.addCreateEventStatements(comment);
                }
            } else {
                for (int i = 0; i < create.length; ++i) {
                    script.addCreateEventStatements(create[i]);
                }
            }
        }
    }

    public void processCreateStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, ISybaseDdlGenerator generator, IProgressMonitor monitor) {
    }

    public void processDropStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, SybaseDdlScript script, DDLGenerator generator, IProgressMonitor monitor) {
    }

    public void analyze(SQLObject element, Map changeMap, Map modificationRecords) {
    }
}

