/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.ddl;

import com.ibm.icu.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.sybase.asa.ISybaseASADdlConstants;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.AllowNullType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.EventType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.ParameterType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.Schedule;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseColumn;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDBSpace;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseEvent;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseFunction;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseParameter;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABasePrimaryKey;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseProcedure;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseProxyTable;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseRemoteProcedure;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseTable;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseTrigger;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseUserDefinedType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseViewTable;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASAWebService;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.TransactionOption;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasasqlmodel.SybaseASADatabase;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasasqlmodel.SybaseASAForeignKey;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasasqlmodel.SybaseASAIndex;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasasqlmodel.SybaseASATable;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasasqlmodel.SybaseASATempTable;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlBuilder;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseParameter;
import org.eclipse.datatools.enablement.sybase.parser.QuickSQLParser;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Group;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.User;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.RoutineResultTable;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.IdentitySpecifier;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.TemporaryTable;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;

public class SybaseASADdlBuilder
extends SybaseDdlBuilder
implements ISybaseASADdlConstants {
    private static SybaseASADdlBuilder builder;

    protected SybaseASADdlBuilder() {
    }

    public static SybaseASADdlBuilder getInstance() {
        if (builder == null) {
            builder = new SybaseASADdlBuilder();
        }
        return builder;
    }

    public String[] createCatalogs(Catalog catalog, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        return new String[]{""};
    }

    public String[] createDatabase(Database database, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        SybaseASADatabase asaDatabase = (SybaseASADatabase)database;
        StringBuffer statement = new StringBuffer();
        statement.append(this.createSybaseASABaseDatabase((SybaseASABaseDatabase)database, quoteIdentifiers, qualifyNames));
        if (asaDatabase.isASECompatible() && fullSyntax) {
            statement.append(NEWLINE + "\t" + "ASE" + " " + "COMPATIBLE");
        } else {
            statement.append(NEWLINE + "\t" + "ASE");
        }
        if (!asaDatabase.isBaseOnASA10() && asaDatabase.getJavaSupport() != null) {
            statement.append(NEWLINE + "\t" + "JAVA" + " ");
            statement.append(asaDatabase.getJavaSupport().getValue());
        }
        if (asaDatabase.isCheckSumOn() && fullSyntax) {
            statement.append(NEWLINE + "\t" + "CHECKSUM" + " " + "ON");
        } else {
            statement.append(NEWLINE + "\t" + "CHECKSUM" + " " + "OFF");
        }
        return new String[]{statement.toString()};
    }

    protected String createSybaseASABaseDatabase(SybaseASABaseDatabase asaDatabase, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = new StringBuffer();
        statement.append("CREATE DATABASE");
        statement.append(this.getSingleQuotedString(asaDatabase.getDatabaseFileName()));
        if (asaDatabase.getMirrorFileName() != null) {
            statement.append(NEWLINE + "\t" + "MIRROR" + " ");
            statement.append(this.getSingleQuotedString(asaDatabase.getMirrorFileName()));
        }
        if (asaDatabase.isCaseSensitive()) {
            statement.append(NEWLINE + "\t" + "CASE" + " " + "RESPECT");
        } else {
            statement.append(NEWLINE + "\t" + "CASE" + " " + "IGNORE");
        }
        if (asaDatabase.getPageSize() > -1) {
            statement.append(NEWLINE + "\t" + "PAGE" + " ");
            statement.append(asaDatabase.getPageSize());
        }
        if (asaDatabase.getCollation() != null) {
            statement.append(NEWLINE + "\t" + "COLLATION" + " ");
            statement.append(this.getSingleQuotedString(asaDatabase.getCollation()));
        }
        if (asaDatabase.getEncryptionInfo() != null && asaDatabase.getEncryptionInfo().isEncryptedTable()) {
            statement.append(NEWLINE + "\t" + "ENCRYPTED" + " " + "ON");
            if (asaDatabase.getEncryptionInfo().getEncryptionKey() != null) {
                statement.append(" KEY ");
                statement.append(this.getSingleQuotedString(asaDatabase.getEncryptionInfo().getEncryptionKey()));
            }
        } else {
            statement.append(NEWLINE + "\t" + "ENCRYPTED" + " " + "OFF");
        }
        if (asaDatabase.isBlankPaddingOn()) {
            statement.append(NEWLINE + "\t" + "BLANK" + " " + "PADDING" + " " + "ON");
        } else {
            statement.append(NEWLINE + "\t" + "BLANK" + " " + "PADDING" + " " + "OFF");
        }
        if (asaDatabase.isJConnectOn()) {
            statement.append(NEWLINE + "\t" + "JCONNECT" + " " + "ON");
        } else {
            statement.append(NEWLINE + "\t" + "JCONNECT" + " " + "OFF");
        }
        if (asaDatabase.getPasswordCaseSensitive().booleanValue()) {
            statement.append(NEWLINE + "\t" + "PASSWORD" + " " + "CASE" + " " + "RESPECT");
        } else {
            statement.append(NEWLINE + "\t" + "PASSWORD" + " " + "CASE" + " " + "IGNORE");
        }
        return statement.toString();
    }

    public String[] createEvent(Event event, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        SybaseASABaseEvent evt = (SybaseASABaseEvent)event;
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(" ").append("EVENT").append(" ").append(this.getName(event, quoteIdentifiers, qualifyNames)).append(NEWLINE);
        EventType type = evt.getEventType();
        String schedule = this.getEventSchedules(evt);
        if (schedule != null && !schedule.trim().equals("")) {
            sb.append(schedule).append(NEWLINE);
        } else if (type != null && !type.equals(EventType.NOEVENTTYPE_LITERAL)) {
            sb.append("\t").append("TYPE").append(" ").append(type.getLiteral()).append(NEWLINE);
            String condition = evt.getCondition();
            if (condition != null) {
                sb.append("\t").append("WHERE").append(" ").append(condition).append(NEWLINE);
            }
        }
        if (evt.isEnabled()) {
            sb.append("ENABLE").append(NEWLINE);
        } else {
            sb.append("DISABLE").append(NEWLINE);
        }
        if (fullSyntax || evt.isSet(14)) {
            sb.append("AT").append(" ").append(evt.getLocation().getLiteral()).append(NEWLINE);
        }
        sb.append("HANDLER").append(NEWLINE);
        String body = event.getAction();
        sb.append(body);
        String comment = this.createComment((SQLObject)event, quoteIdentifiers, qualifyNames);
        if (comment != null && !comment.trim().equals("")) {
            return new String[]{sb.toString(), comment};
        }
        return new String[]{sb.toString()};
    }

    public String[] createProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        String comment = this.createComment((SQLObject)procedure, quoteIdentifiers, qualifyNames);
        SybaseASABaseProcedure proc = (SybaseASABaseProcedure)procedure;
        Source source = procedure.getSource();
        String body = "";
        if (source != null && source.getBody() != null) {
            body = source.getBody();
        }
        if (QuickSQLParser.getInstance().match(body, 1)) {
            if (comment != null && !comment.trim().equals("")) {
                return new String[]{body, comment};
            }
            return new String[]{body};
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(" ").append("PROCEDURE").append(" ").append(this.getName(procedure, quoteIdentifiers, qualifyNames)).append(NEWLINE);
        int syntaxType = this.getSyntaxType(procedure);
        String param = "";
        param = syntaxType == 0 ? this.getTSQLParameters((Routine)procedure) : this.getWatcomParameters((Routine)procedure, fullSyntax);
        if (param != null && param.length() > 0) {
            sb.append("(").append(param).append(")").append(NEWLINE);
        }
        if (syntaxType == 0) {
            sb.append("AS").append(NEWLINE).append(body);
        } else {
            sb.append("\t").append(this.getRoutineResults(procedure));
            sb.append("\t").append(this.getCharacteristics((Routine)proc));
            if (proc instanceof SybaseASABaseRemoteProcedure) {
                sb.append("\t").append("AT").append(" ").append(((SybaseASABaseRemoteProcedure)proc).getLocation()).append(NEWLINE);
            } else if (proc.getExternalName() != null) {
                sb.append(this.getExternalNameOption((Routine)proc, quoteIdentifiers, qualifyNames));
            } else if (body.length() > 0) {
                sb.append(body);
            }
        }
        if (comment != null && !comment.trim().equals("")) {
            return new String[]{sb.toString(), comment};
        }
        return new String[]{sb.toString()};
    }

    public String getRoutineResults(Procedure procedure) {
        StringBuffer sb = new StringBuffer();
        EList resultSet = procedure.getResultSet();
        boolean hasColumn = false;
        if (resultSet != null && !resultSet.isEmpty()) {
            sb.append("RESULT").append(" ").append("(");
            Iterator iter = resultSet.iterator();
            while (iter.hasNext()) {
                RoutineResultTable resultTable = (RoutineResultTable)iter.next();
                Iterator it = resultTable.getColumns().iterator();
                while (it.hasNext()) {
                    Column c = (Column)it.next();
                    if (c.getName() == null || c.getDataType() == null) continue;
                    hasColumn = true;
                    sb.append(c.getName()).append(" ").append(this.getDataTypeString((TypedElement)c, procedure.getSchema()));
                    if (!it.hasNext()) continue;
                    sb.append(",").append(" ");
                }
            }
            if (sb.charAt(sb.length() - 2) == ',') {
                sb.delete(sb.length() - 2, sb.length());
            }
            sb.append(")").append(NEWLINE);
        }
        if (hasColumn) {
            return sb.toString();
        }
        return "";
    }

    public String[] createUserDefinedFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        String comment = this.createComment((SQLObject)function, quoteIdentifiers, qualifyNames);
        Source source = function.getSource();
        String body = "";
        if (source != null && source.getBody() != null) {
            body = source.getBody();
        }
        if (QuickSQLParser.getInstance().match(body, 2)) {
            if (comment != null && !comment.trim().equals("")) {
                return new String[]{body, comment};
            }
            return new String[]{body};
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(" ").append("FUNCTION").append(" ").append(this.getName(function, quoteIdentifiers, qualifyNames)).append(NEWLINE);
        String param = this.getFuncParameters(function, fullSyntax);
        if (param != null && param.length() > 0) {
            sb.append("(").append(param).append(")").append(NEWLINE);
        }
        sb.append(this.getFunctionReturnsClause(function));
        sb.append("\t").append(this.getCharacteristics((Routine)function));
        if (function.getExternalName() != null) {
            sb.append(this.getExternalNameOption((Routine)function, quoteIdentifiers, qualifyNames));
        } else if (body.length() > 0) {
            sb.append(body);
        }
        if (comment != null && !comment.trim().equals("")) {
            return new String[]{sb.toString(), comment};
        }
        return new String[]{sb.toString()};
    }

    public String getCharacteristics(Routine routine) {
        StringBuffer sb = new StringBuffer();
        if (routine instanceof SybaseASABaseProcedure && ((SybaseASABaseProcedure)routine).isOnExceptionResume()) {
            sb.append("ON EXCEPTION RESUME").append(NEWLINE);
        } else if (routine instanceof SybaseASABaseFunction) {
            if (((SybaseASABaseFunction)routine).isOnExceptionResume()) {
                sb.append("ON EXCEPTION RESUME").append(" ");
            }
            sb.append(this.getDeterministic((Routine)((SybaseASABaseFunction)routine)));
        }
        return sb.toString();
    }

    public String[] createTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (!(trigger instanceof SybaseASABaseTrigger)) {
            return new String[]{super.createTrigger(trigger, quoteIdentifiers, qualifyNames)};
        }
        String comment = this.createComment((SQLObject)trigger, quoteIdentifiers, qualifyNames);
        SybaseASABaseTrigger trig = (SybaseASABaseTrigger)trigger;
        String bodyString = this.getTriggerBody(trigger);
        if (QuickSQLParser.getInstance().match(bodyString, 3)) {
            if (comment != null && !comment.trim().equals("")) {
                return new String[]{bodyString, comment};
            }
            return new String[]{bodyString};
        }
        if (trig.getSybaseASABaseActionTime().getValue() == 3) {
            String tsqltrigger = this.createTSQLTrigger(trigger, quoteIdentifiers, qualifyNames);
            if (comment != null && !comment.trim().equals("")) {
                return new String[]{tsqltrigger, comment};
            }
            return new String[]{tsqltrigger};
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(" ").append("TRIGGER").append(" ").append(this.getName(trigger, quoteIdentifiers, qualifyNames)).append(NEWLINE);
        sb.append(this.getFullTriggerEvents(trig));
        sb.append(this.getTriggerOrder(fullSyntax, trig));
        Table subjectTable = trigger.getSubjectTable();
        if (subjectTable != null) {
            sb.append("ON").append(" ");
            Schema triggerOwner = trigger.getSchema();
            Schema tableOwner = subjectTable.getSchema();
            if (tableOwner != null && (qualifyNames || tableOwner.equals(triggerOwner))) {
                sb.append(tableOwner.getName()).append(".");
            }
            sb.append(trigger.getName()).append(NEWLINE);
        }
        sb.append(this.getTriggerReference(trig));
        sb.append(this.getTriggerGranularity(trig));
        SearchCondition when = trig.getWhen();
        if (when != null && when.getSQL() != null) {
            sb.append("WHEN").append(" ").append(when.getSQL()).append(NEWLINE);
        }
        sb.append(bodyString);
        if (comment != null && !comment.trim().equals("")) {
            return new String[]{sb.toString(), comment};
        }
        return new String[]{sb.toString()};
    }

    private boolean notEmpty(String text) {
        return text != null && !text.trim().equals("");
    }

    public String getTriggerReference(SybaseASABaseTrigger trig) {
        StringBuffer sb = new StringBuffer();
        switch (trig.getActionGranularity().getValue()) {
            case 1: {
                if (this.notEmpty(trig.getOldRow()) || this.notEmpty(trig.getOldRow()) || this.notEmpty(trig.getRemoteName())) {
                    sb.append("REFERENCING").append(" ");
                }
                if (this.notEmpty(trig.getOldRow())) {
                    sb.append("OLD").append(" ").append("AS").append(" ").append(trig.getOldRow()).append(" ");
                }
                if (this.notEmpty(trig.getNewRow())) {
                    sb.append("NEW").append(" ").append("AS").append(" ").append(trig.getNewRow()).append(" ");
                }
                if (!this.notEmpty(trig.getRemoteName())) break;
                sb.append("REMOTE").append(" ").append("AS").append(" ").append(trig.getRemoteName()).append(" ");
                break;
            }
            case 0: {
                if (this.notEmpty(trig.getOldTable()) || this.notEmpty(trig.getOldTable()) || this.notEmpty(trig.getRemoteName())) {
                    sb.append("REFERENCING").append(" ");
                }
                if (this.notEmpty(trig.getOldTable())) {
                    sb.append("OLD").append(" ").append("AS").append(" ").append(trig.getOldTable()).append(" ");
                }
                if (this.notEmpty(trig.getNewTable())) {
                    sb.append("NEW").append(" ").append("AS").append(" ").append(trig.getNewTable()).append(" ");
                }
                if (!this.notEmpty(trig.getRemoteName())) break;
                sb.append("REMOTE").append(" ").append("AS").append(" ").append(trig.getRemoteName()).append(" ");
            }
        }
        return sb.toString();
    }

    public String getTriggerGranularity(SybaseASABaseTrigger trig) {
        StringBuffer sb = new StringBuffer();
        switch (trig.getActionGranularity().getValue()) {
            case 1: {
                sb.append("FOR").append(" ").append("EACH").append(" ").append("ROW").append(NEWLINE);
                break;
            }
            case 0: {
                sb.append("FOR").append(" ").append("EACH").append(" ").append("STATEMENT").append(NEWLINE);
            }
        }
        return sb.toString();
    }

    public String getTriggerOrder(boolean fullSyntax, SybaseASABaseTrigger trig) {
        StringBuffer sb = new StringBuffer();
        if (fullSyntax || trig.isSet(22)) {
            int order = trig.getOrder();
            sb.append("ORDER").append(" ").append(order).append(" ");
        }
        return sb.toString();
    }

    public String getFullTriggerEvents(SybaseASABaseTrigger trig) {
        StringBuffer sb = new StringBuffer();
        sb.append(trig.getSybaseASABaseActionTime().getLiteral()).append(" ");
        EList triggerColumn = trig.getTriggerColumn();
        if (trig.isUpdateColumnType()) {
            if (triggerColumn != null && triggerColumn.size() > 0) {
                sb.append("UPDATE").append(" ").append("OF").append(" ");
                Iterator iter = triggerColumn.iterator();
                while (iter.hasNext()) {
                    Column column = (Column)iter.next();
                    sb.append(column.getName());
                    if (!iter.hasNext()) continue;
                    sb.append(",");
                }
                sb.append(" ");
            } else {
                sb.append("UPDATE").append(" ");
            }
        } else {
            sb.append(this.getTriggerEvents((Trigger)trig));
        }
        return sb.toString();
    }

    public String[] createUserDefinedType(UserDefinedType udt, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        EList constraints;
        SybaseASABaseUserDefinedType asaUDT = (SybaseASABaseUserDefinedType)udt;
        StringBuffer sb = new StringBuffer(128);
        sb.append("CREATE").append(" ").append("DOMAIN").append(" ").append("\"").append(asaUDT.getName()).append("\"").append(" ");
        DatabaseDefinitionRegistry dbRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
        DatabaseDefinition definition = dbRegistry.getDefinition((Database)ContainmentServiceImpl.INSTANCE.getRootElement((EObject)asaUDT));
        PredefinedDataType pdt = asaUDT.getPredefinedRepresentation();
        sb.append(definition.getPredefinedDataTypeFormattedName(pdt)).append(NEWLINE);
        AllowNullType allowNullType = asaUDT.getNullable();
        if (allowNullType.getValue() == 0) {
            sb.append("NULL").append(" ").append(NEWLINE);
        } else if (allowNullType.getValue() == 1) {
            sb.append("NOT").append(" ").append("NULL").append(" ").append(NEWLINE);
        }
        String defaultValue = asaUDT.getDefaultValue();
        if (defaultValue != null) {
            sb.append("DEFAULT").append(" ").append("'").append(defaultValue).append("'").append(NEWLINE);
        }
        if ((constraints = asaUDT.getConstraint()) != null && constraints.size() > 0) {
            CheckConstraint checkConstraint = (CheckConstraint)constraints.get(0);
            sb.append(checkConstraint.getSearchCondition().getSQL());
        }
        return new String[]{sb.toString()};
    }

    public String[] grantPrivilege(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        String[] stat = super.grantPrivilege(privilege, quoteIdentifiers, qualifyNames, fullSyntax);
        if (stat == null || stat.length == 0) {
            return new String[]{""};
        }
        StringBuffer sb = new StringBuffer(stat[0]);
        if (privilege.isGrantable()) {
            if (privilege.getAction() == null) {
                sb.append(" ").append("WITH GRANT OPTION");
            } else if (!privilege.getAction().equals("EXECUTE")) {
                sb.append(" ").append("WITH GRANT OPTION");
            }
        }
        return new String[]{sb.toString()};
    }

    public String[] createView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (!(view instanceof SybaseASABaseViewTable)) {
            return null;
        }
        ArrayList<String> stats = new ArrayList<String>();
        StringBuffer viewDefinition = new StringBuffer("");
        viewDefinition.append("CREATE").append(" ").append("VIEW").append(" ").append(this.getName((Table)view, quoteIdentifiers, qualifyNames)).append(" ");
        String columns = this.getViewColumnList(view, quoteIdentifiers);
        if (columns != null) {
            viewDefinition.append("(").append(columns).append(")").append(NEWLINE);
        }
        viewDefinition.append("AS").append(NEWLINE);
        viewDefinition.append(view.getQueryExpression().getSQL());
        if (((SybaseASABaseViewTable)view).isWithCheckOption()) {
            viewDefinition.append(NEWLINE).append("WITH CHECK OPTION");
        }
        stats.add(viewDefinition.toString());
        String comment = this.createComment((SQLObject)view, quoteIdentifiers, qualifyNames);
        if (comment != null && !comment.trim().equals("")) {
            stats.add(comment);
        }
        Iterator i = view.getColumns().iterator();
        while (i.hasNext()) {
            Column c = (Column)i.next();
            comment = this.createComment((SQLObject)c, quoteIdentifiers, qualifyNames);
            if (comment == null || comment.trim().equals("")) continue;
            stats.add(comment);
        }
        return stats.toArray(new String[stats.size()]);
    }

    public String createComment(SQLObject obj, boolean quoteIdentifiers, boolean qualifyNames) {
        if (obj.getDescription() == null || obj.getDescription().trim().length() == 0) {
            return null;
        }
        String objectType = null;
        String description = this.getSingleQuotedString(obj.getDescription());
        String objectName = this.getName((ENamedElement)obj, quoteIdentifiers, qualifyNames);
        if (obj instanceof Event) {
            objectType = "EVENT";
        } else if (obj instanceof ForeignKey) {
            objectType = "FOREIGN KEY";
        } else if (obj instanceof Index) {
            objectType = "INDEX";
        } else if (obj instanceof ViewTable) {
            objectType = "VIEW";
        } else if (obj instanceof Column) {
            objectType = "COLUMN";
        } else if (obj instanceof Routine) {
            objectType = "PROCEDURE";
        } else if (obj instanceof SybaseASAWebService) {
            objectType = "SERVICE";
        } else if (obj instanceof Table) {
            objectType = "TABLE";
        } else if (obj instanceof Trigger) {
            objectType = "TRIGGER";
        } else if (obj instanceof Schema) {
            objectType = "USER";
        }
        if (objectType != null) {
            StringBuffer comment = new StringBuffer("");
            comment.append("COMMENT").append(" ").append("ON").append(" ").append(objectType).append(" ").append(objectName);
            comment.append(" ").append("IS").append(" ").append(description);
            return comment.toString();
        }
        return null;
    }

    protected String[] createPersistentTable(PersistentTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (table instanceof SybaseASABaseTable) {
            return this.createBaseTable((SybaseASABaseTable)table, quoteIdentifiers, qualifyNames, fullSyntax);
        }
        if (table instanceof SybaseASABaseProxyTable) {
            return this.createProxyTable((SybaseASABaseProxyTable)table, quoteIdentifiers, qualifyNames, fullSyntax);
        }
        throw new UnsupportedOperationException();
    }

    protected String[] createBaseTable(SybaseASABaseTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        SybaseASABaseTable baseTable = table;
        String schemaName = baseTable.getSchema().getName();
        String tableName = baseTable.getName();
        if (quoteIdentifiers) {
            schemaName = this.getDoubleQuotedString(schemaName);
            tableName = this.getDoubleQuotedString(tableName);
        }
        StringBuffer statement = new StringBuffer();
        statement.append("CREATE");
        statement.append(" ");
        statement.append("TABLE");
        statement.append(" ");
        statement.append(schemaName);
        statement.append(".");
        statement.append(tableName);
        statement.append(" ");
        statement.append(this.getColumnAndPctfree((BaseTable)baseTable, quoteIdentifiers));
        if (this.getDBSpace(baseTable) != null) {
            statement.append(this.getDBSpace(baseTable));
        }
        ArrayList<String> results = new ArrayList<String>();
        results.add(statement.toString());
        String tableComment = this.createComment((SQLObject)table, quoteIdentifiers, qualifyNames);
        if (tableComment != null && !tableComment.equals("")) {
            results.add(tableComment);
        }
        for (int i = 0; i < table.getColumns().size(); ++i) {
            Column column = (Column)table.getColumns().get(i);
            String colComment = this.createComment((SQLObject)column, quoteIdentifiers, qualifyNames);
            if (colComment == null || colComment.equals("")) continue;
            results.add(colComment);
        }
        return results.toArray(new String[results.size()]);
    }

    protected String[] createProxyTable(SybaseASABaseProxyTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        StringBuffer stmt = new StringBuffer(512);
        stmt.append(this.createBaseTable((SybaseASABaseTable)table, quoteIdentifiers, qualifyNames, fullSyntax));
        stmt.append(NEWLINE).append("AT").append(" ").append("'").append(table.getRemoteObjectLocation()).append("'");
        return new String[]{stmt.toString()};
    }

    protected String[] createTempoeryTable(TemporaryTable tempTable, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (!(tempTable instanceof SybaseASATempTable)) {
            return null;
        }
        StringBuffer stmt = new StringBuffer();
        if (tempTable.isLocal()) {
            stmt.append("DECLARE LOCAL TEMPORARY TABLE").append(" ");
            String tableName = tempTable.getName();
            if (quoteIdentifiers) {
                tableName = this.getDoubleQuotedString(tableName);
            }
            stmt.append(tableName).append(" ");
        } else {
            stmt.append("CREATE").append(" ").append("GLOBAL TEMPORARY TABLE").append(" ").append(this.getName((Table)tempTable, quoteIdentifiers, qualifyNames)).append(" ");
        }
        stmt.append(this.getColumnAndPctfree((BaseTable)tempTable, quoteIdentifiers)).append(NEWLINE);
        if (((SybaseASATempTable)tempTable).getTransactionOption() == TransactionOption.NOT_TRANSACTION_LITERAL) {
            stmt.append("NOT TRANSACTIONAL");
        }
        if (((SybaseASATempTable)tempTable).getTransactionOption() == TransactionOption.PRESERVE_LITERAL) {
            stmt.append("ON COMMIT PRESERVE ROWS");
        }
        if (((SybaseASATempTable)tempTable).getTransactionOption() == TransactionOption.DELETE_LITERAL) {
            stmt.append("ON COMMIT DELETE ROWS");
        }
        return new String[]{stmt.toString()};
    }

    public String[] createIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        String comment;
        SybaseASAIndex asaIndex = (SybaseASAIndex)index;
        StringBuffer statement = new StringBuffer();
        statement.append("CREATE ");
        if (asaIndex.isVirtual()) {
            statement.append("VIRTUAL ");
        }
        if (index.isUnique()) {
            statement.append("UNIQUE ");
        }
        if (index.isClustered()) {
            statement.append("CLUSTERED ");
        }
        statement.append("INDEX " + this.getName(index, quoteIdentifiers, qualifyNames) + " " + "ON" + " " + this.getName(index.getTable(), quoteIdentifiers, qualifyNames) + " " + "(" + this.getIndexKeyColumns(index, quoteIdentifiers) + ")");
        if (asaIndex.getDbSpace() != null) {
            statement.append(NEWLINE + "\t" + "ON" + " " + this.getName((ENamedElement)asaIndex.getDbSpace(), quoteIdentifiers, qualifyNames));
        }
        if ((comment = this.createComment((SQLObject)index, quoteIdentifiers, qualifyNames)) != null && !comment.trim().equals("")) {
            return new String[]{statement.toString(), comment};
        }
        return new String[]{statement.toString()};
    }

    public String[] addUniqueConstraint(UniqueConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (constraint == null) {
            return null;
        }
        StringBuffer statement = new StringBuffer(128);
        statement.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames)).append(" ");
        statement.append("ADD").append(" ");
        statement.append(this.getAddUniqueConstraintClause(constraint, quoteIdentifiers));
        return new String[]{statement.toString()};
    }

    public String[] addForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        ReferentialActionType action;
        if (foreignKey == null) {
            return null;
        }
        SybaseASAForeignKey asaForeignKey = (SybaseASAForeignKey)foreignKey;
        UniqueConstraint uniqueConstraint = foreignKey.getUniqueConstraint();
        Index index = foreignKey.getUniqueIndex();
        BaseTable parentTable = null;
        String parentKey = null;
        if (uniqueConstraint != null) {
            parentTable = uniqueConstraint.getBaseTable();
            parentKey = this.getKeyColumns((ReferenceConstraint)uniqueConstraint, quoteIdentifiers);
        } else if (index != null) {
            parentKey = super.getParentKeyColumns(index, quoteIdentifiers);
        }
        if (parentTable == null) {
            return null;
        }
        StringBuffer statement = new StringBuffer(128);
        statement.append("ALTER").append(" ").append("TABLE").append(" ").append(super.getName((Table)foreignKey.getBaseTable(), quoteIdentifiers, qualifyNames)).append(" ");
        String name = foreignKey.getName();
        if (name != null && name.trim().length() != 0) {
            if (quoteIdentifiers) {
                name = super.getDoubleQuotedString(name);
            }
            statement.append("ADD").append(" ").append("CONSTRAINT").append(" ").append(name).append(" ");
        }
        if (!asaForeignKey.isNullable()) {
            statement.append("NOT").append(" ").append("NULL").append(" ");
        }
        statement.append("FOREIGN KEY").append(" ").append("(").append(this.getKeyColumns((ReferenceConstraint)foreignKey, quoteIdentifiers)).append(")").append(NEWLINE);
        statement.append("\t").append("REFERENCES").append(" ").append(super.getName((Table)parentTable, quoteIdentifiers, qualifyNames)).append(" ").append("(").append(parentKey).append(")");
        if (asaForeignKey.isClustered()) {
            statement.append(NEWLINE).append("\t").append("CLUSTERED");
        }
        if ((action = foreignKey.getOnDelete()) != ReferentialActionType.NO_ACTION_LITERAL) {
            statement.append(NEWLINE).append("\t").append("ON").append(" ").append("DELETE").append(" ");
        }
        statement.append(this.getReferentialAction(action));
        action = foreignKey.getOnUpdate();
        if (action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement.append(NEWLINE).append("\t").append("ON").append(" ").append("UPDATE").append(" ");
        }
        statement.append(this.getReferentialAction(action));
        if (asaForeignKey.isCheckOnCommit()) {
            statement.append(NEWLINE).append("CHECK").append(" ").append("ON").append(" ").append("COMMIT");
        }
        return new String[]{statement.toString()};
    }

    public String[] createColumn(Column col, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        StringBuffer sb = new StringBuffer(256);
        sb.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName(col.getTable(), quoteIdentifiers, qualifyNames)).append(" ").append("ADD").append(" ").append(this.getColumnString(col, quoteIdentifiers));
        return new String[]{sb.toString()};
    }

    public String[] createDBSpace(SybaseASABaseDBSpace dbSpace, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        StringBuffer sb = new StringBuffer(64);
        sb.append("CREATE").append(" ").append("DBSPACE").append(" ").append(this.getName((ENamedElement)dbSpace, quoteIdentifiers, qualifyNames)).append(" ").append("AS").append(" ").append(dbSpace.getFileName());
        return new String[]{sb.toString()};
    }

    public String[] createAuthorizationId(AuthorizationIdentifier authId, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        ArrayList<String> results = new ArrayList<String>();
        StringBuffer sb1 = new StringBuffer(128);
        String name = this.getName((ENamedElement)authId, quoteIdentifiers, qualifyNames);
        sb1.append("GRANT").append(" ").append("CONNECT").append(" ").append("TO").append(" ").append(name).append(NEWLINE).append("\t").append("IDENTIFIED").append(" ").append("BY").append(" ").append("'******'");
        results.add(sb1.toString());
        if (authId instanceof Group) {
            StringBuffer sb2 = new StringBuffer(128);
            sb2.append("GRANT").append(" ").append("GROUP").append(" ").append("TO").append(" ").append(name);
            results.add(sb2.toString());
            EList users = ((Group)authId).getUser();
            StringBuffer strUserNames = new StringBuffer(128);
            for (int i = 0; i < users.size(); ++i) {
                User user = (User)users.get(i);
                strUserNames.append(this.getName((ENamedElement)user, quoteIdentifiers, qualifyNames));
                if (i == users.size() - 1) continue;
                strUserNames.append(",").append(" ");
            }
            if (users.size() > 0) {
                StringBuffer sb3 = new StringBuffer(128);
                sb3.append("GRANT").append(" ").append("MEMBERSHIP").append(" ").append("IN").append(" ").append("GROUP").append(" ").append(name).append(NEWLINE).append("TO").append(" ").append(strUserNames);
                results.add(sb3.toString());
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String dropEvent(Event event, boolean quoteIdentifiers, boolean qualifyNames) {
        String text = "DROP EVENT " + this.getName(event, quoteIdentifiers, qualifyNames);
        return text;
    }

    public String dropProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP PROCEDURE " + this.getName(procedure, quoteIdentifiers, qualifyNames);
    }

    public String dropFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP FUNCTION " + this.getName(function, quoteIdentifiers, qualifyNames);
    }

    public String dropForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = this.dropConstraint((TableConstraint)foreignKey, quoteIdentifiers, qualifyNames);
        statement.append(" ").append(this.getName((TableConstraint)foreignKey, quoteIdentifiers));
        return statement.toString();
    }

    public String dropCheckConstraint(CheckConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = this.dropConstraint((TableConstraint)constraint, quoteIdentifiers, qualifyNames);
        return statement.toString();
    }

    public String dropUniqueConstraint(UniqueConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = this.dropConstraint((TableConstraint)constraint, quoteIdentifiers, qualifyNames);
        if (constraint instanceof PrimaryKey) {
            return statement.toString();
        }
        statement.append(" ");
        statement.append("(").append(this.getKeyColumns((ReferenceConstraint)constraint, quoteIdentifiers)).append(")");
        return statement.toString();
    }

    public String dropUserDefinedType(UserDefinedType udt, boolean quoteIdentifiers, boolean qualifyNames) {
        SybaseASABaseUserDefinedType asaUDT = (SybaseASABaseUserDefinedType)udt;
        StringBuffer sb = new StringBuffer(128);
        sb.append("DROP").append(" ").append("DOMAIN").append(" ").append(asaUDT.getName());
        return sb.toString();
    }

    public String dropDBSpace(SybaseASABaseDBSpace dbspace, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("DROP").append(" ").append("DBSPACE").append(" ").append(dbspace.getName());
        return sb.toString();
    }

    public String dropAuthorizationId(AuthorizationIdentifier authId, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("REVOKE").append(" ").append("CONNECT").append(" ").append("FROM").append(" ").append(this.getName((ENamedElement)authId, quoteIdentifiers, qualifyNames));
        return sb.toString();
    }

    protected String getColumnString(Column column, boolean quoteIdentifiers) {
        SybaseASABaseColumn baseColumn = (SybaseASABaseColumn)column;
        StringBuffer statement = new StringBuffer();
        String columnName = baseColumn.getName();
        String dataTypeName = this.getDataTypeString((TypedElement)column, column.getTable().getSchema());
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        statement.append(columnName);
        statement.append(" ");
        statement.append(dataTypeName);
        if (baseColumn.isNullable()) {
            statement.append(" ");
            statement.append("NULL");
        } else {
            statement.append(" ");
            statement.append("NOT");
            statement.append(" ");
            statement.append("NULL");
        }
        if (baseColumn.getDefaultValue() != null) {
            String defaultName = column.getDefaultValue();
            statement.append(" ");
            statement.append("DEFAULT");
            statement.append(" ");
            statement.append(defaultName);
        }
        if (baseColumn.getColumnConstraint() != null) {
            statement.append(" ");
            statement.append(this.getAddCheckConstraintClause((CheckConstraint)baseColumn.getColumnConstraint(), quoteIdentifiers));
        }
        return statement.toString();
    }

    protected String getIdentityString(IdentitySpecifier identitySpecifier) {
        String clause = "START WITH " + identitySpecifier.getStartValue() + " ,INCREMENT BY " + identitySpecifier.getIncrement();
        return clause;
    }

    public String getWatcomParameters(Routine routine, boolean fullSyntax) {
        StringBuffer sb = new StringBuffer();
        Iterator it = routine.getParameters().iterator();
        while (it.hasNext()) {
            Parameter p = (Parameter)it.next();
            sb.append(this.getWatcomParameter(routine, p));
            if (!it.hasNext()) continue;
            sb.append(",").append(" ");
        }
        return sb.toString();
    }

    public String getWatcomParameter(Routine routine, Parameter p) {
        String dft;
        ParameterType paramType;
        StringBuffer sb = new StringBuffer();
        if (p instanceof SybaseASABaseParameter && ((paramType = ((SybaseASABaseParameter)p).getParmType()).getValue() == 3 || paramType.getValue() == 2)) {
            return paramType.getLiteral();
        }
        ParameterMode mode = p.getMode();
        if (mode == ParameterMode.IN_LITERAL) {
            sb.append("IN").append(" ");
        } else if (mode == ParameterMode.INOUT_LITERAL) {
            sb.append("INOUT").append(" ");
        } else if (mode == ParameterMode.OUT_LITERAL) {
            sb.append("OUT").append(" ");
        }
        String name = p.getName();
        if (name != null && name.length() != 0) {
            sb.append(p.getName()).append(" ");
        }
        sb.append(this.getDataTypeString((TypedElement)p, routine.getSchema()));
        if (p instanceof SybaseParameter && (dft = ((SybaseParameter)p).getDefaultValue()) != null && dft.length() != 0) {
            sb.append(" ").append("DEFAULT").append(" ").append(dft).append(" ");
        }
        return sb.toString();
    }

    protected String getFuncParameters(UserDefinedFunction function, boolean fullSyntax) {
        StringBuffer sb = new StringBuffer();
        Iterator it = function.getParameters().iterator();
        while (it.hasNext()) {
            String name;
            Parameter p = (Parameter)it.next();
            ParameterMode mode = p.getMode();
            if (mode == ParameterMode.IN_LITERAL && fullSyntax) {
                sb.append("IN").append(" ");
            }
            if ((name = p.getName()) != null && name.length() != 0) {
                sb.append(p.getName()).append(" ");
            }
            sb.append(this.getDataTypeString((TypedElement)p, function.getSchema()));
            if (!it.hasNext()) continue;
            sb.append(",").append(" ");
        }
        return sb.toString();
    }

    protected String getExternalNameOption(Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer();
        if ("JAVA".equalsIgnoreCase(routine.getLanguage())) {
            if (routine instanceof Procedure && ((Procedure)routine).getMaxResultSets() > 0) {
                sb.append("\t").append("DYNAMIC RESULT SETS").append(" ").append(((Procedure)routine).getMaxResultSets()).append(NEWLINE);
            }
            sb.append("\t").append("EXTERNAL NAME").append(" ").append(routine.getExternalName()).append(" ");
            sb.append("LAUNGUAGE").append(" ").append("JAVA").append(NEWLINE);
        } else {
            sb.append("\t").append("EXTERNAL NAME").append(" ").append(routine.getExternalName()).append(NEWLINE);
        }
        return sb.toString();
    }

    protected String getFunctionReturnsClause(UserDefinedFunction function) {
        if (function.getReturnScalar() != null) {
            Parameter scaler = function.getReturnScalar();
            StringBuffer sb = new StringBuffer();
            sb.append("RETURNS").append(" ").append(this.getDataTypeString((TypedElement)scaler, function.getSchema())).append(NEWLINE);
            return sb.toString();
        }
        return "";
    }

    public int getSyntaxType(Procedure routine) {
        Parameter param;
        if (routine instanceof SybaseASABaseRemoteProcedure) {
            return 5;
        }
        if (routine.getExternalName() != null) {
            if ("Java".equalsIgnoreCase(routine.getLanguage())) {
                return 3;
            }
            return 4;
        }
        boolean watcom1 = false;
        if (routine instanceof SybaseASABaseProcedure) {
            watcom1 = ((SybaseASABaseProcedure)routine).isOnExceptionResume();
        }
        if (watcom1 |= routine.getResultSet() != null && !routine.getResultSet().isEmpty()) {
            return 1;
        }
        boolean watcom2 = false;
        EList params = routine.getParameters();
        if (params != null && params.size() == 1 && (param = (Parameter)params.get(0)) instanceof SybaseASABaseParameter) {
            boolean bl = watcom2 = ((SybaseASABaseParameter)param).getParmType() == ParameterType.SQLSTATE_LITERAL || ((SybaseASABaseParameter)param).getParmType() == ParameterType.SQLCODE_LITERAL;
        }
        if (watcom2) {
            return 2;
        }
        return 0;
    }

    protected String getColumnAndPctfree(BaseTable baseTable, boolean quoteIdentifiers) {
        StringBuffer statement = new StringBuffer();
        statement.append("(");
        statement.append(NEWLINE);
        EList list = baseTable.getColumns();
        String pctFREE = this.getPctfree(baseTable, quoteIdentifiers);
        int size = list.size();
        if (pctFREE != null) {
            ++size;
        }
        for (int i = 0; i < list.size(); ++i) {
            SybaseASABaseColumn column = (SybaseASABaseColumn)list.get(i);
            statement.append(this.getColumnString((Column)column, quoteIdentifiers));
            if (size <= 1 || i >= size - 1) continue;
            statement.append(",");
            statement.append(" ");
            statement.append(NEWLINE);
        }
        if (pctFREE != null) {
            statement.append(pctFREE);
        }
        statement.append(")");
        return statement.toString();
    }

    protected String getDBSpace(SybaseASABaseTable baseTable) {
        StringBuffer statement = null;
        if (baseTable.getDbSpace() != null && baseTable.getDbSpace().getName() != null) {
            statement = new StringBuffer();
            statement.append(NEWLINE);
            statement.append("IN");
            statement.append(" ");
            statement.append(baseTable.getDbSpace().getName());
        }
        if (statement == null) {
            return null;
        }
        return statement.toString();
    }

    protected String getPctfree(BaseTable table, boolean quoteIdentifiers) {
        SybaseASATable sybaseASATable;
        StringBuffer statement = null;
        if (table instanceof SybaseASATable) {
            statement = new StringBuffer();
            sybaseASATable = (SybaseASATable)table;
            if (sybaseASATable.getPctfree() != -1) {
                statement.append("PCTFREE");
                statement.append(" ");
                statement.append(sybaseASATable.getPctfree());
            }
        }
        if (table instanceof SybaseASATempTable) {
            statement = new StringBuffer();
            sybaseASATable = (SybaseASATempTable)table;
            if (sybaseASATable.getPctfree() != -1) {
                statement.append("PCTFREE");
                statement.append(" ");
                statement.append(sybaseASATable.getPctfree());
            }
        }
        if (statement == null) {
            return null;
        }
        return statement.toString();
    }

    protected String getAddUniqueConstraintClause(UniqueConstraint constraint, boolean quoteIdentifiers) {
        StringBuffer statement = new StringBuffer(128);
        String name = constraint.getName();
        if (name != null && name.trim().length() != 0) {
            if (quoteIdentifiers) {
                name = super.getDoubleQuotedString(name);
            }
            statement.append("CONSTRAINT").append(" ").append(name).append(" ");
        }
        statement.append(this.getUniqueConstraintType(constraint)).append(" ");
        SybaseASABasePrimaryKey primaryKey = null;
        if (constraint instanceof PrimaryKey && (primaryKey = (SybaseASABasePrimaryKey)constraint).isClustered()) {
            statement.append("CLUSTERED").append(" ");
        }
        String keyColumns = this.getKeyColumns((ReferenceConstraint)constraint, quoteIdentifiers);
        statement.append("(").append(keyColumns).append(")");
        return statement.toString();
    }

    protected String getKeyColumns(SybaseASAIndex index, boolean quoteIdentifiers) {
        Column c;
        IndexMember idxMember;
        StringBuffer statement = new StringBuffer(128);
        Iterator it = index.getMembers().iterator();
        if (it.hasNext()) {
            idxMember = (IndexMember)it.next();
            c = idxMember.getColumn();
            if (quoteIdentifiers) {
                statement.append(this.getDoubleQuotedString(c.getName()));
            } else {
                statement.append(c.getName());
            }
        } else {
            return null;
        }
        while (it.hasNext()) {
            idxMember = (IndexMember)it.next();
            c = idxMember.getColumn();
            if (quoteIdentifiers) {
                statement.append(",").append(" ").append(this.getDoubleQuotedString(c.getName()));
                continue;
            }
            statement.append(",").append(" ").append(c.getName());
        }
        return statement.toString();
    }

    public String getEventSchedules(SybaseASABaseEvent evt) {
        StringBuffer sb = new StringBuffer();
        EList schedules = evt.getSchedules();
        if (schedules.size() > 0) {
            sb.append("SCHEDULE").append(" ");
        }
        Iterator iter = schedules.iterator();
        while (iter.hasNext()) {
            Schedule schedule = (Schedule)iter.next();
            sb.append(this.getEventSchedule(schedule));
        }
        return sb.toString();
    }

    public String getEventSchedule(Schedule schedule) {
        boolean recurring;
        StringBuffer sb = new StringBuffer();
        String name = schedule.getName();
        Date startDate = schedule.getStartDate();
        Date startTime = schedule.getStartTime();
        Date stopTime = schedule.getStopTime();
        int daysOfWeek = schedule.getDaysOfWeek();
        int daysOfMonth = schedule.getDaysOfMonth();
        if (name != null) {
            sb.append(name).append(" ");
        }
        if (startTime != null) {
            if (stopTime != null) {
                sb.append("BETWEEN").append(" ").append("'").append(this.toTimeString(startTime)).append("'").append(" ");
                sb.append("AND").append(" ").append("'").append(this.toTimeString(stopTime)).append("'").append(" ");
            } else {
                sb.append("START").append(" ").append("TIME").append(" ").append("'").append(this.toTimeString(startTime)).append("'").append(" ");
            }
        }
        if (recurring = schedule.isRecurring()) {
            sb.append("EVERY").append(" ").append(schedule.getIntervalMount()).append(" ").append(schedule.getIntervalUnit().getLiteral()).append(" ");
        }
        if (daysOfWeek > 0) {
            sb.append("ON").append(" ").append("(").append(this.parseDaysOfWeek(daysOfWeek)).append(")").append(" ");
        } else if (daysOfMonth != 0) {
            sb.append("ON").append(" ").append("(").append(this.parseDaysOfMonth(daysOfMonth)).append(")").append(" ");
        }
        if (startDate != null) {
            sb.append("START").append(" ").append("DATE").append(" ").append("'").append(this.toDateString(startDate)).append("'").append(" ");
        }
        return sb.toString();
    }

    public String parseDaysOfWeek(int daysOfWeek) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 7; ++i) {
            if ((daysOfWeek & 1 << i) <= 0) continue;
            sb.append("'").append(DAYS_OF_WEEK[i]).append("'").append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String parseDaysOfMonth(int daysOfMonth) {
        StringBuffer sb = new StringBuffer();
        if ((daysOfMonth & Integer.MIN_VALUE) != 0) {
            sb.append(0).append(",");
        }
        for (int i = 0; i < 31; ++i) {
            if ((daysOfMonth & 1 << i) == 0) continue;
            sb.append(i + 1).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    protected String toDateString(Date date) {
        if (date != null) {
            return DateFormat.getDateInstance((int)2).format(date);
        }
        return "";
    }

    protected String toTimeString(Date time) {
        if (time != null) {
            return DateFormat.getTimeInstance((int)3).format(time);
        }
        return "";
    }

    private StringBuffer dropConstraint(TableConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = new StringBuffer(128);
        statement.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames)).append(" ");
        statement.append("DROP").append(" ");
        if (constraint instanceof PrimaryKey) {
            statement.append("PRIMARY KEY");
        } else if (constraint instanceof CheckConstraint) {
            statement.append("CHECK");
        } else if (constraint instanceof ForeignKey) {
            statement.append("FOREIGN KEY");
        } else if (constraint instanceof UniqueConstraint) {
            statement.append("UNIQUE");
        }
        return statement;
    }

    protected String getName(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = trigger.getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        return name;
    }
}

