/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.baseloaders.TableASABaseLoader;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseViewTable;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementDefault;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementsFactory;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;

public class SybaseASABaseViewTableLoader
extends TableASABaseLoader {
    protected SybaseASABaseViewTable viewTable;

    public SybaseASABaseViewTableLoader(SybaseASABaseViewTable catalogTable) {
        super((Table)catalogTable);
        this.viewTable = catalogTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadViewInfo() {
        boolean deliver = this.viewTable.eDeliver();
        this.viewTable.eSetDeliver(false);
        Connection conn = this.catalogObj.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT T.source, T.view_def, T.remarks FROM SYS.SYSTABLE T JOIN SYS.SYSUSERPERMS U ON T.creator = U.user_id WHERE T.table_type = 'VIEW' AND U.user_name like ? AND T.table_name like ?");
            stmt.setString(1, this.viewTable.getSchema().getName());
            stmt.setString(2, this.viewTable.getName());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String source = rs.getString(1);
                String defn = rs.getString(2);
                String remarks = rs.getString(3);
                String viewText = source != null ? source : defn;
                SQLStatementDefault statement = SQLStatementsFactory.eINSTANCE.createSQLStatementDefault();
                statement.setSQL(viewText);
                this.viewTable.setStatement((SQLStatement)statement);
                this.viewTable.setDescription(remarks);
                SybaseASACatalogUtils.parseView((ViewTable)this.viewTable, viewText);
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        catch (SQLException e) {
            JDBCASAPlugin.getDefault().log(e);
        }
        finally {
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        this.viewTable.eSetDeliver(deliver);
    }

    protected void processTableInfoResultSet(ResultSet rs) {
    }
}

