/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SQLScriptsProvider;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;

public class SybaseASABaseForeignKeyLoader {
    protected SybaseASABaseForeignKey fk;
    protected Connection conn;
    protected ICatalogObject catalogObj;

    public SybaseASABaseForeignKeyLoader(SybaseASABaseForeignKey catalogFK) {
        this.fk = catalogFK;
        this.catalogObj = (ICatalogObject)catalogFK;
        this.conn = this.catalogObj.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadFKInfo(EList memberContainmentList, EList refMemContainmentList) {
        boolean deliver = this.fk.eDeliver();
        this.fk.eSetDeliver(false);
        SybaseASABaseDatabase db = (SybaseASABaseDatabase)this.catalogObj.getCatalogDatabase();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            BaseTable table = this.fk.getBaseTable();
            String schemaName = table.getSchema().getName();
            String tableName = table.getName();
            stmt = this.conn.prepareStatement(SQLScriptsProvider.getQueryForeignKeyInfo((Database)db));
            stmt.setString(1, schemaName);
            stmt.setString(2, tableName);
            stmt.setString(3, this.fk.getName());
            rs = stmt.executeQuery();
            while (rs.next()) {
                this.processFKInfoResultSet(rs, memberContainmentList, refMemContainmentList);
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        catch (SQLException e) {
            JDBCASAPlugin.getDefault().log(e);
        }
        finally {
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        this.fk.eSetDeliver(deliver);
    }

    protected void processFKInfoResultSet(ResultSet rs, EList memberContainmentList, EList refMemContainmentList) throws SQLException {
        String primaryTableName = rs.getString(5);
        String primaryTableOwner = rs.getString(6);
        String foreignColListStr = rs.getString(2);
        String primaryColListStr = rs.getString(7);
        char updateActinChar = SybaseASACatalogUtils.getCharValue(rs.getString(8));
        char deleteActinChar = SybaseASACatalogUtils.getCharValue(rs.getString(9));
        boolean isClustered = rs.getString(3).equals("Y");
        String remarks = rs.getString(4);
        Schema primarySchema = (Schema)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getSchemas(), primaryTableOwner);
        Table primaryTable = (Table)SybaseASACatalogUtils.findElement((Collection)primarySchema.getTables(), primaryTableName);
        List primaryColumnList = SybaseASACatalogUtils.getSpecifiedColumns(primaryColListStr, (Collection)primaryTable.getColumns());
        List foreignColumnList = SybaseASACatalogUtils.getSpecifiedColumns(foreignColListStr, (Collection)this.fk.getBaseTable().getColumns());
        memberContainmentList.clear();
        memberContainmentList.addAll((Collection)foreignColumnList);
        refMemContainmentList.clear();
        refMemContainmentList.addAll((Collection)primaryColumnList);
        this.fk.setOnUpdate(this.getReferentialActionType(updateActinChar));
        this.fk.setOnDelete(this.getReferentialActionType(deleteActinChar));
        this.fk.setClustered(isClustered);
        this.fk.setDescription(remarks);
        this.fk.setUniqueConstraint(this.findUniqueConstraint(primaryColumnList, primaryTable));
        this.fk.setRoleName(this.fk.getName());
        this.fk.setReferencedTable((BaseTable)primaryTable);
    }

    protected ReferentialActionType getReferentialActionType(char typeChar) {
        ReferentialActionType result = null;
        switch (typeChar) {
            case '\u0000': {
                result = ReferentialActionType.RESTRICT_LITERAL;
                break;
            }
            case 'C': {
                result = ReferentialActionType.CASCADE_LITERAL;
                break;
            }
            case 'N': {
                result = ReferentialActionType.SET_NULL_LITERAL;
                break;
            }
            case 'D': {
                result = ReferentialActionType.SET_DEFAULT_LITERAL;
            }
        }
        return result;
    }

    protected UniqueConstraint findUniqueConstraint(List primaryColumnList, Table primaryTable) {
        UniqueConstraint result = null;
        EList constraints = ((BaseTable)primaryTable).getConstraints();
        for (int i = 0; i < constraints.size(); ++i) {
            UniqueConstraint uc;
            EList members;
            TableConstraint constraint = (TableConstraint)constraints.get(i);
            if (!(constraint instanceof PrimaryKey) && !(constraint instanceof UniqueConstraint) || (members = (uc = (UniqueConstraint)constraint).getMembers()).size() != primaryColumnList.size()) continue;
            boolean found = true;
            for (int j = 0; j < primaryColumnList.size(); ++j) {
                if (members.contains(primaryColumnList.get(j))) continue;
                found = false;
                break;
            }
            if (!found) continue;
            result = uc;
            break;
        }
        return result;
    }
}

