/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCRoutineLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCUserDefinedTypeLoader;
import org.eclipse.datatools.connectivity.sqm.loader.SchemaObjectFilterProvider;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseProcedure;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseProxyTable;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseRemoteProcedure;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseTable;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseTempTable;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseUserDefinedDataType;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseUserDefinedFunction;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseViewTable;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SQLScriptsProvider;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;

public class SchemaASABaseLoader {
    protected ICatalogObject catalogObj;
    protected Schema schema;
    private SoftReference tableLoaderRef;
    private SoftReference routineLoaderRef;
    private SoftReference UDTLoaderRef;

    public SchemaASABaseLoader(Schema catalogSchema) {
        this.catalogObj = (ICatalogObject)catalogSchema;
        this.schema = catalogSchema;
    }

    public final void loadTables(EList tableConstainmentList) {
        try {
            boolean deliver = this.schema.eDeliver();
            this.schema.eSetDeliver(false);
            ArrayList existingTables = new ArrayList(tableConstainmentList.size());
            existingTables.addAll(tableConstainmentList);
            this.getTableLoader().clearTables((List)tableConstainmentList);
            this.getTableLoader().loadTables((List)tableConstainmentList, existingTables);
            this.schema.eSetDeliver(deliver);
        }
        catch (Exception e) {
            JDBCASAPlugin.getDefault().log(e);
        }
    }

    public final void loadRoutines(EList routineContainmentList) {
        try {
            boolean deliver = this.schema.eDeliver();
            this.schema.eSetDeliver(false);
            ArrayList existingRoutines = new ArrayList(routineContainmentList.size());
            existingRoutines.addAll(routineContainmentList);
            this.getRoutineLoader().clearRoutines((List)routineContainmentList);
            this.getRoutineLoader().loadRoutines((List)routineContainmentList, existingRoutines);
            this.schema.eSetDeliver(deliver);
        }
        catch (Exception e) {
            JDBCASAPlugin.getDefault().log(e);
        }
    }

    public final void loadUDTs(EList udtContainmentList) {
        try {
            boolean deliver = this.schema.eDeliver();
            this.schema.eSetDeliver(false);
            ArrayList existingUDTs = new ArrayList(udtContainmentList.size());
            existingUDTs.addAll(udtContainmentList);
            this.getUDTLoader().clearUDTs((List)udtContainmentList);
            this.getUDTLoader().loadUDTs((List)udtContainmentList, existingUDTs);
            this.schema.eSetDeliver(deliver);
        }
        catch (Exception e) {
            JDBCASAPlugin.getDefault().log(e);
        }
    }

    protected JDBCTableLoader createTableLoader() {
        return new ASABaseTableLoader(this.catalogObj);
    }

    private JDBCTableLoader getTableLoader() {
        if (this.tableLoaderRef == null || this.tableLoaderRef.get() == null) {
            this.tableLoaderRef = new SoftReference<JDBCTableLoader>(this.createTableLoader());
        }
        return (JDBCTableLoader)this.tableLoaderRef.get();
    }

    protected JDBCRoutineLoader createRoutineLoader() {
        return new ASABaseRoutineLoader(this.catalogObj);
    }

    private JDBCRoutineLoader getRoutineLoader() {
        if (this.routineLoaderRef == null || this.routineLoaderRef.get() == null) {
            this.routineLoaderRef = new SoftReference<JDBCRoutineLoader>(this.createRoutineLoader());
        }
        return (JDBCRoutineLoader)this.routineLoaderRef.get();
    }

    protected JDBCUserDefinedTypeLoader createUDTLoader() {
        return new ASABaseUDTLoader(this.catalogObj);
    }

    private JDBCUserDefinedTypeLoader getUDTLoader() {
        if (this.UDTLoaderRef == null || this.UDTLoaderRef.get() == null) {
            this.UDTLoaderRef = new SoftReference<JDBCUserDefinedTypeLoader>(this.createUDTLoader());
        }
        return (JDBCUserDefinedTypeLoader)this.UDTLoaderRef.get();
    }

    public static class ASABaseUDTLoader
    extends JDBCUserDefinedTypeLoader {
        public ASABaseUDTLoader(ICatalogObject catalogObj) {
            super(catalogObj, (IConnectionFilterProvider)new SchemaObjectFilterProvider("DatatoolsUDTFilterPredicate"), (JDBCUserDefinedTypeLoader.IUDTFactory)new ASAUDTFactory(RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(catalogObj.getCatalogDatabase())), null, null);
        }

        protected ResultSet createResultSet() throws SQLException {
            Schema schema = this.getSchema();
            PreparedStatement stmt = this.getCatalogObject().getConnection().prepareStatement("select 2001 as 'DATA_TYPE', TRIM(type_name) as 'TYPE_NAME' from sys.sysusertype where creator=suser_id(?)");
            stmt.setString(1, schema.getName());
            return stmt.executeQuery();
        }

        public static class ASAUDTFactory
        extends JDBCUserDefinedTypeLoader.DistinctTypeFactory {
            public ASAUDTFactory(DatabaseDefinition databaseDefinition) {
                super(databaseDefinition);
            }

            protected UserDefinedType newUDT() {
                return new SybaseASACatalogBaseUserDefinedDataType();
            }

            public void initialize(UserDefinedType udt, ResultSet rs) throws SQLException {
                String udtName = rs.getString("TYPE_NAME");
                udt.setName(udtName);
            }
        }
    }

    public static class ASABaseRoutineLoader
    extends JDBCRoutineLoader {
        public static final String REMOTE_SERVER = "REMOTE SERVER";

        public ASABaseRoutineLoader(ICatalogObject catalogObj) {
            super(catalogObj, (IConnectionFilterProvider)new SchemaObjectFilterProvider("DatatoolsSPFilterPredicate"), (JDBCRoutineLoader.IRoutineFactory)new ASAUseDefinedFunctionFactory(), (JDBCRoutineLoader.IRoutineFactory)new ASAProcedureFactory());
        }

        protected ResultSet createResultSet() throws SQLException {
            Schema schema = this.getSchema();
            SybaseASABaseDatabase db = (SybaseASABaseDatabase)((ICatalogObject)schema).getCatalogDatabase();
            PreparedStatement stmt = this.getCatalogObject().getConnection().prepareStatement(SQLScriptsProvider.getQueryRoutines((Database)db));
            stmt.setString(1, schema.getName());
            return stmt.executeQuery();
        }

        public static class ASAUseDefinedFunctionFactory
        extends JDBCRoutineLoader.ProcedureFactory {
            protected Routine newRoutine() {
                return new SybaseASACatalogBaseUserDefinedFunction();
            }

            public void initialize(Routine routine, ResultSet rs) throws SQLException {
                routine.setName(rs.getString("PROCEDURE_NAME"));
            }
        }

        public static class ASAProcedureFactory
        extends JDBCRoutineLoader.ProcedureFactory {
            public Routine createRoutine(ResultSet rs) throws SQLException {
                Object retVal = this.newRoutine();
                String remoteSrv = rs.getString(ASABaseRoutineLoader.REMOTE_SERVER);
                retVal = remoteSrv != null ? new SybaseASACatalogBaseRemoteProcedure() : new SybaseASACatalogBaseProcedure();
                this.initialize((Routine)retVal, rs);
                return retVal;
            }

            public void initialize(Routine routine, ResultSet rs) throws SQLException {
                routine.setName(rs.getString("PROCEDURE_NAME"));
            }
        }
    }

    public static class ASABaseTableLoader
    extends JDBCTableLoader {
        public static final String BASE_TABLE = "BASE";
        public static final String PROXY_TABLE = "PROXY TABLE";
        public static final String TABLE_VIEW = "VIEW";
        public static final String GLOBAL_TEMP_TABLE = "GBL TEMP";

        public ASABaseTableLoader(ICatalogObject catalogObject) {
            super(catalogObject);
            this.initTableFacotaries();
        }

        protected void initTableFacotaries() {
            super.registerTableFactory(BASE_TABLE, (JDBCTableLoader.ITableFactory)new ASABaseTableFactory());
            super.registerTableFactory(TABLE_VIEW, (JDBCTableLoader.ITableFactory)new ASABaseViewFactory());
            super.registerTableFactory(GLOBAL_TEMP_TABLE, (JDBCTableLoader.ITableFactory)new ASABaseGlobalTempTableFactory());
            super.registerTableFactory(PROXY_TABLE, (JDBCTableLoader.ITableFactory)new ASABaseProxyTableFactory());
        }

        protected ResultSet createResultSet() throws SQLException {
            Schema schema = this.getSchema();
            Connection conn = this.getCatalogObject().getConnection();
            PreparedStatement stmt = conn.prepareStatement("SELECT TRIM(T.table_name) as 'TABLE_NAME', if (T.existing_obj IS NOT NULL AND T.existing_obj = 'Y' ) THEN 'PROXY TABLE' ELSE  T.table_type  endif as 'TABLE_TYPE' FROM SYS.SYSTABLE T JOIN SYS.SYSUSERPERMS U ON U.user_id = T.creator where U.user_name = ? AND T.table_type<>'JVT' order by 1");
            stmt.setString(1, schema.getName());
            return stmt.executeQuery();
        }

        protected Table processRow(ResultSet rs) throws SQLException {
            String tableName = rs.getString("TABLE_NAME");
            if (tableName == null || this.isFiltered(tableName)) {
                return null;
            }
            String tableType = rs.getString("TABLE_TYPE");
            JDBCTableLoader.ITableFactory tableFactory = this.getTableFactory(tableType);
            Table table = tableFactory.createTable(rs);
            return table;
        }

        public static class ASABaseGlobalTempTableFactory
        extends JDBCTableLoader.TableFactory {
            protected Table newTable() {
                return new SybaseASACatalogBaseTempTable();
            }
        }

        public static class ASABaseProxyTableFactory
        extends JDBCTableLoader.TableFactory {
            protected Table newTable() {
                return new SybaseASACatalogBaseProxyTable();
            }
        }

        public static class ASABaseViewFactory
        extends JDBCTableLoader.TableFactory {
            protected Table newTable() {
                return new SybaseASACatalogBaseViewTable();
            }
        }

        public static class ASABaseTableFactory
        extends JDBCTableLoader.TableFactory {
            protected Table newTable() {
                return new SybaseASACatalogBaseTable();
            }
        }
    }
}

