/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SQLScriptsProvider;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDBSpace;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseIndex;
import org.eclipse.datatools.modelbase.sql.constraints.IncrementType;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsFactory;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;

public class IndexInfoASALoader {
    private SybaseASABaseIndex index;
    private Connection conn;
    private ICatalogObject catalogObj;

    public IndexInfoASALoader(SybaseASABaseIndex catalogIndex) {
        this.index = catalogIndex;
        this.catalogObj = (ICatalogObject)catalogIndex;
        this.conn = this.catalogObj.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadIndexInfo(List memberList) {
        boolean deliver = this.index.eDeliver();
        this.index.eSetDeliver(false);
        SybaseASABaseDatabase db = (SybaseASABaseDatabase)this.catalogObj.getCatalogDatabase();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Table table = this.index.getTable();
            String schemaName = table.getSchema().getName();
            String tableName = table.getName();
            stmt = this.conn.prepareStatement(SQLScriptsProvider.getQueryIndexInfo((Database)db));
            stmt.setString(1, schemaName);
            stmt.setString(2, tableName);
            stmt.setString(3, this.index.getName());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String strUnique;
                int intUnique;
                String dbspaceName = rs.getString(2);
                String colListStr = rs.getString(3);
                boolean isUnique = false;
                isUnique = db.isBaseOnASA10() ? (intUnique = rs.getInt(4)) != 4 : (strUnique = rs.getString(4)).equals("Y") || strUnique.equals("U");
                boolean isClustered = rs.getString(5).equals("Y");
                String remarks = rs.getString(6);
                String orderListStr = rs.getString(7);
                SybaseASABaseDBSpace dbspace = (SybaseASABaseDBSpace)SybaseASACatalogUtils.findElement((Collection)((SybaseASABaseDatabase)this.catalogObj.getCatalogDatabase()).getDbSpaces(), dbspaceName);
                this.index.setDbSpace(dbspace);
                List columnNameList = this.parseColumnList(colListStr);
                List orderList = this.parseOrderList(orderListStr);
                memberList.clear();
                for (int i = 0; i < columnNameList.size(); ++i) {
                    String colName = (String)columnNameList.get(i);
                    Column column = (Column)SybaseASACatalogUtils.findElement((Collection)table.getColumns(), colName);
                    if (column == null) continue;
                    IndexMember member = SQLConstraintsFactory.eINSTANCE.createIndexMember();
                    String order = ((String)orderList.get(i)).trim();
                    member.setColumn(column);
                    member.setIncrementType(order.equals("A") ? IncrementType.ASC_LITERAL : IncrementType.DESC_LITERAL);
                    memberList.add(member);
                }
                this.index.setUnique(isUnique);
                this.index.setClustered(isClustered);
                this.index.setDescription(remarks);
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        catch (SQLException e) {
            JDBCASAPlugin.getDefault().log(e);
        }
        finally {
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        this.index.eSetDeliver(deliver);
    }

    private List parseColumnList(String columnListStr) {
        ArrayList<String> results = new ArrayList<String>();
        int index = -1;
        while ((index = columnListStr.indexOf(" #$% ")) != -1) {
            String columnName = columnListStr.substring(0, index);
            results.add(columnName);
            columnListStr = columnListStr.substring(index + " #$% ".length());
        }
        results.add(columnListStr);
        return results;
    }

    private List parseOrderList(String orderListStr) {
        ArrayList<String> results = new ArrayList<String>();
        int index = -1;
        while ((index = orderListStr.indexOf(" , ")) != -1) {
            String columnName = orderListStr.substring(0, index);
            results.add(columnName);
            orderListStr = orderListStr.substring(index + " , ".length());
        }
        results.add(orderListStr);
        return results;
    }
}

