/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAProfileMessages;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPropertyWizardPage;
import org.eclipse.datatools.enablement.sybase.asa.MultiASAWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class NewJDBCASAConnectionProfileWizard
extends NewConnectionProfileWizard {
    protected JDBCASAPropertyWizardPage asaWizPage = null;
    protected MultiASAWizardPage mMultiPage;

    public NewJDBCASAConnectionProfileWizard() {
        this.setWindowTitle(JDBCASAProfileMessages.getString("NewConnectionProfileWizard.ASA.title"));
    }

    public void addCustomPages() {
        this.asaWizPage = new JDBCASAPropertyWizardPage("asaWizPage");
        this.addPage((IWizardPage)this.asaWizPage);
        this.mMultiPage = new MultiASAWizardPage("multiPage");
        this.addPage((IWizardPage)this.mMultiPage);
    }

    public Properties getProfileProperties() {
        Properties props = new Properties();
        props.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", this.asaWizPage.getDriverID());
        props.setProperty("org.eclipse.datatools.connectivity.db.connectionProperties", this.asaWizPage.getDBConnProps());
        props.setProperty("org.eclipse.datatools.connectivity.db.driverClass", this.asaWizPage.getDriverClass());
        props.setProperty("org.eclipse.datatools.connectivity.db.vendor", this.asaWizPage.getVendor());
        props.setProperty("org.eclipse.datatools.connectivity.db.version", this.asaWizPage.getVersion());
        props.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.asaWizPage.getDBName());
        props.setProperty("org.eclipse.datatools.connectivity.db.password", this.asaWizPage.getDBPWD());
        props.setProperty("org.eclipse.datatools.connectivity.db.username", this.asaWizPage.getDBUID());
        props.setProperty("org.eclipse.datatools.connectivity.db.URL", this.asaWizPage.getURL());
        props.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.asaWizPage.getSaveDBPWD()));
        props.setProperty("org.eclipse.datatools.enablement.sybase.multiDBIsSupported", "false");
        props.setProperty("org.eclipse.datatools.enablement.sybase.catalog", this.asaWizPage.getCatalog());
        props.setProperty("org.eclipse.datatools.enablement.sybase.schema", this.asaWizPage.getSchema());
        props.setProperty("org.eclipse.datatools.enablement.sybase.spName", this.asaWizPage.getProcName());
        props.setProperty("org.eclipse.datatools.enablement.sybase.host", this.asaWizPage.getHost());
        props.setProperty("org.eclipse.datatools.enablement.sybase.port", this.asaWizPage.getPort());
        String xaConnectClass = this.asaWizPage.getXAConnectClass();
        if (xaConnectClass != null && xaConnectClass.trim().length() > 0) {
            props.setProperty("org.eclipse.datatools.enablement.sybase.xaConnectClass", xaConnectClass);
        }
        return props;
    }

    public boolean performFinish() {
        boolean success = false;
        String[] dbnames = this.mMultiPage.getDBNames();
        if (dbnames == null || dbnames.length == 0) {
            return super.performFinish();
        }
        Properties props = this.getProfileProperties();
        String dbname = props.getProperty("org.eclipse.datatools.enablement.sybase.dbName");
        if ((dbname == null || dbname.length() == 0) && dbnames != null && dbnames.length > 0) {
            List<String> names = Arrays.asList(dbnames);
            String host = props.getProperty("org.eclipse.datatools.enablement.sybase.host");
            String port = props.getProperty("org.eclipse.datatools.enablement.sybase.port");
            for (int i = 0; i < names.size(); ++i) {
                String iter_dbname = names.get(i);
                String updatedUrl = JDBCASAPlugin.makeDriverURL(host, port, iter_dbname);
                props.setProperty("org.eclipse.datatools.enablement.sybase.dbName", iter_dbname);
                props.setProperty("org.eclipse.datatools.connectivity.db.databaseName", iter_dbname);
                props.setProperty("org.eclipse.datatools.connectivity.db.URL", updatedUrl);
                IConnectionProfile nf = ProfileManager.getInstance().getProfileByName(this.mProfilePage.getProfileName() + "." + iter_dbname);
                if (nf != null) {
                    if (!MessageDialog.openQuestion(null, (String)JDBCASAProfileMessages.getString("NewConnectionProfileWizard.confirmation.title"), (String)JDBCASAProfileMessages.format("NewConnectionProfileWizard.confirmation.msg", new String[]{this.mProfilePage.getProfileName(), iter_dbname}))) {
                        return false;
                    }
                    try {
                        ProfileManager.getInstance().deleteProfile(nf);
                    }
                    catch (ConnectionProfileException e) {
                        ExceptionHandler.showException((Shell)this.getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizard.create.failure"), (String)e.getLocalizedMessage(), (Throwable)e);
                        return false;
                    }
                }
                try {
                    ProfileManager.getInstance().createProfile(this.mProfilePage.getProfileName() + "." + iter_dbname, this.mProfilePage.getProfileDescription(), this.mProviderID, props, this.getParentProfile(), this.mProfilePage.getAutoConnect());
                    if (!this.mProfilePage.getAutoConnect() || ProfileManager.getInstance().getProfileByName(this.mProfilePage.getProfileName() + "." + iter_dbname) == null) continue;
                    ProfileManager.getInstance().getProfileByName(this.mProfilePage.getProfileName() + "." + iter_dbname).connect(null);
                    continue;
                }
                catch (ConnectionProfileException e) {
                    ExceptionHandler.showException((Shell)this.getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizard.create.failure"), (String)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            }
            success = true;
        }
        return success;
    }
}

