/*******************************************************************************
 * Copyright (c) 2005 -- 2007 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.sybase.asa.ui;

import java.util.Properties;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.db.generic.GenericDBPlugin;
import org.eclipse.datatools.connectivity.db.generic.IDBConnectionProfileConstants;
import org.eclipse.datatools.connectivity.db.generic.IDBDriverDefinitionConstants;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.internal.ui.DelimitedStringList;
import org.eclipse.datatools.enablement.sybase.IJDBCConnectionProfileConstants;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAProfileMessages;
import org.eclipse.datatools.enablement.sybase.ui.JDBCProfileTabs;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;


/**
 * @author brianf
 *
 */
public class JDBCASAProfileTabs extends JDBCProfileTabs {
	
	// new fields for ASA/ASIQ for host, port, and dbname
	protected Text mHostText;
	protected Text mPortText;
	protected Text mDatabaseText;
	protected Button mSaveDBPWDCheckbox;
	
	private boolean _isPropertyPage = false;
	
	public void setIsPropertyPage( boolean flag ) {
		this._isPropertyPage = flag;
	}
	
	public boolean isPropertyPage() {
		return this._isPropertyPage;
	}

	/* (non-Javadoc)
	 * @see com.sybase.stf.servers.sample.jdbc.ui.JDBCProfileTabs#createConnectionTab(org.eclipse.swt.widgets.TabFolder)
	 */
	protected void createConnectionTab(TabFolder parent) {
		connTabComposite = new Composite(parent, SWT.NONE);
		
		GridLayout layout = new GridLayout(2,false);
		connTabComposite.setLayout(layout);
		
		this.combo.setLabelText(JDBCASAProfileMessages.getString("JDBCPropertyWizardPage.driverCombo.label")); //$NON-NLS-1$
		this.combo.setCategory(getCategory());
		this.combo.setNullDriverIsValid(false);
		this.combo.createContents(connTabComposite);//connTabComposite);
		if (this.combo.getErrorMessage() != null) {
			setErrorMessage(this.combo.getErrorMessage());
		}
		
		this.mHostText = (Text) createLabelTextPair (connTabComposite, 
				JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.hostName.label"),  //$NON-NLS-1$
				this.mHostText, SWT.BORDER, GridData.FILL_HORIZONTAL);
		this.mHostText.addModifyListener( new ModifyListener() {

			public void modifyText(ModifyEvent e) {
				fireChangedEvent(JDBCASAProfileTabs.this);
			}
		});

		this.mPortText = (Text) createLabelTextPair (connTabComposite, 
				JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.portNumber.label"),  //$NON-NLS-1$
				this.mPortText, SWT.BORDER, GridData.FILL_HORIZONTAL);
		this.mPortText.addModifyListener( new ModifyListener() {

			public void modifyText(ModifyEvent e) {
				fireChangedEvent(JDBCASAProfileTabs.this);
			}
		});

		this.mDatabaseText = (Text) createLabelTextPair (connTabComposite, 
				JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.databaseName.label"),  //$NON-NLS-1$
				this.mPortText, SWT.BORDER, GridData.FILL_HORIZONTAL);
		this.mDatabaseText.addModifyListener( new ModifyListener() {

			public void modifyText(ModifyEvent e) {
				fireChangedEvent(JDBCASAProfileTabs.this);
			}
		});

		this.mDBUIDText = (Text) createLabelTextPair (connTabComposite, 
				JDBCASAProfileMessages.getString("JDBCPropertyWizardPage.userName.label"),  //$NON-NLS-1$ 
				this.mDBUIDText, SWT.BORDER, GridData.FILL_HORIZONTAL);
		this.mDBUIDText.addModifyListener( new ModifyListener() {

			public void modifyText(ModifyEvent e) {
				fireChangedEvent(JDBCASAProfileTabs.this);
			}
		});

		this.mDBPWDText = (Text) createLabelTextPair (connTabComposite, 
				JDBCASAProfileMessages.getString("JDBCPropertyWizardPage.password.label"),  //$NON-NLS-1$, 
				this.mDBPWDText, SWT.BORDER, GridData.FILL_HORIZONTAL);
		this.mDBPWDText.setEchoChar('*');
		this.mDBPWDText.addModifyListener( new ModifyListener() {

			public void modifyText(ModifyEvent e) {
				fireChangedEvent(JDBCASAProfileTabs.this);
			}
		});

		this.mSaveDBPWDCheckbox = new Button(connTabComposite, SWT.CHECK);
		this.mSaveDBPWDCheckbox.setText(GenericDBPlugin.getDefault()
				.getResourceString(
						"GenericDBProfileDetailsWizardPage.persistpassword.label")); //$NON-NLS-1$
		this.mSaveDBPWDCheckbox.setLayoutData(new GridData(GridData.BEGINNING,
				GridData.CENTER, true, false, 2, 1));

		comboListener = new ChangeListener() {
			public void stateChanged(ChangeEvent arg0) {
				JDBCASAProfileTabs.this.driverStateChanged();
			}
		};
		this.combo.addChangeListener( comboListener );
	}

    protected String getCategory()
    {
        return "org.eclipse.datatools.enablement.sybase.asa.category"; //$NON-NLS-1$
    }

	//cr400484 add most frequency used common properties into add field
	protected void createOtherTab ( TabFolder parent ) {
		otherTabComposite = new Composite ( parent, SWT.NONE );
		
		GridLayout layout = new GridLayout(2,false);
		otherTabComposite.setLayout(layout);
	
		this.mDBConnProps = new DelimitedStringList(otherTabComposite, SWT.NONE );
		
//		((DelimitedStringList4ASA)mDBConnProps).initAddCombo(getCommonConnProperties());
//		
		GridData gdata = new GridData(GridData.FILL_HORIZONTAL);
		gdata.horizontalSpan = 2;
		((DelimitedStringList)this.mDBConnProps).setLayoutData(gdata);
        
		this.mDBConnProps.addChangeListener( new ChangeListener() {

			public void stateChanged(ChangeEvent arg0) {
				setErrorMessage(null);
				if (mDBConnProps.getWarning() != null) {
					setErrorMessage(mDBConnProps.getWarning());
				}
			}
			
		});
	}

	/*
	 * Get common connection properties for ASA/ASE/ASIQ 
	 */
	public String[] getCommonConnProperties(){
		return JDBCASAProfileMessages.getString("JDBCASAProfileTabs.otherPropertiesTab.commonOptions").split(","); //$NON-NLS-1$ //$NON-NLS-2$
	}

	
	/* (non-Javadoc)
	 * @see com.sybase.stf.servers.sample.jdbc.ui.JDBCProfileTabs#collectProperties()
	 */
	protected Properties collectProperties() {
		Properties props = super.collectProperties();
        String host = EMPTY_STRING;
        String port = EMPTY_STRING;
        String dbName = EMPTY_STRING;
        String xaConnectClass = EMPTY_STRING;

        if (this.combo.getSelectedDriverInstance() != null) {
        	DriverInstance instance = this.combo.getSelectedDriverInstance();
            xaConnectClass = instance.getNamedProperty("xaConnectClass"); //$NON-NLS-1$
        }

        if (this.mPortText.getText() != null) {
        	port = this.mPortText.getText();
        }
        if (this.mHostText.getText() != null) {
        	host = this.mHostText.getText();
        }
        if (this.mDatabaseText.getText() != null) {
        	dbName = this.mDatabaseText.getText();
        }
		String driverURL = getURL();
//		String driverURL = JDBCASAProfilePlugin.makeDriverURL(host, port, ""); //$NON-NLS-1$
		props.setProperty(IDBDriverDefinitionConstants.URL_PROP_ID,
	      		driverURL);
	
		props.setProperty(IJDBCConnectionProfileConstants.PROP_HOST, host);
		props.setProperty(IJDBCConnectionProfileConstants.PROP_PORT, port);
		props.setProperty(IDBDriverDefinitionConstants.DATABASE_NAME_PROP_ID, dbName);
	
		if (xaConnectClass != null && xaConnectClass.trim().length() > 0) 
			props.setProperty(IJDBCConnectionProfileConstants.PROP_DRIVER_XACONNECTCLASS, 
			xaConnectClass);

		props.setProperty(
				IDBConnectionProfileConstants.SAVE_PASSWORD_PROP_ID, String
						.valueOf(this.mSaveDBPWDCheckbox.getSelection()));

		return props;
	}

	/* (non-Javadoc)
	 * @see com.sybase.stf.servers.sample.jdbc.ui.JDBCProfileTabs#initControls()
	 */
	protected void initControls() {
		
		IConnectionProfile profile = getConnectionProfile();
        String providerId = this.getProviderID();
        if (profile != null)
        	providerId = profile.getProviderId();
		if (providerId != null) {
    		this.combo.setFilter(getFilter());
	        this.combo.refreshCombo();
		}

		if (isPropertyPage()) {
			super.setResetPwdFromDriver(false);
		}
		super.initControls();

        if (profile != null && this.mHostText != null && this.mPortText != null) {
			String host = profile.getBaseProperties().getProperty(IJDBCConnectionProfileConstants.PROP_HOST);
	        if (host != null) {
	        	this.mHostText.setText(host);
	        }

	        String port = profile.getBaseProperties().getProperty(IJDBCConnectionProfileConstants.PROP_PORT);
	        if (port != null) {
	        	this.mPortText.setText(port);
	        }

	        String dbName = profile.getBaseProperties().getProperty(IDBDriverDefinitionConstants.DATABASE_NAME_PROP_ID);
	        if (dbName != null) {
	        	this.mDatabaseText.setText(dbName);
	        }

			this.mSaveDBPWDCheckbox.setSelection(Boolean.valueOf(
					profile.getBaseProperties().getProperty(
							IDBConnectionProfileConstants.SAVE_PASSWORD_PROP_ID,
							Boolean.FALSE.toString())).booleanValue());
        }
        
		super.setResetPwdFromDriver(true);
	}

	protected String getFilter() {
		return "templateID = org.eclipse.datatools.enablement.sybase.asa.drivertemplate"; //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see com.sybase.stf.servers.sample.jdbc.ui.JDBCProfileTabs#driverStateChanged()
	 */
	protected void driverStateChanged() {
		super.driverStateChanged();

		if (this.mHostText != null && this.mPortText != null) {
			String host =  this.getNamedPropertyFromDriverInstance("host"); //$NON-NLS-1$
			if (host == null || host.trim().length() == 0) host = "";//$NON-NLS-1$
			String oldHost = this.mHostText.getText();
			if (oldHost == null || oldHost.trim().length() == 0) oldHost = "";//$NON-NLS-1$
			if (oldHost.length() == 0)
				this.mHostText.setText(host);
	
			String port =  this.getNamedPropertyFromDriverInstance("port"); //$NON-NLS-1$
			if (port == null || port.trim().length() == 0) port = "";//$NON-NLS-1$
			String oldport = this.mPortText.getText();
			if (oldport == null || oldport.trim().length() == 0) oldport = "";//$NON-NLS-1$
			if (oldport.length() == 0)
				this.mPortText.setText(port);

			String dbname =  this.getNamedPropertyFromDriverInstance("Database Name"); //$NON-NLS-1$
			if (dbname == null || dbname.trim().length() == 0) dbname = "";//$NON-NLS-1$
			String olddbname = this.mDatabaseText.getText();
			if (olddbname == null || olddbname.trim().length() == 0) olddbname = "";//$NON-NLS-1$
			if (olddbname.length() == 0)
				this.mDatabaseText.setText(dbname);
		}
	}

    /* (non-Javadoc)
     * @see com.sybase.stf.common.ui.dialogs.IDialogPage#isValid()
     */
    public boolean isValid() {
    	boolean isUIDOK = this.mDBUIDText != null && this.mDBUIDText.getText().trim().length() > 0;
    	boolean isHostOK = this.mHostText != null && this.mHostText.getText().trim().length() > 0;
    	boolean isPortOK = this.mPortText != null && this.mPortText.getText().trim().length() > 0;
    	boolean isPortValid = true;
    	if (isPortOK ) {
    		try {
    			Integer.valueOf(this.mPortText.getText());
    		} catch (NumberFormatException ex) {
    			isPortValid = false;
    		}
    	}
    	boolean isDriverOK = this.combo.getErrorMessage() == null;
    	if (isUIDOK && isDriverOK && isHostOK && isPortOK && isPortValid ) 
    		return true;
    	else {
    		if (!isDriverOK) {
    			this.setErrorMessage(combo.getErrorMessage());
    		}
    		else if (!isUIDOK) {
    			this.setErrorMessage(JDBCASAProfileMessages.getString("JDBCProfileTabs.errors.requiredUID"));//$NON-NLS-1$
    		}
    		else if (!isHostOK) {
    			this.setErrorMessage(JDBCASAProfileMessages.getString("JDBCASAProfileTabs.errors.requiredHost"));//$NON-NLS-1$
    		}
    		else if (!isPortOK) {
    			this.setErrorMessage(JDBCASAProfileMessages.getString("JDBCASAProfileTabs.errors.requiredPort"));//$NON-NLS-1$
    		}
    		else if (!isPortValid) {
    			this.setErrorMessage(JDBCASAProfileMessages.getString("JDBCASAProfileTabs.errors.requiredPortValidNumber"));//$NON-NLS-1$
    		}
    	}
    	return false;
    }

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#dispose()
	 */
	public void dispose() {
		this.combo.removeChangeListener(this.comboListener);
//		this.combo.dispose();
		super.dispose();
	}

	/**
	 * @return
	 */
	public String getHostName() {
		return this.mHostText.getText();
	}

	/**
	 * @return
	 */
	public String getPortName() {
		return this.mPortText.getText();
	}
	
	/**
	 * @return
	 */
	public String getDBName() {
		return this.mDatabaseText.getText();
	}
	
	/* (non-Javadoc)
	 * @see com.sybase.stf.servers.sample.jdbc.ui.JDBCProfileTabs#getURL()
	 */
	public String getURL() {
        String host = EMPTY_STRING;
        String port = EMPTY_STRING;
        String dbName = EMPTY_STRING;
        if (this.mPortText.getText() != null) {
        	port = this.mPortText.getText();
        }
        if (this.mHostText.getText() != null) {
        	host = this.mHostText.getText();
        }
        if (this.mDatabaseText.getText() != null) {
        	dbName = this.mDatabaseText.getText();
        }
		String driverURL = JDBCASAPlugin.makeDriverURL(host, port, dbName);
		return driverURL;
	}

	public boolean getSaveDBPWD() {
		return this.mSaveDBPWDCheckbox.getSelection();
	}
}
