package org.eclipse.datatools.enablement.sybase.asa.base.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;

import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.sybase.asa.baseloaders.AuthorizationIdentifierASALoader;
import org.eclipse.datatools.modelbase.sql.accesscontrol.SQLAccessControlPackage;
import org.eclipse.datatools.modelbase.sql.accesscontrol.impl.AuthorizationIdentifierImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASACatalogBaseAuthorizationIdentifier extends AuthorizationIdentifierImpl implements ICatalogObject {

	private static final long serialVersionUID = 8486571493221764924L;
	
	private SybaseASACatalogBaseDatabase _database;
	protected Boolean privilegesLoaded = Boolean.FALSE;
	private SoftReference authIdLoaderRef;
	
	public SybaseASACatalogBaseAuthorizationIdentifier(SybaseASACatalogBaseDatabase database)
	{
		this._database = database;
	}
	
	public Database getCatalogDatabase() {
		return _database;
	}

	public Connection getConnection() {
		return _database.getConnection();
	}

	public void refresh() {
		synchronized (privilegesLoaded) {
			if(privilegesLoaded.booleanValue())
				privilegesLoaded = Boolean.FALSE;
		}
		RefreshManager.getInstance().referesh(this);
	}

	public boolean eIsSet(EStructuralFeature eFeature) {
		switch(eDerivedStructuralFeatureID(eFeature))
		{
		case SQLAccessControlPackage.AUTHORIZATION_IDENTIFIER__RECEIVED_PRIVILEGE:
			getReceivedPrivilege();
			break;
		case SQLAccessControlPackage.AUTHORIZATION_IDENTIFIER__DESCRIPTION:
			getDescription();
			break;
		}
		return super.eIsSet(eFeature);
	}
	
	public EList getReceivedPrivilege()
	{
		synchronized (privilegesLoaded) {
			if(!privilegesLoaded.booleanValue())
			{
				getAuthIdLoader().loadPrivilegs(super.getReceivedPrivilege());
				privilegesLoaded = Boolean.TRUE;
			}
		}
		return super.getReceivedPrivilege();
	}
	
	private AuthorizationIdentifierASALoader getAuthIdLoader()
	{
		AuthorizationIdentifierASALoader loader = authIdLoaderRef == null ? null
				: (AuthorizationIdentifierASALoader) authIdLoaderRef.get();
		
		if(loader == null)
		{
			loader = createAuthIdLoader();
			authIdLoaderRef = new SoftReference(loader);
		}
		
		return loader;
	}
	
	private AuthorizationIdentifierASALoader createAuthIdLoader()
	{
		return new AuthorizationIdentifierASALoader(this);
	}
}	