/*******************************************************************************
 * Copyright (c) 2004-2005 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: brianf - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.sybase.asa;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;

import org.eclipse.datatools.connectivity.ConnectionProfileConstants;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.db.generic.IDBConnectionProfileConstants;
import org.eclipse.datatools.connectivity.db.generic.IDBDriverDefinitionConstants;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.datatools.enablement.sybase.IJDBCConnectionProfileConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.Wizard;

/**
 * @see Wizard
 */
public class NewJDBCASAConnectionProfileWizard extends
		NewConnectionProfileWizard {

    protected JDBCASAPropertyWizardPage asaWizPage = null;
    protected MultiASAWizardPage mMultiPage;
	
	public NewJDBCASAConnectionProfileWizard() {
		setWindowTitle(JDBCASAProfileMessages.getString("NewConnectionProfileWizard.ASA.title")); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.datatools.connectivity.ui.wizards.NewJDBCASAConnectionProfileWizard#addCustomPages()
	 */
	public void addCustomPages() {
		asaWizPage = new JDBCASAPropertyWizardPage("asaWizPage"); //$NON-NLS-1$
		addPage(asaWizPage);

        mMultiPage = new MultiASAWizardPage("multiPage"); //$NON-NLS-1$
        addPage(mMultiPage);
	}

	public Properties getProfileProperties() {
		Properties props = new Properties();
		props.setProperty(ConnectionProfileConstants.PROP_DRIVER_DEFINITION_ID,
				this.asaWizPage.getDriverID());
		props.setProperty(
				IDBConnectionProfileConstants.CONNECTION_PROPERTIES_PROP_ID,
				this.asaWizPage.getDBConnProps());
		props.setProperty(IDBDriverDefinitionConstants.DRIVER_CLASS_PROP_ID, this.asaWizPage
				.getDriverClass());
		props.setProperty(IDBDriverDefinitionConstants.DATABASE_VENDOR_PROP_ID, this.asaWizPage
				.getVendor());		
		props.setProperty(IDBDriverDefinitionConstants.DATABASE_VERSION_PROP_ID, this.asaWizPage
				.getVersion());			
		props.setProperty(IDBDriverDefinitionConstants.DATABASE_NAME_PROP_ID, this.asaWizPage
				.getDBName());
		props.setProperty(IDBDriverDefinitionConstants.PASSWORD_PROP_ID, this.asaWizPage
				.getDBPWD());
		props.setProperty(IDBDriverDefinitionConstants.USERNAME_PROP_ID, this.asaWizPage
				.getDBUID());
		props.setProperty(IDBDriverDefinitionConstants.URL_PROP_ID,
				this.asaWizPage.getURL());
		
		props.setProperty(
				IDBConnectionProfileConstants.SAVE_PASSWORD_PROP_ID, String
						.valueOf(this.asaWizPage.getSaveDBPWD()));

		props.setProperty(IJDBCConnectionProfileConstants.PROP_MULTI_DB_IS_SUPPORTED,
       			"false"); //$NON-NLS-1$
		props.setProperty(IJDBCConnectionProfileConstants.PROP_CATALOG,
				this.asaWizPage.getCatalog());
		props.setProperty(IJDBCConnectionProfileConstants.PROP_SCHEMA,
				this.asaWizPage.getSchema());
		props.setProperty(IJDBCConnectionProfileConstants.PROP_SPNAME,
				this.asaWizPage.getProcName());
		props.setProperty(IJDBCConnectionProfileConstants.PROP_HOST,
				this.asaWizPage.getHost());
		props.setProperty(IJDBCConnectionProfileConstants.PROP_PORT,
				this.asaWizPage.getPort());
		
		String xaConnectClass = this.asaWizPage.getXAConnectClass();
		if (xaConnectClass != null && xaConnectClass.trim().length() > 0) 
		    props.setProperty(IJDBCConnectionProfileConstants.PROP_DRIVER_XACONNECTCLASS,
		    		xaConnectClass);

       	return props;
	}

	public boolean performFinish() {
		boolean success = false;
		String[] dbnames = mMultiPage.getDBNames();
		if (dbnames == null || dbnames.length == 0) {
			return super.performFinish();
		}
		Properties props = getProfileProperties();
		String dbname = props.getProperty(IJDBCConnectionProfileConstants.PROP_DB_NAME);
		if (dbname == null || dbname.length() == 0) {
			if (dbnames != null && dbnames.length > 0) {
				List names = Arrays.asList(dbnames);
				String host = props.getProperty(IJDBCConnectionProfileConstants.PROP_HOST);
				String port = props.getProperty(IJDBCConnectionProfileConstants.PROP_PORT);
				for (int i = 0; i < names.size(); i++) {
					String iter_dbname = (String) names.get(i);
					String updatedUrl = JDBCASAPlugin.makeDriverURL(host, port, iter_dbname);
					props.setProperty(IJDBCConnectionProfileConstants.PROP_DB_NAME, iter_dbname);
					props.setProperty(IDBConnectionProfileConstants.DATABASE_NAME_PROP_ID, iter_dbname);
					props.setProperty(IDBConnectionProfileConstants.URL_PROP_ID, updatedUrl);

					//cr 418870 handle duplicate name's connection profile creation
					IConnectionProfile nf=ProfileManager.getInstance().getProfileByName(mProfilePage.getProfileName() + "." + iter_dbname); //$NON-NLS-1$
					if (nf!=null){
						//confirmation 
						if (MessageDialog.openQuestion(
								null,JDBCASAProfileMessages.getString("NewConnectionProfileWizard.confirmation.title"), //$NON-NLS-1$
								JDBCASAProfileMessages.format("NewConnectionProfileWizard.confirmation.msg", new String[]{mProfilePage.getProfileName(),iter_dbname})			 //$NON-NLS-1$
								)     != true){
							return false;
						}
						
						//delete old same name's profile
						try {
							ProfileManager.getInstance().deleteProfile(nf);
						} 
						catch (ConnectionProfileException e) 
						{
							ExceptionHandler.showException(getShell(), ConnectivityUIPlugin
									.getDefault().getResourceString(
											"NewConnectionProfileWizard.create.failure"),  //$NON-NLS-1$
									e.getLocalizedMessage(), e);
							return false;	
						}
							
					}					
					
					
					try {
						ProfileManager.getInstance().createProfile(
								mProfilePage.getProfileName() + "." + iter_dbname, //$NON-NLS-1$
								mProfilePage.getProfileDescription(), mProviderID,
								props, getParentProfile(),
								mProfilePage.getAutoConnect());
						
						if (mProfilePage.getAutoConnect()) {
							if (ProfileManager.getInstance().getProfileByName(mProfilePage.getProfileName() + "." + iter_dbname) != null) { //$NON-NLS-1$
								ProfileManager.getInstance().getProfileByName(mProfilePage.getProfileName() + "." + iter_dbname).connect(null); //$NON-NLS-1$
							}
			 			}
					}
					catch (ConnectionProfileException e) {
						ExceptionHandler.showException(getShell(), ConnectivityUIPlugin
								.getDefault().getResourceString(
										"NewConnectionProfileWizard.create.failure"),  //$NON-NLS-1$
								e.getLocalizedMessage(), e);
						return false;
					}
				}
				success = true;
			}		
		}
		return success;
	}
}