/*******************************************************************************
 * Copyright (c) 2005 -- 2007 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.sybase.asa;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.eclipse.datatools.connectivity.ConnectionProfileConstants;
import org.eclipse.datatools.connectivity.db.generic.IDBConnectionProfileConstants;
import org.eclipse.datatools.connectivity.db.generic.IDBDriverDefinitionConstants;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizardPage;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.datatools.enablement.sybase.IJDBCConnectionProfileConstants;
import org.eclipse.datatools.enablement.sybase.asa.ui.JDBCASAProfileTabs;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;



/**
 * This class gathers the properties for an ASA or ASE JDBC connection
 * profile.
 * 
 * @author brianf
 */
public class JDBCASAPropertyWizardPage extends BaseWizardPage {

	// ui pieces
	private JDBCASAProfileTabs mASAProfileTabs = null;
	private Button mPingButton;
	
	// tab flags
	protected boolean mShowFilterTab = false;
	protected boolean mShowOptionalTab = true;

	/**
	 * Constructor
	 * @param pageName
	 */
	public JDBCASAPropertyWizardPage(String pageName) {
		super(pageName);
		setTitle(JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.title")); //$NON-NLS-1$
		setDescription(JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.msg")); //$NON-NLS-1$
	}

	/*
	 *  (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		Composite content = new Composite(parent,SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		content.setLayout(layout);
		
		this.mASAProfileTabs = createTabs();
		if (getWizard() instanceof NewJDBCASAConnectionProfileWizard) {
			NewJDBCASAConnectionProfileWizard ncpw = (NewJDBCASAConnectionProfileWizard) getWizard();
			String providerId = ncpw.getProfileProviderID();
			this.mASAProfileTabs.setProviderID(providerId);
		}

		this.mASAProfileTabs.setShowOptionalTab(this.mShowOptionalTab);
		this.mASAProfileTabs.setShowFilterTab(this.mShowFilterTab);

		this.mASAProfileTabs.createControl(content);
		this.mASAProfileTabs.addChangeListener( new ChangeListener() {

			public void stateChanged(ChangeEvent arg0) {
				isValid();
			}
		} );
		
        this.mPingButton = new Button( content, SWT.PUSH);
        GridData pingData = new GridData();
        pingData.horizontalSpan = 2;
        pingData.horizontalAlignment = GridData.END;
        this.mPingButton.setLayoutData(pingData);
        this.mPingButton.setText(JDBCASAProfileMessages.getString("JDBCPropertyWizardPage.PingButton")); //$NON-NLS-1$
        this.mPingButton.addSelectionListener( new SelectionListener () {

			public void widgetSelected(SelectionEvent e) {
				ping();
			}

			public void widgetDefaultSelected(SelectionEvent e) {
				widgetSelected(e);
			}
		});
		
		setControl(content);
		if (this.mASAProfileTabs.getDriverCombo().getCombo().getItemCount() == 1) {
			this.mASAProfileTabs.getDriverCombo().getCombo().select(0);
		}
		isValid();
	}

    protected JDBCASAProfileTabs createTabs()
    {
        return new JDBCASAProfileTabs();
    }
	
	private void ping() {
		ConnectionProfile tempProfile = new ConnectionProfile("tempJDBCForPing","empty", //$NON-NLS-1$ //$NON-NLS-2$
				mASAProfileTabs.getProviderID());
        Properties props = new Properties();
        props.setProperty(ConnectionProfileConstants.PROP_DRIVER_DEFINITION_ID,
        		this.getDriverID());
        props.setProperty(IDBConnectionProfileConstants.CONNECTION_PROPERTIES_PROP_ID,
        		this.getDBConnProps());
        props.setProperty(IDBDriverDefinitionConstants.PASSWORD_PROP_ID,
        		this.getDBPWD());
        props.setProperty(IDBDriverDefinitionConstants.USERNAME_PROP_ID,
        		this.getDBUID());
        props.setProperty(IDBDriverDefinitionConstants.DRIVER_CLASS_PROP_ID,
        		this.getDriverClass());

//		String port = this.getPort();
//		String host = this.getHost();
//		String dbName = this.getDBName();
		
//        String driverURL = "jdbc:sybase:Tds:" + host +  //$NON-NLS-1$
//			":" + port + "/" + dbName;  //$NON-NLS-1$//$NON-NLS-2$
		//Change for CR 377213-1
//		String driverURL = JDBCASAProfilePlugin.makeDriverURL(host, port, ""); //$NON-NLS-1$
		String driverURL = this.mASAProfileTabs.getURL();

        props.setProperty(IDBDriverDefinitionConstants.URL_PROP_ID,
        		driverURL);
        
        props.setProperty(IJDBCConnectionProfileConstants.PROP_CATALOG,
        		this.getCatalog());
        props.setProperty(IJDBCConnectionProfileConstants.PROP_SCHEMA,
        		this.getSchema());
        props.setProperty(IJDBCConnectionProfileConstants.PROP_SPNAME,
        		this.getProcName());
        props.setProperty(IJDBCConnectionProfileConstants.PROP_HOST,
        		this.getHost());
        props.setProperty(IJDBCConnectionProfileConstants.PROP_DB_NAME,
        		this.getDBName());
        props.setProperty(IJDBCConnectionProfileConstants.PROP_PORT,
        		this.getPort());
        
        tempProfile.setBaseProperties(props);
        
        PingJob job = new PingJob(this.getShell(), tempProfile);
        job.schedule();
	}
	
	/**
	 * Get the driver class name from the driver instance.
	 * @return
	 */
	public String getDriverClass() {
		return this.mASAProfileTabs.getDriverClass();
	}

	/**
	 * Get the jar list from the driver instance.
	 * @return
	 */
	public String getDriverJarList() {
		return this.mASAProfileTabs.getDriverJarList();
	}
	
	public String getXAConnectString() {
		return this.mASAProfileTabs.getNamedPropertyFromDriverInstance("xaConnectString"); //$NON-NLS-1$
	}

	public String getXAConnectClass() {
		return this.mASAProfileTabs.getNamedPropertyFromDriverInstance("xaConnectClass"); //$NON-NLS-1$
	}

	/**
	 * Get the sample URL from the driver instance.
	 * @return
	 */
	public String getDriverURL() {
		return this.mASAProfileTabs.getDriverURL();
	}

	/**
	 * Get the user name
	 * @return
	 */
	public String getDBUID() {
		return this.mASAProfileTabs.getDBUID();
	}

	/**
	 * Get the password
	 * @return
	 */
	public String getDBPWD() {
		return this.mASAProfileTabs.getDBPWD();
	}

	/**
	 * Get the optional connection properties
	 * @return
	 */
	public String getDBConnProps() {
		return this.mASAProfileTabs.getDBConnProps();
	}
	
	/**
	 * Get the URL for the CP
	 * @return
	 */
	public String getURL() {
		return this.mASAProfileTabs.getURL();
	}

	/**
	 * Get the driver name
	 * @return
	 */
	public String getDriverName() {
		return this.mASAProfileTabs.getDriverName();
	}
	
	/**
	 * Get the driver ID
	 * @return
	 */
	public String getDriverID() {
		return this.mASAProfileTabs.getDriverID();
	}

	/**
	 * Get the catalog
	 * @return
	 */
	public String getCatalog() {
		return this.mASAProfileTabs.getCatalog();
	}
	public String getSchema() {
		return this.mASAProfileTabs.getSchema();
	}
	public String getProcName() {
		return this.mASAProfileTabs.getProcName();
	}
	public String getDBName() {
		return this.mASAProfileTabs.getDBName();
	}
	public String getHost() {
		return this.mASAProfileTabs.getHostName();
	}
	public String getPort() {
		return this.mASAProfileTabs.getPortName();
	}

	/* (non-Javadoc)
	 * @see com.sybase.suade.common.ui.wizards.ISummaryDataSource#getSummaryData()
	 */
	public List getSummaryData() {
        List data = new ArrayList();

        data
                .add(new String[] {
                		JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.driverName.label"), //$NON-NLS-1$
                        getDriverName()});

        data
		        .add(new String[] {
		        		JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.connProps.label"), //$NON-NLS-1$
		                getDBConnProps()});

        data
		        .add(new String[] {
		        		JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.host.label"), //$NON-NLS-1$
		                getHost()});

        data
		        .add(new String[] {
		        		JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.port.label"), //$NON-NLS-1$
		                getPort()});

        data
				.add(new String[] {
						JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.userName.label"), //$NON-NLS-1$
		                getDBUID()});

		String pwdMask = ""; //$NON-NLS-1$
		if (getDBPWD() != null && getDBPWD().length() > 0) {
			for (int i=0; i < getDBPWD().length(); i++) {
				pwdMask = pwdMask + "*"; //$NON-NLS-1$
			}
		}
		
		data
				.add(new String[] {
						JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.password.label"), //$NON-NLS-1$
						pwdMask});

		data
				.add(new String[] {
						JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.driverClass.label"), //$NON-NLS-1$
				        getDriverClass()});
		
//		data
//				.add(new String[] {
//				        JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.URL.label"), //$NON-NLS-1$
//				        getURL()});
		
		data
				.add(new String[] {
						JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.catalog.label"), //$NON-NLS-1$
				        getCatalog()});

		data
				.add(new String[] {
						JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.schema.label"), //$NON-NLS-1$
				        getSchema()});

		data
				.add(new String[] {
						JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.procedureName.label"), //$NON-NLS-1$
				        getProcName()});

		return data;
	}

	private boolean isValid() {
		super.setErrorMessage(null);
		boolean isValid = this.mASAProfileTabs.isValid();
		if ( !isValid ) { //this.mProfileTabs.getErrorMessage() != null) {
			setPageComplete(false);
			super.setErrorMessage( this.mASAProfileTabs.getErrorMessage());
			return false;
		}
		else {
			setPageComplete(true);
		}
		return true;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.DialogPage#setErrorMessage(java.lang.String)
	 */
	public void setErrorMessage(String newMessage) {
		super.setErrorMessage(newMessage);
		isValid();
	}

    /**
	 * @return
	 */
	public boolean getShowFilterTab() {
		return this.mShowFilterTab;
	}
	/**
	 * @param flag
	 */
	public void setShowFilterTab( boolean flag ) {
		this.mShowFilterTab = flag;
	}
	/**
	 * @return
	 */
	public boolean getShowOptionalTab() {
		return this.mShowOptionalTab;
	}
	/**
	 * @param flag
	 */
	public void setShowOptionalTab( boolean flag ) {
		this.mShowOptionalTab = flag;
	}

	/**
	 * Get the vendor
	 * 
	 * @return
	 */
	public String getVendor() {
		String vendor = ""; //$NON-NLS-1$
		if (this.mASAProfileTabs != null) {
			vendor = this.mASAProfileTabs.getNamedPropertyFromDriverInstance("Vendor"); //$NON-NLS-1$
		}
		return vendor;
	}

	/**
	 * Get the version
	 * 
	 * @return
	 */
	public String getVersion() {
		String version = ""; //$NON-NLS-1$
		if (this.mASAProfileTabs != null) {
			version = this.mASAProfileTabs.getNamedPropertyFromDriverInstance("Version"); //$NON-NLS-1$
		}
		return version;
	}

	/**
	 * Get the password
	 * 
	 * @return
	 */
	public boolean getSaveDBPWD() {
		return this.mASAProfileTabs.getSaveDBPWD();
	}
}
